/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsrpgtweaks.xp_module.entity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import io.redspace.ironsrpgtweaks.IronsRpgTweaks;
import io.redspace.ironsrpgtweaks.xp_module.entity.XpCatalyst;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class XpCatalystRenderer
extends EntityRenderer<XpCatalyst> {
    private static final ResourceLocation EXPERIENCE_ORB_LOCATION = new ResourceLocation("textures/entity/experience_orb.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110467_((ResourceLocation)EXPERIENCE_ORB_LOCATION);
    public static final ModelLayerLocation MODEL_LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("irons_rpg_tweaks", "xp_catalyst_model"), "main");
    private static ResourceLocation ORB_TEXTURE = IronsRpgTweaks.id("textures/entity/xp_catalyst/xp_catalyst_orb.png");
    private static ResourceLocation SOLID_TEXTURE = IronsRpgTweaks.id("textures/entity/xp_catalyst/solid.png");
    private final ModelPart orb;
    private final ModelPart swirl;
    private final ModelPart swirl2;
    static final Vec3 green = new Vec3((double)0.15f, 1.0, (double)0.2f);
    static final Vec3 yellow = new Vec3((double)0.9f, (double)0.9f, (double)0.2f);
    static final Vec3 white = new Vec3(1.0, 1.0, 1.0);
    static final Vec3 purple = new Vec3(1.0, (double)0.63f, 1.0);

    public XpCatalystRenderer(EntityRendererProvider.Context context) {
        super(context);
        ModelPart modelpart = context.m_174023_(MODEL_LAYER_LOCATION);
        this.orb = modelpart.m_171324_("orb");
        this.swirl = modelpart.m_171324_("swirl");
        this.swirl2 = modelpart.m_171324_("swirl2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        partdefinition.m_171599_("orb", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partdefinition.m_171599_("swirl", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        partdefinition.m_171599_("swirl2", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171481_(-4.0f, -4.0f, -4.0f, 8.0f, 8.0f, 8.0f), PartPose.f_171404_);
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)8, (int)8);
    }

    public void render(XpCatalyst entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int light) {
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, entity.m_20191_().m_82376_() * 0.5 + (double)entity.getVisualYOffset(partialTicks), 0.0);
        float scale = 1.0f + Mth.m_14031_((float)(((float)entity.f_19797_ + partialTicks) * 0.06f)) * 0.05f;
        this.renderXpOrb(poseStack, bufferSource, entity.f_19797_, partialTicks);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_85841_(0.6f, 0.6f, 0.6f);
        float f = (float)entity.f_19797_ + partialTicks;
        poseStack.m_85836_();
        poseStack.m_85841_(0.4f, 0.4f, 0.4f);
        float orbColorPeriod = (Mth.m_14031_((float)(f * 0.04f)) + 1.0f) * 0.5f;
        float colorPeriod = (Mth.m_14031_((float)(f * 0.08f)) + 1.0f) * 0.5f;
        float swirlX = Mth.m_14089_((float)(0.05f * f)) * 90.0f;
        float swirlY = Mth.m_14031_((float)(0.05f * f)) * 90.0f;
        float swirlZ = Mth.m_14089_((float)(0.05f * f + 5464.0f)) * 90.0f;
        Vec3 orbGradient1 = green.m_82549_(yellow.m_82546_(green).m_82490_((double)orbColorPeriod));
        Vec3 orbGradient2 = white.m_82549_(purple.m_82546_(white).m_82490_((double)orbColorPeriod));
        Vec3 orbGradient3 = orbGradient1.m_82549_(orbGradient2.m_82546_(orbGradient1).m_82490_((double)colorPeriod));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(swirlX * 0.45f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(swirlY * 0.45f));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(swirlZ * 0.45f));
        VertexConsumer consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)SOLID_TEXTURE));
        this.orb.m_104306_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, (float)orbGradient3.f_82479_, (float)orbGradient3.f_82480_, (float)orbGradient3.f_82481_, 1.0f);
        poseStack.m_85849_();
        consumer = bufferSource.m_6299_(RenderType.m_110458_((ResourceLocation)this.getTextureLocation(entity)));
        poseStack.m_252781_(Axis.f_252529_.m_252977_(swirlX));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(swirlY));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(swirlZ));
        Vec3 rimGradient = green.m_82549_(yellow.m_82546_(green).m_82490_((double)colorPeriod));
        Vec3 rimGradientInverted = green.m_82549_(yellow.m_82546_(green).m_82490_((double)(1.0f - colorPeriod)));
        this.orb.m_104306_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, (float)rimGradient.f_82479_, (float)rimGradient.f_82480_, (float)rimGradient.f_82481_, 1.0f);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(swirlZ));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(swirlX));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(swirlY));
        poseStack.m_85841_(1.5f, 1.5f, 1.5f);
        this.swirl.m_104306_(poseStack, consumer, 0xF000F0, OverlayTexture.f_118083_, (float)rimGradientInverted.f_82479_, (float)rimGradientInverted.f_82480_, (float)rimGradientInverted.f_82481_, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)entity, yaw, partialTicks, poseStack, bufferSource, light);
    }

    public ResourceLocation getTextureLocation(XpCatalyst entity) {
        return ORB_TEXTURE;
    }

    private void renderXpOrb(PoseStack pMatrixStack, MultiBufferSource pBuffer, float tickCount, float pPartialTicks) {
        pMatrixStack.m_85836_();
        float scale = Mth.m_14031_((float)((tickCount + pPartialTicks) * 0.4f)) * 0.125f + 1.0f;
        float scale2 = Mth.m_14089_((float)((tickCount + pPartialTicks + 345.0f) * 0.6f)) * 0.06f + 1.0f;
        pMatrixStack.m_85841_(scale *= scale2, scale, scale);
        int i = 6;
        float f = (float)(i % 4 * 16 + 0) / 64.0f;
        float f1 = (float)(i % 4 * 16 + 16) / 64.0f;
        float f2 = (float)(i / 4 * 16 + 0) / 64.0f;
        float f3 = (float)(i / 4 * 16 + 16) / 64.0f;
        float f8 = (tickCount + pPartialTicks) / 2.0f;
        int j = (int)((Mth.m_14031_((float)(f8 + 0.0f)) + 1.0f) * 0.5f * 255.0f);
        int l = (int)((Mth.m_14031_((float)(f8 + 4.1887903f)) + 1.0f) * 0.1f * 255.0f);
        pMatrixStack.m_85837_(0.0, (double)0.1f, 0.0);
        pMatrixStack.m_252781_(this.f_114476_.m_253208_());
        pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        float f9 = 0.3f;
        pMatrixStack.m_85841_(0.3f, 0.3f, 0.3f);
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RENDER_TYPE);
        PoseStack.Pose posestack$pose = pMatrixStack.m_85850_();
        Matrix4f matrix4f = posestack$pose.m_252922_();
        Matrix3f matrix3f = posestack$pose.m_252943_();
        XpCatalystRenderer.vertex(vertexconsumer, matrix4f, matrix3f, -0.5f, -0.75f, j, 255, l, f, f3, 0xF000F0);
        XpCatalystRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 0.5f, -0.75f, j, 255, l, f1, f3, 0xF000F0);
        XpCatalystRenderer.vertex(vertexconsumer, matrix4f, matrix3f, 0.5f, 0.25f, j, 255, l, f1, f2, 0xF000F0);
        XpCatalystRenderer.vertex(vertexconsumer, matrix4f, matrix3f, -0.5f, 0.25f, j, 255, l, f, f2, 0xF000F0);
        pMatrixStack.m_85849_();
    }

    private static void vertex(VertexConsumer pBuffer, Matrix4f pMatrix, Matrix3f pMatrixNormal, float pX, float pY, int pRed, int pGreen, int pBlue, float pTexU, float pTexV, int pPackedLight) {
        pBuffer.m_5483_((double)pX, (double)pY, 0.0).m_6122_(pRed, pGreen, pBlue, 128).m_7421_(pTexU, pTexV).m_86008_(OverlayTexture.f_118083_).m_85969_(pPackedLight).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
    }
}

