/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform;

import java.nio.file.Path;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.popcraft.chunky.platform.Border;
import org.popcraft.chunky.platform.Player;
import org.popcraft.chunky.platform.util.Location;

public interface World {
    public String getName();

    public String getKey();

    public CompletableFuture<Boolean> isChunkGenerated(int var1, int var2);

    public CompletableFuture<Void> getChunkAtAsync(int var1, int var2);

    public UUID getUUID();

    public int getSeaLevel();

    public Location getSpawn();

    public Border getWorldBorder();

    public int getElevation(int var1, int var2);

    public int getMaxElevation();

    public void playEffect(Player var1, String var2);

    public void playSound(Player var1, String var2);

    public Optional<Path> getDirectory(String var1);

    default public Optional<Path> getEntitiesDirectory() {
        return this.getDirectory("entities");
    }

    default public Optional<Path> getPOIDirectory() {
        return this.getDirectory("poi");
    }

    default public Optional<Path> getRegionDirectory() {
        return this.getDirectory("region");
    }
}

