/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.item;

import galena.oreganized.OreganizedConfig;
import galena.oreganized.content.block.ICrystalGlass;
import galena.oreganized.index.OBlocks;
import galena.oreganized.index.OTags;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;

public class ScribeItem
extends Item {
    private static final Map<Block, Supplier<Block>> GROOVED_BLOCKS = new HashMap<Block, Supplier<Block>>();

    public static void registerGroovedBlock(Block from, Supplier<Block> to) {
        GROOVED_BLOCKS.put(from, to);
    }

    public static Set<Map.Entry<Block, Supplier<Block>>> getGroovedBlocks() {
        return GROOVED_BLOCKS.entrySet();
    }

    public ScribeItem(Item.Properties properties) {
        super(properties);
    }

    public boolean m_6813_(ItemStack stack, Level level, BlockState state, BlockPos pos, LivingEntity user) {
        if (!level.f_46443_ && state.m_60800_((BlockGetter)level, pos) != 0.0f) {
            stack.m_41622_(1, user, it -> it.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public float m_8102_(ItemStack stack, BlockState state) {
        if (state.m_204336_(OTags.Blocks.MINEABLE_WITH_SCRIBE)) {
            return 32.0f;
        }
        if (this.isCorrectToolForDrops(stack, state)) {
            return 0.3f;
        }
        return super.m_8102_(stack, state);
    }

    public boolean dropsLikeSilktouch(ItemStack stack, BlockState state) {
        return this.m_8096_(state) && !this.shouldNotSilktouch(stack, state);
    }

    private boolean shouldNotSilktouch(ItemStack stack, BlockState state) {
        return state.m_204336_(OTags.Blocks.SILKTOUCH_WITH_SCRIBE_BLACKLIST);
    }

    public boolean m_8096_(BlockState state) {
        if (((Boolean)OreganizedConfig.COMMON.scribeSilkTouchStone.get()).booleanValue()) {
            return state.m_204336_(OTags.Blocks.SILKTOUCH_WITH_SCRIBE);
        }
        return state.m_204336_(OTags.Blocks.MINEABLE_WITH_SCRIBE);
    }

    public boolean m_6832_(ItemStack stack, ItemStack repairStack) {
        return repairStack.m_150930_(Items.f_151049_);
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentCategory.DIGGER) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    private InteractionResult replaceBlock(UseOnContext context, BlockState to, boolean particles) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState from = level.m_8055_(pos);
        level.m_46597_(pos, to);
        level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223719_((Entity)context.m_43723_(), (BlockState)from));
        if (particles) {
            level.m_142052_(pos, from);
        }
        if (context.m_43723_() != null) {
            context.m_43723_().m_5496_(SoundEvents.f_11998_, 1.0f, 1.5f);
            context.m_43722_().m_41622_(1, (LivingEntity)context.m_43723_(), player -> player.m_21190_(context.m_43724_()));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockState state = context.m_43725_().m_8055_(context.m_8083_());
        if (state.m_61138_((Property)ICrystalGlass.TYPE)) {
            Integer type = (Integer)state.m_61143_((Property)ICrystalGlass.TYPE);
            return this.replaceBlock(context, (BlockState)state.m_61124_((Property)ICrystalGlass.TYPE, (Comparable)Integer.valueOf((type + 1) % 4)), true);
        }
        Supplier<Block> grooved = GROOVED_BLOCKS.get(state.m_60734_());
        if (grooved != null) {
            return this.replaceBlock(context, grooved.get().m_49966_(), true);
        }
        if (state.m_60734_() instanceof AmethystClusterBlock && !state.m_60713_(Blocks.f_152495_)) {
            ItemStack tool = new ItemStack((ItemLike)Items.f_42385_);
            tool.m_41751_(context.m_43722_().m_41783_());
            Block.m_49881_((BlockState)state, (Level)context.m_43725_(), (BlockPos)context.m_8083_(), null, (Entity)context.m_43723_(), (ItemStack)tool);
            return this.replaceBlock(context, Blocks.f_152495_.m_152465_(state), false);
        }
        return super.m_6225_(context);
    }

    static {
        ScribeItem.registerGroovedBlock(Blocks.f_50126_, OBlocks.GROOVED_ICE);
        ScribeItem.registerGroovedBlock(Blocks.f_50354_, OBlocks.GROOVED_PACKED_ICE);
        ScribeItem.registerGroovedBlock(Blocks.f_50568_, OBlocks.GROOVED_BLUE_ICE);
    }
}

