/*
 * Decompiled with CFR 0.152.
 */
package galena.oreganized.content.block;

import galena.oreganized.content.entity.GargoyleBlockEntity;
import galena.oreganized.index.OBlockEntities;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class GargoyleBlock
extends HorizontalDirectionalBlock
implements EntityBlock {
    public static final EnumProperty<AttachmentType> ATTACHMENT = EnumProperty.m_61587_((String)"attachment", AttachmentType.class);
    public final Map<BlockState, VoxelShape> SHAPES = this.m_152458_(this::getShapeFor);
    public static final DispenseItemBehavior DISPENSE_ITEM_BEHAVIOR = (source, stack) -> {
        BlockState dispenser = source.m_6414_();
        Direction facing = (Direction)dispenser.m_61143_((Property)DispenserBlock.f_52659_);
        BlockPos targetPos = source.m_7961_().m_121945_(facing);
        BlockEntity target = source.m_7727_().m_7702_(targetPos);
        if (target instanceof GargoyleBlockEntity) {
            GargoyleBlockEntity gargoyle = (GargoyleBlockEntity)target;
            gargoyle.interact((Level)source.m_7727_(), targetPos, null, stack, false);
        }
        return stack;
    };

    public GargoyleBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.SOUTH)).m_61124_(ATTACHMENT, (Comparable)((Object)AttachmentType.FLOOR)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, ATTACHMENT});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState base = super.m_5573_(context);
        Direction clickedFace = context.m_43719_();
        if (clickedFace.m_122434_().m_122479_() && !context.m_7058_()) {
            return (BlockState)((BlockState)base.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)clickedFace.m_122424_())).m_61124_(ATTACHMENT, (Comparable)((Object)AttachmentType.WALL));
        }
        return (BlockState)((BlockState)base.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_())).m_61124_(ATTACHMENT, (Comparable)((Object)AttachmentType.FLOOR));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (type != OBlockEntities.GARGOYLE.get()) {
            return null;
        }
        BlockEntityTicker ticker = GargoyleBlockEntity::tick;
        return ticker;
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GargoyleBlockEntity) {
            GargoyleBlockEntity gargoyle = (GargoyleBlockEntity)blockEntity;
            return gargoyle.getAnalogOutputSignal();
        }
        return super.m_6782_(state, level, pos);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof GargoyleBlockEntity) {
            GargoyleBlockEntity gargoyle = (GargoyleBlockEntity)blockEntity;
            ItemStack stack = player.m_21120_(hand);
            return gargoyle.interact(level, pos, player, stack, false);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public static void dripParticles(BlockState state, Level level, BlockPos pos, RandomSource random, ParticleOptions type) {
        double spread = random.m_188500_() * 0.1 - 0.05;
        Vec3 offset = AttachmentType.offset(state, pos, spread);
        level.m_7106_(type, offset.f_82479_, offset.f_82480_, offset.f_82481_, 0.0, 0.0, 0.0);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new GargoyleBlockEntity(pos, state);
    }

    protected VoxelShape getShapeFor(BlockState state) {
        boolean zSize;
        Direction facing = (Direction)state.m_61143_((Property)f_54117_);
        AttachmentType attachment = (AttachmentType)((Object)state.m_61143_(ATTACHMENT));
        boolean xOffset = facing == Direction.EAST;
        boolean xSize = facing.m_122434_() == Direction.Axis.X;
        boolean zOffset = facing == Direction.SOUTH;
        boolean bl = zSize = facing.m_122434_() == Direction.Axis.Z;
        if (attachment == AttachmentType.FLOOR) {
            VoxelShape base = GargoyleBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
            VoxelShape legs = GargoyleBlock.m_49796_((double)((double)xOffset * 11.0), (double)2.0, (double)((double)zOffset * 11.0), (double)((double)xOffset * 11.0 + 5.0 * (double)xSize + 16.0 * (double)zSize), (double)12.0, (double)((double)zOffset * 11.0 + 5.0 * (double)zSize + 16.0 * (double)xSize));
            VoxelShape arms = GargoyleBlock.m_49796_((double)((double)xOffset * 12.0 + (double)zSize - (double)facing.m_122429_() * 7.0), (double)2.0, (double)((double)zOffset * 12.0 + (double)xSize - (double)facing.m_122431_() * 7.0), (double)((double)xOffset * 12.0 + 4.0 * (double)xSize + 15.0 * (double)zSize - (double)facing.m_122429_() * 7.0), (double)17.0, (double)((double)zOffset * 12.0 + 4.0 * (double)zSize + 15.0 * (double)xSize - (double)facing.m_122431_() * 7.0));
            VoxelShape body = GargoyleBlock.m_49796_((double)((double)zSize * 2.0 + (double)xOffset * 5.0 + 1.0), (double)7.0, (double)((double)xSize * 2.0 + (double)zOffset * 5.0 + 1.0), (double)((double)xSize * 10.0 + (double)xOffset * 5.0 + (double)zSize * 13.0), (double)16.0, (double)((double)zSize * 10.0 + (double)zOffset * 5.0 + (double)xSize * 13.0));
            VoxelShape head = GargoyleBlock.m_49796_((double)((double)zSize * 4.0 + (double)xSize * 10.0 - (double)xOffset * 10.0), (double)7.0, (double)((double)xSize * 4.0 + (double)zSize * 10.0 - (double)zOffset * 10.0), (double)((double)zSize * 12.0 + (double)xSize * 16.0 - (double)xOffset * 10.0), (double)15.0, (double)((double)xSize * 12.0 + (double)zSize * 16.0 - (double)zOffset * 10.0));
            return Shapes.m_83124_((VoxelShape)base, (VoxelShape[])new VoxelShape[]{legs, arms, body, head});
        }
        if (attachment == AttachmentType.WALL) {
            VoxelShape base = GargoyleBlock.m_49796_((double)((double)xOffset * 14.0), (double)0.0, (double)((double)zOffset * 14.0), (double)((double)xOffset * 14.0 + 2.0 * (double)xSize + 16.0 * (double)zSize), (double)16.0, (double)((double)zOffset * 14.0 + 2.0 * (double)zSize + 16.0 * (double)xSize));
            VoxelShape head = GargoyleBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)8.0).m_83216_((double)facing.m_122429_() * -1.25, 0.3125, (double)facing.m_122431_() * -1.25).m_83216_((double)xOffset * 0.5, 0.0, (double)zOffset * 0.5).m_83216_((double)zSize * 0.25, 0.0, (double)xSize * 0.25);
            VoxelShape body = GargoyleBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)9.0, (double)9.0, (double)9.0).m_83216_((double)facing.m_122429_() * -11.0 / 16.0, 0.4375, (double)facing.m_122431_() * -11.0 / 16.0).m_83216_((double)xOffset * 7.0 / 16.0, 0.0, (double)zOffset * 7.0 / 16.0).m_83216_((double)zSize * 0.25, 0.0, (double)xSize * 0.25);
            VoxelShape log = GargoyleBlock.m_49796_((double)((double)xOffset * 14.0), (double)0.0, (double)((double)zOffset * 14.0), (double)((double)xOffset * 14.0 + 4.0 * (double)xSize + 4.0 * (double)zSize), (double)4.0, (double)((double)zOffset * 14.0 + 4.0 * (double)zSize + 16.0 * (double)xSize)).m_83216_((double)xSize * 0.125 - (double)xOffset * 0.375, 0.0, (double)zSize * 0.125 - (double)zOffset * 0.375);
            return Shapes.m_83124_((VoxelShape)base, (VoxelShape[])new VoxelShape[]{body, head, log});
        }
        return GargoyleBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return this.SHAPES.get(state);
    }

    public static enum AttachmentType implements StringRepresentable
    {
        FLOOR("floor", 0.55, 0.2),
        WALL("wall", 1.3, 0.12);

        private final String name;
        private final double horizontalOffset;
        private final double verticalOffset;

        private AttachmentType(String name, double horizontalOffset, double verticalOffset) {
            this.name = name;
            this.horizontalOffset = horizontalOffset;
            this.verticalOffset = verticalOffset;
        }

        public static Vec3 offset(BlockState state, BlockPos pos, double spread) {
            Direction facing = ((Direction)state.m_61143_((Property)HorizontalDirectionalBlock.f_54117_)).m_122424_();
            AttachmentType attachment = (AttachmentType)((Object)state.m_61143_(ATTACHMENT));
            double offsetX = facing.m_122434_() == Direction.Axis.X ? (double)facing.m_122429_() * attachment.horizontalOffset : spread;
            double offsetZ = facing.m_122434_() == Direction.Axis.Z ? (double)facing.m_122431_() * attachment.horizontalOffset : spread;
            double x = (double)pos.m_123341_() + 0.5 + offsetX;
            double y = (double)pos.m_123342_() + attachment.verticalOffset + 0.05;
            double z = (double)pos.m_123343_() + 0.5 + offsetZ;
            return new Vec3(x, y, z);
        }

        public String m_7912_() {
            return this.name;
        }
    }
}

