/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.recipe.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.level.Level;
import snownee.kiwi.data.DataModule;

public class KiwiShapelessRecipe
extends ShapelessRecipe {
    private boolean noContainers;
    private boolean trimmed;

    public KiwiShapelessRecipe(ShapelessRecipe rawRecipe, boolean noContainers) {
        super(rawRecipe.m_6423_(), rawRecipe.m_6076_(), rawRecipe.m_245232_(), rawRecipe.m_8043_(null), rawRecipe.m_7527_());
        this.noContainers = noContainers;
    }

    public boolean m_5818_(CraftingContainer craftingContainer, Level level) {
        this.trim();
        return super.m_5818_(craftingContainer, level);
    }

    public boolean m_8004_(int i, int j) {
        this.trim();
        return super.m_8004_(i, j);
    }

    private void trim() {
        if (this.trimmed) {
            return;
        }
        this.trimmed = true;
        this.m_7527_().removeIf(Ingredient::m_43947_);
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        if (this.noContainers) {
            return NonNullList.m_122780_((int)inv.m_6643_(), (Object)ItemStack.f_41583_);
        }
        return super.m_7457_((Container)inv);
    }

    public RecipeSerializer<?> m_7707_() {
        return DataModule.SHAPELESS.get();
    }

    public static class Serializer
    implements RecipeSerializer<KiwiShapelessRecipe> {
        public KiwiShapelessRecipe fromJson(ResourceLocation id, JsonObject o) {
            String s = GsonHelper.m_13851_((JsonObject)o, (String)"group", (String)"");
            NonNullList<Ingredient> nonnulllist = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)o, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            CraftingBookCategory category = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)o, (String)"category", null), (Enum)CraftingBookCategory.MISC);
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)o, (String)"result"));
            return new KiwiShapelessRecipe(new ShapelessRecipe(id, s, category, itemstack, nonnulllist), GsonHelper.m_13855_((JsonObject)o, (String)"no_containers", (boolean)false));
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray a) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < a.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)a.get(i));
                if (ingredient == Ingredient.f_43901_) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public KiwiShapelessRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            return new KiwiShapelessRecipe((ShapelessRecipe)RecipeSerializer.f_44077_.m_8005_(recipeId, buffer), buffer.readBoolean());
        }

        public void toNetwork(FriendlyByteBuf buffer, KiwiShapelessRecipe recipe) {
            RecipeSerializer.f_44077_.m_6178_(buffer, (Recipe)recipe);
            buffer.writeBoolean(recipe.noContainers);
        }
    }
}

