/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.datagen;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import snownee.kiwi.KiwiModule;
import snownee.kiwi.config.ConfigHandler;
import snownee.kiwi.config.ConfigUI;
import snownee.kiwi.config.KiwiConfigManager;
import snownee.kiwi.datagen.GameObjectLookup;
import snownee.kiwi.util.Util;

public class KiwiLanguageProvider
extends FabricLanguageProvider {
    protected final FabricDataOutput dataOutput;
    protected final String languageCode;

    public KiwiLanguageProvider(FabricDataOutput dataOutput) {
        this(dataOutput, "en_us");
    }

    public KiwiLanguageProvider(FabricDataOutput dataOutput, String languageCode) {
        super(dataOutput, languageCode);
        this.dataOutput = dataOutput;
        this.languageCode = languageCode;
    }

    public void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
    }

    public Optional<Path> createPath(String path, String extension) {
        return Optional.of(this.dataOutput.getForgeModContainer().getOwningFile().getFile().findResource(new String[]{"assets/%s/lang/%s.%s".formatted(this.dataOutput.getModId(), path, extension)}));
    }

    public void putExistingTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.putExistingTranslations(translationBuilder, this.languageCode + ".existing");
    }

    public void putExistingTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, String path) {
        try {
            Path existingFilePath = this.createPath(path, "json").orElseThrow();
            translationBuilder.add(existingFilePath);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public void putExistingYamlTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        this.putExistingYamlTranslations(translationBuilder, this.languageCode + ".existing");
    }

    public void putExistingYamlTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder, String path) {
        try {
            Path existingFilePath = this.createPath(path, "yaml").orElseThrow();
            try (BufferedReader reader = Files.newBufferedReader(existingFilePath);){
                Map map = Util.loadYaml(reader, Map.class);
                for (Map.Entry entry : map.entrySet()) {
                    translationBuilder.add((String)entry.getKey(), entry.getValue().toString());
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to add existing language file!", e);
        }
    }

    public CompletableFuture<?> m_213708_(CachedOutput writer) {
        TreeMap<String, String> translationEntries = new TreeMap<String, String>();
        this.preGenerate(translationEntries);
        if ("en_us".equals(this.languageCode)) {
            this.generateGameObjectsEntries(translationEntries);
            this.generateConfigEntries(translationEntries);
            this.generateTranslations((key, value) -> {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                if (translationEntries.containsKey(key)) {
                    throw new RuntimeException("Existing translation key found - " + key + " - Duplicate will be ignored.");
                }
                translationEntries.put(key, value);
            });
            FabricLanguageProvider.TranslationBuilder translationBuilder = (key, value) -> {
                Objects.requireNonNull(key);
                Objects.requireNonNull(value);
                translationEntries.put(key, value);
            };
            if (this.createPath("en_us.existing", "yaml").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false).booleanValue()) {
                this.putExistingYamlTranslations(translationBuilder);
            } else if (this.createPath("en_us.existing", "json").map(x$0 -> Files.exists(x$0, new LinkOption[0])).orElse(false).booleanValue()) {
                this.putExistingTranslations(translationBuilder);
            }
        }
        this.postGenerate(translationEntries);
        JsonObject langEntryJson = new JsonObject();
        for (Map.Entry<String, String> entry : translationEntries.entrySet()) {
            langEntryJson.addProperty(entry.getKey(), entry.getValue());
        }
        return DataProvider.m_253162_((CachedOutput)writer, (JsonElement)langEntryJson, (Path)this.getLangFilePath(this.languageCode));
    }

    protected void postGenerate(TreeMap<String, String> translationEntries) {
    }

    protected void preGenerate(TreeMap<String, String> translationEntries) {
    }

    protected void generateConfigEntries(Map<String, String> translationEntries) {
        Joiner joiner = Joiner.on((char)'.');
        for (ConfigHandler handler : KiwiConfigManager.allConfigs) {
            if (!Objects.equals(handler.getModId(), this.dataOutput.getModId()) || handler.getFileName().equals("test") || handler.getFileName().equals("kiwi-modules") || handler.getClazz().getDeclaredAnnotation(KiwiModule.Skip.class) != null) continue;
            String key = handler.getTranslationKey();
            if (Objects.equals(key, handler.getFileName())) {
                translationEntries.put("kiwi.config." + key, Util.friendlyText(key));
            }
            HashSet subCats = Sets.newHashSet();
            for (ConfigHandler.Value<?> value : handler.getValueMap().values()) {
                ConfigUI.Hide hide = value.getAnnotation(ConfigUI.Hide.class);
                if (hide != null) continue;
                ArrayList path = Lists.newArrayList((Object[])value.path.split("\\."));
                String title = Util.friendlyText((String)path.remove(path.size() - 1));
                String subCatKey = joiner.join((Iterable)path);
                if (!path.isEmpty() && !subCats.contains(subCatKey)) {
                    subCats.add(subCatKey);
                    translationEntries.put(handler.getModId() + ".config." + subCatKey, Util.friendlyText((String)path.get(path.size() - 1)));
                }
                translationEntries.put(value.translation, title);
                translationEntries.put(value.translation + ".desc", "");
            }
        }
    }

    private Path getLangFilePath(String code) {
        return this.dataOutput.m_245269_(PackOutput.Target.RESOURCE_PACK, "lang").m_245731_(new ResourceLocation(this.dataOutput.getModId(), code));
    }

    protected void generateGameObjectsEntries(Map<String, String> translationEntries) {
        this.generateGameObjectEntries(translationEntries, Registries.f_256747_, Block::m_7705_);
        this.generateGameObjectEntries(translationEntries, Registries.f_256913_, Item::m_5524_);
        this.generateGameObjectEntries(translationEntries, Registries.f_256939_, EntityType::m_20675_);
        this.generateGameObjectEntries(translationEntries, Registries.f_279569_, tab -> {
            Component component = tab.m_40786_();
            ComponentContents patt7609$temp = component.m_214077_();
            if (patt7609$temp instanceof TranslatableContents) {
                TranslatableContents contents = (TranslatableContents)patt7609$temp;
                return contents.m_237508_();
            }
            return null;
        });
        this.generateGameObjectEntries(translationEntries, Registries.f_256887_, stat -> net.minecraft.Util.m_137492_((String)"stat", (ResourceLocation)stat));
        this.generateGameObjectEntries(translationEntries, Registries.f_256929_, MobEffect::m_19481_);
    }

    protected <T> void generateGameObjectEntries(Map<String, String> translationEntries, ResourceKey<Registry<T>> registryKey, Function<T, String> keyMapper) {
        GameObjectLookup.allHolders(registryKey, this.dataOutput.getModId()).forEach(holder -> {
            String key = (String)keyMapper.apply(holder.m_203334_());
            if (key != null) {
                translationEntries.put(key, Util.friendlyText(holder.m_205785_().m_135782_().m_135815_()));
            }
        });
    }
}

