/*
 * Decompiled with CFR 0.152.
 */
package com.oierbravo.createmechanicalextruder.foundation.recipe.requirements;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirement;
import com.oierbravo.createmechanicalextruder.foundation.recipe.RecipeRequirementType;
import java.lang.constant.ConstantDescs;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BiomeRequirement
extends RecipeRequirement {
    public static final RecipeRequirementType<BiomeRequirement> TYPE = new BiomeRequirementType();
    public static final BiomeRequirement EMPTY = new BiomeRequirement();
    protected TagKey<Biome> biomeTagKey;
    protected ResourceKey<Biome> biomeResourceKey;

    public BiomeRequirement() {
    }

    public BiomeRequirement(TagKey<Biome> tag) {
        this.biomeTagKey = tag;
    }

    public BiomeRequirement(ResourceKey<Biome> key) {
        this.biomeResourceKey = key;
    }

    public BiomeRequirement(ResourceKey<Biome> key, TagKey<Biome> tag) {
        this.biomeResourceKey = key;
        this.biomeTagKey = tag;
    }

    public static BiomeRequirement of(ResourceKey<Biome> key) {
        return new BiomeRequirement(key);
    }

    public static BiomeRequirement of(TagKey<Biome> tag) {
        return new BiomeRequirement(tag);
    }

    public static BiomeRequirement of(ResourceKey<Biome> key, TagKey<Biome> tag) {
        return new BiomeRequirement(key, tag);
    }

    @Override
    public boolean test(Level pLevel, BlockEntity pBlockEntity) {
        if (this.biomeResourceKey == null && this.biomeTagKey == null) {
            return true;
        }
        Holder blockEntityBiome = pLevel.m_204166_(pBlockEntity.m_58899_());
        if (pLevel.m_5776_()) {
            return false;
        }
        Optional requiredBiomeHolder = pLevel.m_7654_().m_206579_().m_175515_(Registries.f_256952_).m_255303_().m_254902_(this.biomeResourceKey);
        if (requiredBiomeHolder.isPresent() && blockEntityBiome.m_203565_(((Holder.Reference)requiredBiomeHolder.get()).m_205785_())) {
            return true;
        }
        return pLevel.m_7654_().m_206579_().m_175515_(Registries.f_256952_).m_203431_(this.biomeTagKey).map(t -> t.m_203333_(blockEntityBiome)).orElse(false);
    }

    @Override
    public boolean isPresent() {
        return this.biomeTagKey != null || this.biomeResourceKey != null;
    }

    public String toString() {
        if (this.biomeTagKey == null && this.biomeResourceKey == null) {
            return null;
        }
        if (this.biomeResourceKey != null) {
            return this.biomeResourceKey.m_135782_().toString();
        }
        return this.biomeTagKey.f_203868_().toString();
    }

    @Override
    public RecipeRequirementType<?> getType() {
        return TYPE;
    }

    private static class BiomeRequirementType
    extends RecipeRequirementType<BiomeRequirement> {
        public BiomeRequirementType() {
            super("biome");
        }

        public BiomeRequirementType(String id) {
            super(id);
        }

        @Override
        public BiomeRequirement fromJson(JsonObject pJson) {
            if (GsonHelper.m_13900_((JsonObject)pJson, (String)"biome")) {
                ResourceKey biomeResourceKey = (ResourceKey)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_).parse((DynamicOps)JsonOps.INSTANCE, (Object)pJson.get("biome")).result().get();
                TagKey biomeTag = (TagKey)TagKey.m_203877_((ResourceKey)Registries.f_256952_).parse((DynamicOps)JsonOps.INSTANCE, (Object)pJson.get("biome")).result().get();
                return BiomeRequirement.of((ResourceKey<Biome>)biomeResourceKey, (TagKey<Biome>)biomeTag);
            }
            return EMPTY;
        }

        @Override
        public JsonObject toJson(JsonObject pJson, RecipeRequirement pRecipeRequirement) {
            if (!pRecipeRequirement.isPresent()) {
                return pJson;
            }
            pJson.addProperty("biome", pRecipeRequirement.toString());
            return pJson;
        }

        @Override
        public BiomeRequirement fromNetwork(FriendlyByteBuf buffer) {
            boolean hasRequirement = buffer.readBoolean();
            if (hasRequirement) {
                ResourceLocation rl = buffer.m_130281_();
                if (ConstantDescs.NULL.equals(rl)) {
                    return EMPTY;
                }
                return BiomeRequirement.of((TagKey<Biome>)TagKey.m_203882_((ResourceKey)Registries.f_256952_, (ResourceLocation)rl));
            }
            return EMPTY;
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer, RecipeRequirement pRecipeRequirement) {
            if (pRecipeRequirement == null) {
                pRecipeRequirement = new BiomeRequirement();
            }
            if (pRecipeRequirement instanceof BiomeRequirement) {
                buffer.writeBoolean(pRecipeRequirement.isPresent());
                if (pRecipeRequirement.isPresent()) {
                    TagKey<Biome> biome = ((BiomeRequirement)pRecipeRequirement).biomeTagKey;
                    buffer.m_130085_(biome.f_203868_());
                }
            }
        }
    }
}

