/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.common.gui;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedcore.util.SlotRange;
import net.p3pp3rf1y.sophisticatedstorage.SophisticatedStorage;
import net.p3pp3rf1y.sophisticatedstorage.block.DecorationTableBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;

public class DecorationTableMenu
extends AbstractContainerMenu
implements ISyncedContainer {
    private static final String SET_INHERITANCE_ACTION = "setInheritance";
    private static final ResourceLocation EMPTY_RED_DYE_SLOT_BACKGROUND = SophisticatedStorage.getRL("item/empty_red_dye_slot");
    private static final ResourceLocation EMPTY_GREEN_DYE_SLOT_BACKGROUND = SophisticatedStorage.getRL("item/empty_green_dye_slot");
    private static final ResourceLocation EMPTY_BLUE_DYE_SLOT_BACKGROUND = SophisticatedStorage.getRL("item/empty_blue_dye_slot");
    private static final ResourceLocation EMPTY_MATERIAL_SLOT_BACKGROUND = SophisticatedStorage.getRL("item/empty_material_slot");
    public static final int DECORATION_SLOT_PADDING = 12;
    private final DecorationTableBlockEntity blockEntity;
    private Slot resultSlot;
    private SlotRange decorationSlotRange;
    private SlotRange dyeSlotRange;
    private SlotRange storageSlotRange;
    private SlotRange playerSlotRange;
    @Nullable
    private Runnable slotChangedListener = null;
    private SlotItemHandler storageSlot;

    public DecorationTableMenu(int containerId, Player player, BlockPos pos) {
        super(ModBlocks.DECORATION_TABLE_CONTAINER_TYPE.get(), containerId);
        this.blockEntity = player.m_9236_().m_141902_(pos, (BlockEntityType)ModBlocks.DECORATION_TABLE_BLOCK_ENTITY_TYPE.get()).orElse(null);
        if (this.blockEntity == null) {
            throw new IllegalStateException("No block entity found at position " + String.valueOf(pos));
        }
        int y = this.addDecorationSlots();
        this.addStorageSlots();
        this.addPlayerSlots(player.m_150109_(), y += 14);
    }

    public void setSlotChangedListener(@Nullable Runnable listener) {
        this.slotChangedListener = listener;
    }

    public Slot getStorageSlot() {
        return this.storageSlot;
    }

    public List<ItemStack> getDecoratedPreviewStacks() {
        return this.blockEntity.getDecoratedPreviewStacks();
    }

    private void addStorageSlots() {
        ItemStackHandler storageBlock = this.blockEntity.getStorageBlock();
        this.storageSlot = new SlotItemHandler((IItemHandler)storageBlock, 0, this.m_38853_((int)this.dyeSlotRange.firstSlot()).f_40220_, this.m_38853_((int)3).f_40221_){

            public void m_6654_() {
                super.m_6654_();
                if (DecorationTableMenu.this.slotChangedListener != null) {
                    DecorationTableMenu.this.slotChangedListener.run();
                }
            }
        };
        this.m_38897_((Slot)this.storageSlot);
        this.storageSlotRange = new SlotRange(this.dyeSlotRange.firstSlot() + this.dyeSlotRange.numberOfSlots(), 1);
        this.resultSlot = new Slot((Container)new SimpleContainer(1){

            public ItemStack m_8020_(int index) {
                return DecorationTableMenu.this.blockEntity.getResult();
            }

            public ItemStack m_7407_(int index, int count) {
                return index == 0 ? DecorationTableMenu.this.blockEntity.extractResult(count) : ItemStack.f_41583_;
            }
        }, 0, this.storageSlot.f_40220_ + 18 + 18, this.storageSlot.f_40221_){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }

            public boolean m_8010_(Player player) {
                return super.m_8010_(player) && DecorationTableMenu.this.getMissingDyes().isEmpty();
            }

            public ItemStack m_6201_(int amount) {
                return super.m_6201_(amount);
            }

            public void m_142406_(Player player, ItemStack stack) {
                super.m_142406_(player, stack);
                if (player.m_9236_().m_5776_()) {
                    return;
                }
                DecorationTableMenu.this.blockEntity.consumeIngredientsOnCraft();
                DecorationTableMenu.this.blockEntity.getStorageBlock().extractItem(0, 1, false);
            }
        };
        this.m_38897_(this.resultSlot);
    }

    private int addDecorationSlots() {
        int xOffset = 8;
        int yOffset = 17;
        ItemStackHandler decorativeBlocks = this.blockEntity.getDecorativeBlocks();
        int x = xOffset;
        int y = yOffset;
        int slotIndex = 0;
        y = this.addDecorationSlot(decorativeBlocks, slotIndex, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 1, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 2, x, y, 12);
        this.addDecorationSlot(decorativeBlocks, 3, x, y, 12);
        y = yOffset + 18 + 12;
        y = this.addDecorationSlot(decorativeBlocks, 4, x += 48, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 5, x, y, 12);
        y = this.addDecorationSlot(decorativeBlocks, 6, x, y, 0);
        this.decorationSlotRange = new SlotRange(0, decorativeBlocks.getSlots());
        ItemStackHandler dyes = this.blockEntity.getDyes();
        this.m_38897_(new SlotItemHandler((IItemHandler)dyes, 0, x += 44, yOffset).setBackground(InventoryMenu.f_39692_, EMPTY_RED_DYE_SLOT_BACKGROUND));
        this.m_38897_(new SlotItemHandler((IItemHandler)dyes, 1, x += 18, yOffset).setBackground(InventoryMenu.f_39692_, EMPTY_GREEN_DYE_SLOT_BACKGROUND));
        this.m_38897_(new SlotItemHandler((IItemHandler)dyes, 2, x += 18, yOffset).setBackground(InventoryMenu.f_39692_, EMPTY_BLUE_DYE_SLOT_BACKGROUND));
        this.dyeSlotRange = new SlotRange(this.decorationSlotRange.firstSlot() + this.decorationSlotRange.numberOfSlots(), dyes.getSlots());
        return y;
    }

    private int addDecorationSlot(ItemStackHandler itemHandler, int slotIndex, int xOffset, int y, int yPadding) {
        this.m_38897_(new SlotItemHandler((IItemHandler)itemHandler, slotIndex, xOffset, y){

            public void m_6654_() {
                super.m_6654_();
                if (DecorationTableMenu.this.slotChangedListener != null) {
                    DecorationTableMenu.this.slotChangedListener.run();
                }
            }
        }.setBackground(InventoryMenu.f_39692_, EMPTY_MATERIAL_SLOT_BACKGROUND));
        y += 18;
        return y += yPadding;
    }

    private void addPlayerSlots(Inventory playerInventory, int y) {
        int playerSlotXOffset = 45;
        int hotbarPadding = 4;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.m_38897_(new Slot((Container)playerInventory, col + row * 9 + 9, playerSlotXOffset + col * 18, y + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            Slot slot = new Slot((Container)playerInventory, col, playerSlotXOffset + col * 18, y + 54 + hotbarPadding);
            this.m_38897_(slot);
        }
        this.playerSlotRange = new SlotRange(this.storageSlotRange.firstSlot() + this.storageSlotRange.numberOfSlots() + 1, 36);
    }

    public ItemStack m_7648_(Player player, int slotIndex) {
        Slot slot = this.m_38853_(slotIndex);
        ItemStack slotStack = slot.m_7993_();
        ItemStack slotStackCopy = slotStack.m_41777_();
        if (this.isPlayerSlot(slotIndex)) {
            if (this.blockEntity.getDecorativeBlocks().isItemValid(this.decorationSlotRange.firstSlot(), slotStack) && !this.moveItemStackTo(slotStack, this.decorationSlotRange, false)) {
                return ItemStack.f_41583_;
            }
            if (this.isValidDye(slotStack) && !this.moveItemStackTo(slotStack, this.dyeSlotRange, false)) {
                return ItemStack.f_41583_;
            }
            if (this.blockEntity.getStorageBlock().isItemValid(0, slotStack) && !this.moveItemStackTo(slotStack, this.storageSlotRange, false)) {
                return ItemStack.f_41583_;
            }
        } else if (!this.moveItemStackTo(slotStack, this.playerSlotRange, true)) {
            return ItemStack.f_41583_;
        }
        if (slotStackCopy.m_41613_() == slotStack.m_41613_()) {
            return ItemStack.f_41583_;
        }
        this.blockEntity.updateResultAndSetChanged();
        slot.m_142406_(player, slotStackCopy);
        return slotStackCopy;
    }

    private boolean isValidDye(ItemStack stack) {
        ItemStackHandler dyes = this.blockEntity.getDyes();
        for (int slot = 0; slot < dyes.getSlots(); ++slot) {
            if (!dyes.isItemValid(slot, stack)) continue;
            return true;
        }
        return false;
    }

    private boolean moveItemStackTo(ItemStack stack, SlotRange slotRange, boolean reverse) {
        return this.m_38903_(stack, slotRange.firstSlot(), slotRange.firstSlot() + slotRange.numberOfSlots(), reverse);
    }

    private boolean isPlayerSlot(int slotIndex) {
        return this.playerSlotRange.isInRange(slotIndex);
    }

    public SlotRange getDyeSlotRange() {
        return this.dyeSlotRange;
    }

    public boolean m_6875_(Player player) {
        return player.m_20275_((double)this.blockEntity.m_58899_().m_123341_() + 0.5, (double)this.blockEntity.m_58899_().m_123342_() + 0.5, (double)this.blockEntity.m_58899_().m_123343_() + 0.5) <= 64.0;
    }

    public static DecorationTableMenu fromBuffer(int containerId, Inventory playerInventory, FriendlyByteBuf buffer) {
        return new DecorationTableMenu(containerId, playerInventory.f_35978_, buffer.m_130135_());
    }

    public void setSlotMaterialInheritance(int slot, boolean inheritance) {
        this.blockEntity.setSlotMaterialInheritance(slot, inheritance);
        this.sendToServer(tag -> {
            tag.m_128359_("action", SET_INHERITANCE_ACTION);
            tag.m_128405_("slot", slot);
            tag.m_128379_("inheritance", inheritance);
        });
    }

    public void setMainColor(int color) {
        this.blockEntity.setMainColor(color);
        this.sendToServer(tag -> tag.m_128405_("mainColor", color));
    }

    public void setAccentColor(int color) {
        this.blockEntity.setAccentColor(color);
        this.sendToServer(tag -> tag.m_128405_("accentColor", color));
    }

    public boolean isSlotMaterialInherited(int slot) {
        return this.blockEntity.isSlotMaterialInherited(slot);
    }

    public ItemStack getInheritedItem(int childSlot) {
        return this.blockEntity.getInheritedItem(childSlot);
    }

    public int getMainColor() {
        return this.blockEntity.getMainColor();
    }

    public int getAccentColor() {
        return this.blockEntity.getAccentColor();
    }

    public Slot getResultSlot() {
        return this.resultSlot;
    }

    protected void sendToServer(Consumer<CompoundTag> addData) {
        if (this.blockEntity.m_58904_() == null || !this.blockEntity.m_58904_().f_46443_) {
            return;
        }
        CompoundTag data = new CompoundTag();
        addData.accept(data);
        PacketHandler.INSTANCE.sendToServer((Object)new SyncContainerClientDataMessage(data));
    }

    public Map<ResourceLocation, Integer> getPartsNeeded() {
        return this.blockEntity.getPartsNeeded();
    }

    public Set<ResourceLocation> getMissingDyes() {
        return this.blockEntity.getMissingDyes();
    }

    public void handleMessage(CompoundTag data) {
        String action = data.m_128461_("action");
        if (action.equals(SET_INHERITANCE_ACTION)) {
            this.setSlotMaterialInheritance(data.m_128451_("slot"), data.m_128471_("inheritance"));
        } else if (data.m_128441_("mainColor")) {
            this.setMainColor(data.m_128451_("mainColor"));
        } else if (data.m_128441_("accentColor")) {
            this.setAccentColor(data.m_128451_("accentColor"));
        }
    }

    public Map<ResourceLocation, Integer> getPartsStored() {
        return this.blockEntity.getPartsStored();
    }

    public boolean hasMaterials() {
        return this.blockEntity.hasMaterials();
    }
}

