/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.registry;

import com.supermartijn642.core.CoreLib;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.core.registry.RegistryUtil;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.moddiscovery.ModAnnotation;
import net.minecraftforge.forgespi.language.ModFileScanData;
import net.minecraftforge.registries.IdMappingEvent;
import net.minecraftforge.registries.RegisterEvent;
import org.objectweb.asm.Type;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.FIELD, ElementType.METHOD})
public @interface RegistryEntryAcceptor {
    public String namespace();

    public String identifier();

    public Registry registry();

    public static class Handler {
        private static final Type TYPE = Type.getType(RegistryEntryAcceptor.class);
        private static final Map<Registries.Registry<?>, Map<ResourceLocation, Set<Field>>> FIELDS = new HashMap();
        private static final Map<Registries.Registry<?>, Map<ResourceLocation, Set<Method>>> METHODS = new HashMap();

        public static void gatherAnnotatedFields() {
            for (ModFileScanData scanData : ModList.get().getAllScanData()) {
                for (ModFileScanData.AnnotationData annotationData : scanData.getAnnotations()) {
                    if (!TYPE.equals((Object)annotationData.annotationType())) continue;
                    try {
                        String namespace = (String)annotationData.annotationData().get("namespace");
                        if (!RegistryUtil.isValidNamespace(namespace)) {
                            throw new IllegalArgumentException("Namespace '" + namespace + "' must only contain characters [a-z0-9_.-]!");
                        }
                        String identifier = (String)annotationData.annotationData().get("identifier");
                        if (!RegistryUtil.isValidPath(identifier)) {
                            throw new IllegalArgumentException("Identifier '" + identifier + "' must only contain characters [a-z0-9_./-]!");
                        }
                        Registry registry = Registry.valueOf(((ModAnnotation.EnumHolder)annotationData.annotationData().get("registry")).getValue());
                        Class<?> clazz = Class.forName(annotationData.clazz().getClassName(), false, RegistryEntryAcceptor.class.getClassLoader());
                        if (annotationData.targetType().equals((Object)ElementType.FIELD)) {
                            Field field = clazz.getDeclaredField(annotationData.memberName());
                            if (!Modifier.isStatic(field.getModifiers())) {
                                throw new RuntimeException("Field must be static!");
                            }
                            if (Modifier.isFinal(field.getModifiers())) {
                                throw new RuntimeException("Field must not be final!");
                            }
                            if (!registry.registry.getValueClass().isAssignableFrom(field.getType())) {
                                throw new RuntimeException("Field must have a type assignable from '" + registry.registry.getValueClass().getName() + "'!");
                            }
                            field.setAccessible(true);
                            FIELDS.computeIfAbsent(registry.registry, o -> new HashMap()).computeIfAbsent(new ResourceLocation(namespace, identifier), o -> new HashSet()).add(field);
                            continue;
                        }
                        if (annotationData.targetType().equals((Object)ElementType.METHOD)) {
                            Method method = clazz.getDeclaredMethod(annotationData.memberName(), new Class[0]);
                            if (!Modifier.isStatic(method.getModifiers())) {
                                throw new RuntimeException("Method must be static!");
                            }
                            if (method.getParameterCount() != 1) {
                                throw new RuntimeException("Method must have exactly 1 parameter!");
                            }
                            if (!registry.registry.getValueClass().isAssignableFrom(method.getParameterTypes()[0])) {
                                throw new RuntimeException("Method parameter must have a type assignable from '" + registry.registry.getValueClass().getName() + "'!");
                            }
                            method.setAccessible(true);
                            METHODS.computeIfAbsent(registry.registry, o -> new HashMap()).computeIfAbsent(new ResourceLocation(namespace, identifier), o -> new HashSet()).add(method);
                            continue;
                        }
                        throw new RuntimeException("@RegistryEntryAcceptor only supports field and method targets!");
                    }
                    catch (Exception e) {
                        throw new RuntimeException("Failed to register @RegistryEntryAcceptor annotation target '" + annotationData.memberName() + "' in '" + annotationData.clazz().getClassName() + "'!", e);
                    }
                }
            }
            MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, Handler::onIdRemapping);
        }

        public static void onRegisterEvent(RegisterEvent e) {
            Registries.Registry registry;
            Registries.Registry registry2 = registry = e.getForgeRegistry() == null ? Registries.fromUnderlying(e.getVanillaRegistry()) : Registries.fromUnderlying(e.getForgeRegistry());
            if (registry == null) {
                return;
            }
            Handler.applyToFields(registry);
            Handler.applyToMethods(registry);
            for (Registries.Registry otherRegistry : Registries.REGISTRATION_ORDER_MAP.getOrDefault(registry, Collections.emptyList())) {
                Handler.applyToFields(otherRegistry);
                Handler.applyToMethods(otherRegistry);
            }
        }

        public static void onIdRemapping(IdMappingEvent e) {
            FIELDS.keySet().forEach(Handler::applyToFields);
            METHODS.keySet().forEach(Handler::applyToMethods);
        }

        private static <T> void applyToFields(Registries.Registry<T> registry) {
            if (registry == null || !FIELDS.containsKey(registry)) {
                return;
            }
            for (Map.Entry<ResourceLocation, Set<Field>> entry : FIELDS.get(registry).entrySet()) {
                if (!registry.hasIdentifier(entry.getKey())) {
                    CoreLib.LOGGER.warn("Could not find value '" + entry.getKey() + "' in registry '" + registry.getRegistryIdentifier() + "' for @RegistryEntryAcceptor!");
                    continue;
                }
                T value = registry.getValue(entry.getKey());
                for (Field field : entry.getValue()) {
                    if (!field.getType().isAssignableFrom(value.getClass())) {
                        CoreLib.LOGGER.warn("@RegistryEntryAcceptor field '" + field.getDeclaringClass().getName() + "." + field.getName() + "' for '" + entry.getKey() + "' could not be assigned value of type '" + value.getClass() + "'.");
                        continue;
                    }
                    try {
                        field.set(null, value);
                    }
                    catch (IllegalAccessException e) {
                        CoreLib.LOGGER.error("Encountered an error when trying to apply @RegistryEntryAcceptor annotation on field '" + field.getDeclaringClass().getName() + "." + field.getName() + "'!", (Throwable)e);
                    }
                }
            }
        }

        private static <T> void applyToMethods(Registries.Registry<T> registry) {
            if (registry == null || !METHODS.containsKey(registry)) {
                return;
            }
            for (Map.Entry<ResourceLocation, Set<Method>> entry : METHODS.get(registry).entrySet()) {
                if (!registry.hasIdentifier(entry.getKey())) {
                    CoreLib.LOGGER.warn("Could not find value '" + entry.getKey() + "' in registry '" + registry.getRegistryIdentifier() + "' for @RegistryEntryAcceptor!");
                    continue;
                }
                T value = registry.getValue(entry.getKey());
                for (Method method : entry.getValue()) {
                    if (!method.getParameterTypes()[0].isAssignableFrom(value.getClass())) {
                        CoreLib.LOGGER.warn("@RegistryEntryAcceptor method '" + method.getDeclaringClass().getName() + "." + method.getName() + "' for '" + entry.getKey() + "' could not be assigned value of type '" + value.getClass() + "'.");
                        continue;
                    }
                    try {
                        method.invoke(null, value);
                    }
                    catch (IllegalAccessException | InvocationTargetException e) {
                        CoreLib.LOGGER.error("Encountered an error when trying to apply @RegistryEntryAcceptor annotation on method '" + method.getDeclaringClass().getName() + "." + method.getName() + "'!", (Throwable)e);
                    }
                }
            }
        }
    }

    public static enum Registry {
        BLOCKS(Registries.BLOCKS),
        FLUIDS(Registries.FLUIDS),
        ITEMS(Registries.ITEMS),
        MOB_EFFECTS(Registries.MOB_EFFECTS),
        SOUND_EVENTS(Registries.SOUND_EVENTS),
        POTIONS(Registries.POTIONS),
        ENCHANTMENTS(Registries.ENCHANTMENTS),
        ENTITY_TYPES(Registries.ENTITY_TYPES),
        BLOCK_ENTITY_TYPES(Registries.BLOCK_ENTITY_TYPES),
        PARTICLE_TYPES(Registries.PARTICLE_TYPES),
        MENU_TYPES(Registries.MENU_TYPES),
        PAINTING_VARIANTS(Registries.PAINTING_VARIANTS),
        RECIPE_SERIALIZERS(Registries.RECIPE_SERIALIZERS),
        ATTRIBUTES(Registries.ATTRIBUTES),
        STAT_TYPES(Registries.STAT_TYPES),
        RECIPE_CONDITION_SERIALIZERS(Registries.RECIPE_CONDITION_SERIALIZERS);

        public final Registries.Registry<?> registry;

        private Registry(Registries.Registry<?> registry) {
            this.registry = registry;
        }
    }
}

