/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lootjs.filters;

import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import net.minecraft.resources.ResourceLocation;

public interface ResourceLocationFilter
extends Predicate<ResourceLocation> {

    public record Or(List<ResourceLocationFilter> filters) implements ResourceLocationFilter
    {
        @Override
        public boolean test(ResourceLocation resourceLocation) {
            return this.filters.stream().anyMatch(filter -> filter.test(resourceLocation));
        }
    }

    public record ByPattern(Pattern pattern) implements ResourceLocationFilter
    {
        @Override
        public boolean test(ResourceLocation resourceLocation) {
            return this.pattern.matcher(resourceLocation.toString()).matches();
        }
    }

    public record ByLocation(ResourceLocation location) implements ResourceLocationFilter
    {
        @Override
        public boolean test(ResourceLocation resourceLocation) {
            return this.location.equals((Object)resourceLocation);
        }
    }
}

