/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model.baked;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.block.DiskDriveBlock;
import com.refinedmods.refinedstorage.blockentity.DiskDriveBlockEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Vector3f;

public class DiskDriveBakedModel
extends BakedModelWrapper<BakedModel> {
    private final Function<Direction, BakedModel> baseModelBakery;
    private final BiFunction<Direction, Vector3f, BakedModel> diskModelBakery;
    private final BiFunction<Direction, Vector3f, BakedModel> diskNearCapacityModelBakery;
    private final BiFunction<Direction, Vector3f, BakedModel> diskFullModelBakery;
    private final BiFunction<Direction, Vector3f, BakedModel> diskDisconnectedModelBakery;
    private final LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            Direction facing = (Direction)key.state.m_61143_((Property)((DiskDriveBlock)((Object)RSBlocks.DISK_DRIVE.get())).getDirection().getProperty());
            List<Object> quads = new ArrayList<BakedQuad>();
            if (key.side != null) {
                quads = DiskDriveBakedModel.this.baseModelBakery.apply(facing).m_213637_(key.state, key.side, key.random);
                return quads;
            }
            int x = 0;
            int y = 0;
            for (int i = 0; i < 8; ++i) {
                if (key.diskState[i] != DiskState.NONE) {
                    BakedModel diskModel = this.getDiskModelBakery(key.diskState[i]).apply(facing, this.getDiskTranslation(x, y));
                    quads.addAll(diskModel.m_213637_(key.state, key.side, key.random));
                }
                ++x;
                if ((i + 1) % 2 != 0) continue;
                ++y;
                x = 0;
            }
            return quads;
        }

        private BiFunction<Direction, Vector3f, BakedModel> getDiskModelBakery(DiskState diskState) {
            return switch (diskState) {
                case DiskState.DISCONNECTED -> DiskDriveBakedModel.this.diskDisconnectedModelBakery;
                case DiskState.NEAR_CAPACITY -> DiskDriveBakedModel.this.diskNearCapacityModelBakery;
                case DiskState.FULL -> DiskDriveBakedModel.this.diskFullModelBakery;
                default -> DiskDriveBakedModel.this.diskModelBakery;
            };
        }

        private Vector3f getDiskTranslation(int x, int y) {
            Vector3f translation = new Vector3f();
            translation.add((0.125f + (float)x * 7.0f / 16.0f) * -1.0f, 0.0f, 0.0f);
            translation.add(0.0f, -(0.125f + (float)y * 3.0f / 16.0f), 0.0f);
            return translation;
        }
    });

    public DiskDriveBakedModel(BakedModel base, Function<Direction, BakedModel> baseModelBakery, BiFunction<Direction, Vector3f, BakedModel> diskModelBakery, BiFunction<Direction, Vector3f, BakedModel> diskNearCapacityModelBakery, BiFunction<Direction, Vector3f, BakedModel> diskFullModelBakery, BiFunction<Direction, Vector3f, BakedModel> diskDisconnectedModelBakery) {
        super(base);
        this.baseModelBakery = baseModelBakery;
        this.diskModelBakery = diskModelBakery;
        this.diskNearCapacityModelBakery = diskNearCapacityModelBakery;
        this.diskFullModelBakery = diskFullModelBakery;
        this.diskDisconnectedModelBakery = diskDisconnectedModelBakery;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull RandomSource rand, @Nonnull ModelData extraData, @Nullable RenderType renderType) {
        DiskState[] diskState = (DiskState[])extraData.get(DiskDriveBlockEntity.DISK_STATE_PROPERTY);
        if (diskState == null) {
            return super.getQuads(state, side, rand, extraData, renderType);
        }
        CacheKey key = new CacheKey(state, side, diskState, rand);
        return (List)this.cache.getUnchecked((Object)key);
    }

    private static class CacheKey {
        private final BlockState state;
        private final Direction side;
        private final DiskState[] diskState;
        private final RandomSource random;

        CacheKey(BlockState state, @Nullable Direction side, DiskState[] diskState, RandomSource random) {
            this.state = state;
            this.side = side;
            this.diskState = diskState;
            this.random = random;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.state.equals(cacheKey.state)) {
                return false;
            }
            if (this.side != cacheKey.side) {
                return false;
            }
            return Arrays.equals((Object[])this.diskState, (Object[])cacheKey.diskState);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + Arrays.hashCode((Object[])this.diskState);
            return result;
        }
    }
}

