/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.apiimpl.network.item;

import com.refinedmods.refinedstorage.api.network.INetwork;
import com.refinedmods.refinedstorage.api.network.INetworkNodeGraphEntry;
import com.refinedmods.refinedstorage.api.network.IWirelessTransmitter;
import com.refinedmods.refinedstorage.api.network.item.INetworkItem;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemManager;
import com.refinedmods.refinedstorage.api.network.item.INetworkItemProvider;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.inventory.player.PlayerSlot;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class NetworkItemManager
implements INetworkItemManager {
    private final INetwork network;
    private final Map<Player, INetworkItem> items = new ConcurrentHashMap<Player, INetworkItem>();

    public NetworkItemManager(INetwork network) {
        this.network = network;
    }

    @Override
    public void open(Player player, ItemStack stack, PlayerSlot slot) {
        boolean inRange = false;
        for (INetworkNodeGraphEntry entry : this.network.getNodeGraph().all()) {
            INetworkNode node = entry.getNode();
            if (!(node instanceof IWirelessTransmitter) || !this.network.canRun() || !node.isActive() || ((IWirelessTransmitter)((Object)node)).getDimension() != player.m_20193_().m_46472_()) continue;
            IWirelessTransmitter transmitter = (IWirelessTransmitter)((Object)node);
            Vec3 pos = player.m_20182_();
            double distance = Math.sqrt(Math.pow((double)transmitter.getOrigin().m_123341_() - pos.m_7096_(), 2.0) + Math.pow((double)transmitter.getOrigin().m_123342_() - pos.m_7098_(), 2.0) + Math.pow((double)transmitter.getOrigin().m_123343_() - pos.m_7094_(), 2.0));
            if (!(distance < (double)transmitter.getRange())) continue;
            inRange = true;
            break;
        }
        if (!inRange) {
            player.m_213846_((Component)Component.m_237115_((String)"misc.refinedstorage.network_item.out_of_range"));
            return;
        }
        INetworkItem item = ((INetworkItemProvider)stack.m_41720_()).provide(this, player, stack, slot);
        if (item.onOpen(this.network)) {
            this.items.put(player, item);
        }
    }

    @Override
    public void close(Player player) {
        this.items.remove(player);
    }

    @Override
    public INetworkItem getItem(Player player) {
        return this.items.get(player);
    }

    @Override
    public void drainEnergy(Player player, int energy) {
        INetworkItem item = this.getItem(player);
        if (item != null) {
            item.drainEnergy(energy);
        }
    }
}

