/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.infrastructure.debugInfo;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.platform.GlUtil;
import com.simibubi.create.CreateBuildInfo;
import com.simibubi.create.compat.pojav.PojavChecker;
import com.simibubi.create.foundation.mixin.accessor.SystemReportAccessor;
import com.simibubi.create.infrastructure.debugInfo.element.DebugInfoSection;
import com.simibubi.create.infrastructure.debugInfo.element.InfoElement;
import com.simibubi.create.infrastructure.debugInfo.element.InfoEntry;
import dev.engine_room.flywheel.api.backend.Backend;
import dev.engine_room.flywheel.api.backend.BackendManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.Util;
import net.minecraft.client.GraphicsStatus;
import net.minecraft.client.Minecraft;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.forgespi.language.IModInfo;

public class DebugInformation {
    private static final List<DebugInfoSection> client = new ArrayList<DebugInfoSection>();
    private static final List<DebugInfoSection> server = new ArrayList<DebugInfoSection>();
    private static final ImmutableMap<String, String> mcSystemInfo = (ImmutableMap)Util.m_137537_(() -> {
        SystemReport systemReport = new SystemReport();
        SystemReportAccessor access = (SystemReportAccessor)systemReport;
        return ImmutableMap.copyOf(access.getEntries());
    });

    public static void registerClientInfo(DebugInfoSection section) {
        client.add(section);
    }

    public static void registerServerInfo(DebugInfoSection section) {
        server.add(section);
    }

    public static void registerBothInfo(DebugInfoSection section) {
        DebugInformation.registerClientInfo(section);
        DebugInformation.registerServerInfo(section);
    }

    public static List<DebugInfoSection> getClientInfo() {
        return client;
    }

    public static List<DebugInfoSection> getServerInfo() {
        return server;
    }

    public static String getVersionOfMod(String id) {
        return ModList.get().getModContainerById(id).map(mod -> mod.getModInfo().getVersion().toString()).orElse("None");
    }

    public static Collection<InfoElement> listAllOtherMods() {
        ArrayList<InfoElement> mods = new ArrayList<InfoElement>();
        ModList.get().forEachModContainer((id, mod) -> {
            if (!(id.equals("create") || id.equals("forge") || id.equals("minecraft") || id.equals("flywheel") || id.equals("ponder"))) {
                IModInfo info = mod.getModInfo();
                String name = info.getDisplayName();
                String version = info.getVersion().toString();
                mods.add(new InfoEntry(name, version));
            }
        });
        return mods;
    }

    public static Collection<InfoElement> listAllGraphicsCards() {
        ArrayList<InfoElement> cards = new ArrayList<InfoElement>();
        for (int i = 0; i < 10; ++i) {
            String name = DebugInformation.getMcSystemInfo("Graphics card #" + i + " name");
            String vendor = DebugInformation.getMcSystemInfo("Graphics card #" + i + " vendor");
            String vram = DebugInformation.getMcSystemInfo("Graphics card #" + i + " VRAM (MB)");
            if (name == null || vendor == null || vram == null) break;
            String key = "Graphics card #" + i;
            String value = String.format("%s (%s); %s MB of VRAM", name, vendor, vram);
            cards.add(new InfoEntry(key, value));
        }
        return cards.isEmpty() ? List.of(new InfoEntry("Graphics cards", "none")) : cards;
    }

    public static String getTotalRam() {
        Runtime runtime = Runtime.getRuntime();
        long availableMemory = runtime.freeMemory();
        long totalMemory = runtime.totalMemory();
        long usedMemory = totalMemory - availableMemory;
        return String.format("%s bytes (%s MiB) / %s bytes (%s MiB)", usedMemory, usedMemory / 0x100000L, totalMemory, totalMemory / 0x100000L);
    }

    public static String getCpuInfo() {
        String name = DebugInformation.tryTrim(DebugInformation.getMcSystemInfo("Processor Name"));
        String freq = DebugInformation.getMcSystemInfo("Frequency (GHz)");
        String sockets = DebugInformation.getMcSystemInfo("Number of physical packages");
        String cores = DebugInformation.getMcSystemInfo("Number of physical CPUs");
        String threads = DebugInformation.getMcSystemInfo("Number of logical CPUs");
        return String.format("%s @ %s GHz; %s cores / %s threads on %s socket(s)", name, freq, cores, threads, sockets);
    }

    @Nullable
    public static String getMcSystemInfo(String key) {
        return (String)mcSystemInfo.get((Object)key);
    }

    public static String getIndent(int depth) {
        return Stream.generate(() -> "\t").limit(depth).collect(Collectors.joining());
    }

    @Nullable
    public static String tryTrim(@Nullable String s) {
        return s == null ? null : s.trim();
    }

    static {
        DebugInfoSection.builder("Create").put("Mod Version", CreateBuildInfo.VERSION).put("Mod Git Commit", CreateBuildInfo.GIT_COMMIT).put("Ponder Version", DebugInformation.getVersionOfMod("ponder")).put("Forge Version", DebugInformation.getVersionOfMod("forge")).put("Minecraft Version", SharedConstants.m_183709_().m_132493_()).buildTo(DebugInformation::registerBothInfo);
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> DebugInfoSection.builder("Graphics").put("Flywheel Version", ModList.get().getModContainerById("flywheel").map(c -> c.getModInfo().getVersion().toString()).orElse("None")).put("Flywheel Backend", () -> Backend.REGISTRY.getIdOrThrow((Object)BackendManager.currentBackend()).toString()).put("OpenGL Renderer", GlUtil::m_84820_).put("OpenGL Version", GlUtil::m_84821_).put("Graphics Mode", () -> ((GraphicsStatus)Minecraft.m_91087_().f_91066_.m_232060_().m_231551_()).name().toLowerCase(Locale.ROOT)).put("PojavLauncher Detected", () -> String.valueOf(PojavChecker.IS_PRESENT)).buildTo(DebugInformation::registerClientInfo));
        DebugInfoSection.builder("System Information").put("Operating System", SystemReportAccessor.getOPERATING_SYSTEM()).put("Java Version", SystemReportAccessor.getJAVA_VERSION()).put("JVM Flags", DebugInformation.getMcSystemInfo("JVM Flags")).put("Memory", () -> DebugInformation.getMcSystemInfo("Memory")).put("Total Memory", DebugInformation.getTotalRam()).put("CPU", DebugInformation.getCpuInfo()).putAll(DebugInformation.listAllGraphicsCards()).buildTo(DebugInformation::registerBothInfo);
        DebugInfoSection.builder("Other Mods").putAll(DebugInformation.listAllOtherMods()).buildTo(DebugInformation::registerBothInfo);
    }
}

