/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.schematics.client.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllKeys;
import com.simibubi.create.content.schematics.client.SchematicTransformation;
import com.simibubi.create.content.schematics.client.tools.PlacementToolBase;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.outliner.AABBOutline;
import net.createmod.catnip.render.SuperRenderTypeBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DeployTool
extends PlacementToolBase {
    @Override
    public void init() {
        super.init();
        this.selectionRange = -1;
    }

    @Override
    public void updateSelection() {
        if (this.schematicHandler.isActive() && this.selectionRange == -1) {
            this.selectionRange = (int)(this.schematicHandler.getBounds().m_82399_().m_82553_() / 2.0);
            this.selectionRange = Mth.m_14045_((int)this.selectionRange, (int)1, (int)100);
        }
        this.selectIgnoreBlocks = AllKeys.ACTIVATE_TOOL.isPressed();
        super.updateSelection();
    }

    @Override
    public void renderTool(PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera) {
        super.renderTool(ms, buffer, camera);
        if (this.selectedPos == null) {
            return;
        }
        ms.m_85836_();
        float pt = AnimationTickHolder.getPartialTicks();
        double x = Mth.m_14139_((double)pt, (double)this.lastChasingSelectedPos.f_82479_, (double)this.chasingSelectedPos.f_82479_);
        double y = Mth.m_14139_((double)pt, (double)this.lastChasingSelectedPos.f_82480_, (double)this.chasingSelectedPos.f_82480_);
        double z = Mth.m_14139_((double)pt, (double)this.lastChasingSelectedPos.f_82481_, (double)this.chasingSelectedPos.f_82481_);
        SchematicTransformation transformation = this.schematicHandler.getTransformation();
        AABB bounds = this.schematicHandler.getBounds();
        Vec3 center = bounds.m_82399_();
        Vec3 rotationOffset = transformation.getRotationOffset(true);
        int centerX = (int)center.f_82479_;
        int centerZ = (int)center.f_82481_;
        double xOrigin = bounds.m_82362_() / 2.0;
        double zOrigin = bounds.m_82385_() / 2.0;
        Vec3 origin = new Vec3(xOrigin, 0.0, zOrigin);
        ms.m_85837_(x - (double)centerX - camera.f_82479_, y - camera.f_82480_, z - (double)centerZ - camera.f_82481_);
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)ms).translate(origin)).translate(rotationOffset)).rotateYDegrees(transformation.getCurrentRotation())).translateBack(rotationOffset)).translateBack(origin);
        AABBOutline outline = this.schematicHandler.getOutline();
        outline.render(ms, buffer, Vec3.f_82478_, pt);
        outline.getParams().clearTextures();
        ms.m_85849_();
    }

    @Override
    public boolean handleMouseWheel(double delta) {
        if (!this.selectIgnoreBlocks) {
            return super.handleMouseWheel(delta);
        }
        this.selectionRange = (int)((double)this.selectionRange + delta);
        this.selectionRange = Mth.m_14045_((int)this.selectionRange, (int)1, (int)100);
        return true;
    }

    @Override
    public boolean handleRightClick() {
        if (this.selectedPos == null) {
            return super.handleRightClick();
        }
        Vec3 center = this.schematicHandler.getBounds().m_82399_();
        BlockPos target = this.selectedPos.m_7918_(-((int)center.f_82479_), 0, -((int)center.f_82481_));
        ItemStack item = this.schematicHandler.getActiveSchematicItem();
        if (item != null) {
            item.m_41783_().m_128379_("Deployed", true);
            item.m_41783_().m_128365_("Anchor", (Tag)NbtUtils.m_129224_((BlockPos)target));
            this.schematicHandler.getTransformation().startAt(target);
        }
        this.schematicHandler.getTransformation().moveTo(target);
        this.schematicHandler.markDirty();
        this.schematicHandler.deploy();
        return true;
    }
}

