/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.stockTicker;

import com.simibubi.create.AllEntityTypes;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.Create;
import com.simibubi.create.content.contraptions.actors.seat.SeatEntity;
import com.simibubi.create.content.logistics.BigItemStack;
import com.simibubi.create.content.logistics.packager.InventorySummary;
import com.simibubi.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.simibubi.create.content.logistics.stockTicker.PackageOrder;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlock;
import com.simibubi.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.simibubi.create.content.logistics.tableCloth.ShoppingListItem;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.network.NetworkHooks;

@Mod.EventBusSubscriber
public class StockTickerInteractionHandler {
    @SubscribeEvent
    public static void interactWithLogisticsManager(PlayerInteractEvent.EntityInteractSpecific event) {
        Entity entity = event.getTarget();
        Player player = event.getEntity();
        if (player == null || entity == null) {
            return;
        }
        if (player.m_5833_()) {
            return;
        }
        Level level = event.getLevel();
        BlockPos targetPos = StockTickerInteractionHandler.getStockTickerPosition(entity);
        if (targetPos == null) {
            return;
        }
        if (StockTickerInteractionHandler.interactWithLogisticsManagerAt(player, level, targetPos)) {
            event.setCancellationResult(InteractionResult.SUCCESS);
            event.setCanceled(true);
        }
    }

    public static boolean interactWithLogisticsManagerAt(Player player, Level level, BlockPos targetPos) {
        ItemStack mainHandItem = player.m_21205_();
        if (AllItems.SHOPPING_LIST.isIn(mainHandItem)) {
            StockTickerInteractionHandler.interactWithShop(player, level, targetPos, mainHandItem);
            return true;
        }
        if (level.m_5776_()) {
            return true;
        }
        BlockEntity blockEntity = level.m_7702_(targetPos);
        if (!(blockEntity instanceof StockTickerBlockEntity)) {
            return false;
        }
        StockTickerBlockEntity stbe = (StockTickerBlockEntity)blockEntity;
        if (!stbe.behaviour.mayInteract(player)) {
            player.m_5661_((Component)CreateLang.translate("stock_keeper.locked", new Object[0]).style(ChatFormatting.RED).component(), true);
            return true;
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            boolean showLockOption = stbe.behaviour.mayAdministrate(player) && Create.LOGISTICS.isLockable(stbe.behaviour.freqId);
            boolean isCurrentlyLocked = Create.LOGISTICS.isLocked(stbe.behaviour.freqId);
            NetworkHooks.openScreen((ServerPlayer)sp, (MenuProvider)stbe.new StockTickerBlockEntity.RequestMenuProvider(), buf -> {
                buf.writeBoolean(showLockOption);
                buf.writeBoolean(isCurrentlyLocked);
                buf.m_130064_(targetPos);
            });
            stbe.getRecentSummary().divideAndSendTo(sp, targetPos);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static void interactWithShop(Player player, Level level, BlockPos targetPos, ItemStack mainHandItem) {
        void var12_16;
        if (level.m_5776_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(targetPos);
        if (!(blockEntity instanceof StockTickerBlockEntity)) {
            return;
        }
        StockTickerBlockEntity tickerBE = (StockTickerBlockEntity)blockEntity;
        ShoppingListItem.ShoppingList list = ShoppingListItem.getList(mainHandItem);
        if (list == null) {
            return;
        }
        if (!tickerBE.behaviour.freqId.equals(list.shopNetwork())) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
            CreateLang.translate("stock_keeper.wrong_network", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        Couple<InventorySummary> bakeEntries = list.bakeEntries((LevelAccessor)level, null);
        InventorySummary paymentEntries = (InventorySummary)bakeEntries.getSecond();
        InventorySummary orderEntries = (InventorySummary)bakeEntries.getFirst();
        PackageOrder order = new PackageOrder(orderEntries.getStacksByCount());
        tickerBE.getAccurateSummary();
        InventorySummary recentSummary = tickerBE.getRecentSummary();
        for (BigItemStack bigItemStack : order.stacks()) {
            if (recentSummary.getCountOf(bigItemStack.stack) >= bigItemStack.count) continue;
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
            CreateLang.translate("stock_keeper.stock_level_too_low", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        int occupiedSlots = 0;
        for (BigItemStack entry : paymentEntries.getStacksByCount()) {
            occupiedSlots += Mth.m_14167_((float)((float)entry.count / (float)entry.stack.m_41741_()));
        }
        boolean bl = false;
        while (var12_16 < tickerBE.receivedPayments.getSlots()) {
            if (tickerBE.receivedPayments.getStackInSlot((int)var12_16).m_41619_()) {
                --occupiedSlots;
            }
            ++var12_16;
        }
        if (occupiedSlots > 0) {
            AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
            CreateLang.translate("stock_keeper.cash_register_full", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
            return;
        }
        for (boolean simulate : Iterate.trueAndFalse) {
            InventorySummary tally = paymentEntries.copy();
            ArrayList<ItemStack> toTransfer = new ArrayList<ItemStack>();
            for (int i = 0; i < player.m_150109_().f_35974_.size(); ++i) {
                int countOf;
                ItemStack item = player.m_150109_().m_8020_(i);
                if (item.m_41619_() || (countOf = tally.getCountOf(item)) == 0) continue;
                int toRemove = Math.min(item.m_41613_(), countOf);
                tally.add(item, -toRemove);
                if (simulate) continue;
                int newStackSize = item.m_41613_() - toRemove;
                player.m_150109_().m_6836_(i, newStackSize == 0 ? ItemStack.f_41583_ : item.m_255036_(newStackSize));
                toTransfer.add(item.m_255036_(toRemove));
            }
            if (simulate && tally.getTotalCount() != 0) {
                AllSoundEvents.DENY.playOnServer(level, (Vec3i)player.m_20183_());
                CreateLang.translate("stock_keeper.too_broke", new Object[0]).style(ChatFormatting.RED).sendStatus(player);
                return;
            }
            if (simulate) continue;
            toTransfer.forEach(s -> ItemHandlerHelper.insertItemStacked((IItemHandler)tickerBE.receivedPayments, (ItemStack)s, (boolean)false));
        }
        tickerBE.broadcastPackageRequest(LogisticallyLinkedBehaviour.RequestType.PLAYER, order, null, ShoppingListItem.getAddress(mainHandItem));
        player.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        if (!order.isEmpty()) {
            AllSoundEvents.STOCK_TICKER_TRADE.playOnServer(level, (Vec3i)tickerBE.m_58899_());
        }
    }

    public static BlockPos getStockTickerPosition(Entity entity) {
        Entity rootVehicle = entity.m_20201_();
        if (!(rootVehicle instanceof SeatEntity)) {
            return null;
        }
        if (!(entity instanceof LivingEntity)) {
            return null;
        }
        if (AllEntityTypes.PACKAGE.is(entity)) {
            return null;
        }
        BlockPos pos = entity.m_20183_();
        int stations = 0;
        BlockPos targetPos = null;
        for (Direction d : Iterate.horizontalDirections) {
            for (int y : Iterate.zeroAndOne) {
                BlockPos workstationPos = pos.m_121945_(d).m_6630_(y);
                if (!(entity.m_9236_().m_8055_(workstationPos).m_60734_() instanceof StockTickerBlock)) continue;
                targetPos = workstationPos;
                ++stations;
            }
        }
        if (stations != 1) {
            return null;
        }
        return targetPos;
    }
}

