/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.saw;

import com.simibubi.create.AllBlockEntityTypes;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.drill.DrillBlock;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SawBlock
extends DirectionalAxisKineticBlock
implements IBE<SawBlockEntity> {
    public static final BooleanProperty FLIPPED = BooleanProperty.m_61465_((String)"flipped");
    private static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());

    public SawBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_((StateDefinition.Builder<Block, BlockState>)builder.m_61104_(new Property[]{FLIPPED}));
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState stateForPlacement;
        Direction facing = (Direction)(stateForPlacement = super.m_5573_(context)).m_61143_((Property)FACING);
        return (BlockState)stateForPlacement.m_61124_((Property)FLIPPED, (Comparable)Boolean.valueOf(facing.m_122434_() == Direction.Axis.Y && context.m_8125_().m_122421_() == Direction.AxisDirection.POSITIVE));
    }

    @Override
    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        BlockState newState = super.getRotatedBlockState(originalState, targetedFace);
        if (((Direction)newState.m_61143_((Property)FACING)).m_122434_() != Direction.Axis.Y) {
            return newState;
        }
        if (targetedFace.m_122434_() != Direction.Axis.Y) {
            return newState;
        }
        if (!((Boolean)originalState.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
            newState = (BlockState)newState.m_61122_((Property)FLIPPED);
        }
        return newState;
    }

    @Override
    public BlockState m_6843_(BlockState state, Rotation rot) {
        BlockState newState = super.m_6843_(state, rot);
        if (((Direction)state.m_61143_((Property)FACING)).m_122434_() != Direction.Axis.Y) {
            return newState;
        }
        if (rot.ordinal() % 2 == 1 && rot == Rotation.CLOCKWISE_90 != (Boolean)state.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE)) {
            newState = (BlockState)newState.m_61122_((Property)FLIPPED);
        }
        if (rot == Rotation.CLOCKWISE_180) {
            newState = (BlockState)newState.m_61122_((Property)FLIPPED);
        }
        return newState;
    }

    @Override
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        BlockState newState = super.m_6943_(state, mirrorIn);
        if (((Direction)state.m_61143_((Property)FACING)).m_122434_() != Direction.Axis.Y) {
            return newState;
        }
        boolean alongX = (Boolean)state.m_61143_((Property)AXIS_ALONG_FIRST_COORDINATE);
        if (alongX && mirrorIn == Mirror.FRONT_BACK) {
            newState = (BlockState)newState.m_61122_((Property)FLIPPED);
        }
        if (!alongX && mirrorIn == Mirror.LEFT_RIGHT) {
            newState = (BlockState)newState.m_61122_((Property)FLIPPED);
        }
        return newState;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AllShapes.CASING_12PX.get((Direction)state.m_61143_((Property)FACING));
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        ItemStack heldItem = player.m_21120_(handIn);
        IPlacementHelper placementHelper = PlacementHelpers.get((int)placementHelperId);
        if (!player.m_6144_() && player.m_36326_() && placementHelper.matchesItem(heldItem) && placementHelper.getOffset(player, worldIn, state, pos, hit).placeInWorld(worldIn, (BlockItem)heldItem.m_41720_(), player, handIn, hit).m_19077_()) {
            return InteractionResult.SUCCESS;
        }
        if (player.m_5833_() || !player.m_21120_(handIn).m_41619_()) {
            return InteractionResult.PASS;
        }
        if (state.m_61145_((Property)FACING).orElse(Direction.WEST) != Direction.UP) {
            return InteractionResult.PASS;
        }
        return this.onBlockEntityUse((BlockGetter)worldIn, pos, be -> {
            for (int i = 0; i < be.inventory.getSlots(); ++i) {
                ItemStack heldItemStack = be.inventory.getStackInSlot(i);
                if (worldIn.f_46443_ || heldItemStack.m_41619_()) continue;
                player.m_150109_().m_150079_(heldItemStack);
            }
            be.inventory.clear();
            be.notifyUpdate();
            return InteractionResult.SUCCESS;
        });
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (entityIn instanceof ItemEntity) {
            return;
        }
        if (!new AABB(pos).m_82406_((double)0.1f).m_82381_(entityIn.m_20191_())) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)worldIn, pos, be -> {
            if (be.getSpeed() == 0.0f) {
                return;
            }
            entityIn.m_6469_(CreateDamageSources.saw(worldIn), (float)DrillBlock.getDamage(be.getSpeed()));
        });
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (entityIn.m_9236_().f_46443_) {
            return;
        }
        BlockPos pos = entityIn.m_20183_();
        this.withBlockEntityDo((BlockGetter)entityIn.m_9236_(), pos, be -> {
            if (be.getSpeed() == 0.0f) {
                return;
            }
            be.insertItem((ItemEntity)entityIn);
        });
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }

    public static boolean isHorizontal(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_().m_122479_();
    }

    @Override
    public Direction.Axis getRotationAxis(BlockState state) {
        return SawBlock.isHorizontal(state) ? ((Direction)state.m_61143_((Property)FACING)).m_122434_() : super.getRotationAxis(state);
    }

    @Override
    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return SawBlock.isHorizontal(state) ? face == ((Direction)state.m_61143_((Property)FACING)).m_122424_() : super.hasShaftTowards(world, pos, state, face);
    }

    @Override
    public Class<SawBlockEntity> getBlockEntityClass() {
        return SawBlockEntity.class;
    }

    @Override
    public BlockEntityType<? extends SawBlockEntity> getBlockEntityType() {
        return (BlockEntityType)AllBlockEntityTypes.SAW.get();
    }

    public boolean m_7357_(BlockState state, BlockGetter reader, BlockPos pos, PathComputationType type) {
        return false;
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    implements IPlacementHelper {
        private PlacementHelper() {
        }

        public Predicate<ItemStack> getItemPredicate() {
            return arg_0 -> AllBlocks.MECHANICAL_SAW.isIn(arg_0);
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> AllBlocks.MECHANICAL_SAW.has(state);
        }

        public PlacementOffset getOffset(Player player, Level world, BlockState state, BlockPos pos, BlockHitResult ray) {
            List directions = IPlacementHelper.orderedByDistanceExceptAxis((BlockPos)pos, (Vec3)ray.m_82450_(), (Direction.Axis)((Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING)).m_122434_(), dir -> world.m_8055_(pos.m_121945_(dir)).m_247087_());
            if (directions.isEmpty()) {
                return PlacementOffset.fail();
            }
            return PlacementOffset.success((Vec3i)pos.m_121945_((Direction)directions.get(0)), s -> (BlockState)((BlockState)((BlockState)s.m_61124_((Property)DirectionalKineticBlock.FACING, (Comparable)((Direction)state.m_61143_((Property)DirectionalKineticBlock.FACING)))).m_61124_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE, (Comparable)((Boolean)state.m_61143_((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE)))).m_61124_((Property)FLIPPED, (Comparable)((Boolean)state.m_61143_((Property)FLIPPED))));
        }
    }
}

