/*
 * Decompiled with CFR 0.152.
 */
package tech.alexnijjar.extractinator.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.teamresourceful.resourcefullib.client.CloseablePoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import tech.alexnijjar.extractinator.client.ClientPlatformUtils;
import tech.alexnijjar.extractinator.common.block.ExtractinatorBlock;
import tech.alexnijjar.extractinator.common.block.ExtractinatorBlockEntity;
import tech.alexnijjar.extractinator.common.registry.ModBlocks;

public class ExtractinatorRenderer
implements BlockEntityRenderer<ExtractinatorBlockEntity> {
    public static final ResourceLocation BASE = new ResourceLocation("extractinator", "block/extractinator/base");
    public static final ResourceLocation PUMP = new ResourceLocation("extractinator", "block/extractinator/pump");
    public static final ResourceLocation TORQUE_WHEEL = new ResourceLocation("extractinator", "block/extractinator/torque_wheel");
    public static final ResourceLocation COGWHEEL = new ResourceLocation("extractinator", "block/extractinator/cogwheel");
    public static final ResourceLocation CHIMNEY = new ResourceLocation("extractinator", "block/extractinator/chimney");

    public ExtractinatorRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(ExtractinatorBlockEntity extractinator, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        long time = extractinator.m_58904_() == null ? 0L : extractinator.m_58904_().m_46467_();
        Direction dir = (Direction)extractinator.m_58900_().m_61143_((Property)ExtractinatorBlock.FACING);
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_85837_(0.5, 1.0, 0.5);
            poseStack.m_252781_(Axis.f_252392_.m_252977_(dir.m_122435_()));
            poseStack.m_252781_(Axis.f_252392_.m_252977_(180.0f));
            poseStack.m_85837_(-0.5, -1.0, -0.5);
            try (CloseablePoseStack ignored1 = new CloseablePoseStack(poseStack);){
                ExtractinatorRenderer.renderPump(time, poseStack, bufferSource, packedLight, packedOverlay);
                ExtractinatorRenderer.renderCogwheel(time, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
                ExtractinatorRenderer.renderChimney(time, poseStack, bufferSource, packedLight, packedOverlay);
            }
        }
    }

    protected static void renderPump(long time, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        long animationTime = time % 80L;
        long frameTime = time % 20L;
        float translation = (float)((int)((float)animationTime / 20.0f)) * 0.0625f;
        if ((int)((float)animationTime / 20.0f) < 3) {
            if (frameTime > 17L) {
                translation += (float)(frameTime - 17L) * 0.03125f;
            }
        } else {
            translation = 0.1875f;
            if (frameTime > 14L) {
                translation -= (float)(frameTime - 14L) * 0.0375f;
            }
        }
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_252880_(0.0f, -translation, 0.0f);
            ExtractinatorRenderer.renderBlock(PUMP, poseStack, buffer, packedLight, packedOverlay);
            ExtractinatorRenderer.renderTorqueWheel(time, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    protected static void renderTorqueWheel(long time, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        long animationTime = time % 80L;
        long frameTime = time % 20L;
        float offset = ((int)((float)animationTime / 20.0f) - 1) * 90;
        float frameRot = frameTime < 2L ? 0.0f : (frameTime < 6L ? (float)(frameTime - 2L) * 11.25f : (frameTime < 10L ? 45.0f + (float)(frameTime - 5L) * 2.5f : (frameTime < 16L ? 55.0f + (float)(frameTime - 9L) * 7.5f : 100.0f - ((float)frameTime - 15.0f) * 2.5f)));
        float angle = Math.min(offset + frameRot, offset + 100.0f);
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_85837_(0.65625, 0.0, 0.34375);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(angle));
            ExtractinatorRenderer.renderBlock(TORQUE_WHEEL, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    protected static void renderCogwheel(long time, float partialTick, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_85837_(0.34375, 0.0, 0.65625);
            poseStack.m_252781_(Axis.f_252436_.m_252977_((float)((double)((float)time + partialTick) * -5.0)));
            ExtractinatorRenderer.renderBlock(COGWHEEL, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    protected static void renderChimney(long time, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        long animationTime = time % 80L;
        float scale = 1.0f;
        if (animationTime > 74L) {
            scale += 0.4f - (float)(animationTime - 70L) * 0.04f;
        } else if (animationTime > 70L) {
            scale += (float)(animationTime - 70L) * 0.08f;
        }
        try (CloseablePoseStack ignored = new CloseablePoseStack(poseStack);){
            poseStack.m_252880_(0.125f, 0.625f, 0.25f);
            poseStack.m_85841_(scale, scale, scale);
            ExtractinatorRenderer.renderBlock(CHIMNEY, poseStack, buffer, packedLight, packedOverlay);
        }
    }

    protected static void renderBlock(ResourceLocation model, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        BakedModel blockModel = ClientPlatformUtils.getModel(Minecraft.m_91087_().m_91304_(), model);
        Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(poseStack.m_85850_(), buffer.m_6299_(Sheets.m_110790_()), ((Block)ModBlocks.EXTRACTINATOR.get()).m_49966_(), blockModel, 1.0f, 1.0f, 1.0f, packedLight, packedOverlay);
    }

    public static class ExtractinatorItemRenderer
    extends BlockEntityWithoutLevelRenderer {
        public ExtractinatorItemRenderer() {
            super(Minecraft.m_91087_().m_167982_(), Minecraft.m_91087_().m_167973_());
        }

        public void m_108829_(ItemStack stack, ItemDisplayContext itemDisplayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
            ExtractinatorRenderer.renderBlock(BASE, poseStack, buffer, packedLight, packedOverlay);
            Minecraft minecraft = Minecraft.m_91087_();
            long time = minecraft.f_91073_ == null ? 0L : minecraft.f_91073_.m_46467_();
            ExtractinatorRenderer.renderPump(time, poseStack, buffer, packedLight, packedOverlay);
            ExtractinatorRenderer.renderCogwheel(time, minecraft.m_91297_(), poseStack, buffer, packedLight, packedOverlay);
            ExtractinatorRenderer.renderChimney(time, poseStack, buffer, packedLight, packedOverlay);
        }
    }
}

