/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import journeymap.client.JourneymapClient;
import journeymap.client.data.DataCache;
import journeymap.client.render.draw.DrawWayPointStep;
import journeymap.client.render.map.GridRenderer;
import journeymap.client.waypoint.Waypoint;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;

public class WaypointDrawStepFactory {
    final List<DrawWayPointStep> drawStepList = new ArrayList<DrawWayPointStep>();

    public List<DrawWayPointStep> prepareSteps(Collection<Waypoint> waypoints, GridRenderer grid, boolean checkDistance, boolean showLabel) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        int maxDistance = JourneymapClient.getInstance().getWaypointProperties().maxDistance.get();
        float waypointLabelScale = JourneymapClient.getInstance().getFullMapProperties().waypointLabelScale.get().floatValue();
        float waypointIconScale = JourneymapClient.getInstance().getFullMapProperties().waypointIconScale.get().floatValue();
        checkDistance = checkDistance && maxDistance > 0;
        Vec3 playerVec = checkDistance ? player.m_20182_() : null;
        this.drawStepList.clear();
        try {
            for (Waypoint waypoint : waypoints) {
                DrawWayPointStep wayPointStep;
                double actualDistance;
                if (!waypoint.isEnable() || !waypoint.isInPlayerDimension() || checkDistance && (actualDistance = playerVec.m_82554_(waypoint.getPosition())) > (double)maxDistance || (wayPointStep = DataCache.INSTANCE.getDrawWayPointStep(waypoint)) == null) continue;
                this.drawStepList.add(wayPointStep);
                wayPointStep.setShowLabel(showLabel);
                wayPointStep.setLabelScale(waypointLabelScale);
                wayPointStep.setIconScale(waypointIconScale);
            }
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during prepareSteps: " + LogFormatter.toString(t));
        }
        return this.drawStepList;
    }
}

