/*
 * Decompiled with CFR 0.152.
 */
package com.prunoideae.powerfuljs.capabilities.forge;

import com.prunoideae.powerfuljs.capabilities.forge.CapabilityBuilderForge;
import java.util.function.BiFunction;
import java.util.function.ToIntBiFunction;
import java.util.function.ToIntFunction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class CapabilityItem {
    public BlockEntityBuilder blockEntity() {
        return new BlockEntityBuilder();
    }

    public static class BlockEntityBuilder
    extends CapabilityBuilderForge<BlockEntity, IItemHandler> {
        private ToIntFunction<BlockEntity> getSlots;
        private BiFunction<BlockEntity, Integer, ItemStack> getStackInSlot;
        private InsertItem insertItem;
        private ExtractItem extractItem;
        private ToIntBiFunction<BlockEntity, Integer> getSlotLimit;
        private IsItemValid isItemValid;

        public BlockEntityBuilder getSlots(ToIntFunction<BlockEntity> getSlots) {
            this.getSlots = getSlots;
            return this;
        }

        public BlockEntityBuilder getStackInSlot(BiFunction<BlockEntity, Integer, ItemStack> getStackInSlot) {
            this.getStackInSlot = getStackInSlot;
            return this;
        }

        public BlockEntityBuilder insertItem(InsertItem insertItem) {
            this.insertItem = insertItem;
            return this;
        }

        public BlockEntityBuilder extractItem(ExtractItem extractItem) {
            this.extractItem = extractItem;
            return this;
        }

        public BlockEntityBuilder getSlotLimit(ToIntBiFunction<BlockEntity, Integer> getSlotLimit) {
            this.getSlotLimit = getSlotLimit;
            return this;
        }

        public BlockEntityBuilder isItemValid(IsItemValid isItemValid) {
            this.isItemValid = isItemValid;
            return this;
        }

        @Override
        public IItemHandler getCapability(final BlockEntity instance) {
            return new IItemHandler(){

                public int getSlots() {
                    return getSlots != null ? getSlots.applyAsInt(instance) : 0;
                }

                @NotNull
                public ItemStack getStackInSlot(int i) {
                    return getStackInSlot == null ? ItemStack.f_41583_ : getStackInSlot.apply(instance, i);
                }

                @NotNull
                public ItemStack insertItem(int i, @NotNull ItemStack arg, boolean bl) {
                    return insertItem == null ? ItemStack.f_41583_ : insertItem.insert(instance, i, arg, bl);
                }

                @NotNull
                public ItemStack extractItem(int i, int j, boolean bl) {
                    return extractItem == null ? ItemStack.f_41583_ : extractItem.extract(instance, i, j, bl);
                }

                public int getSlotLimit(int i) {
                    return getSlotLimit == null ? 64 : getSlotLimit.applyAsInt(instance, i);
                }

                public boolean isItemValid(int i, @NotNull ItemStack arg) {
                    return isItemValid == null || isItemValid.isValid(instance, i, arg);
                }
            };
        }

        @Override
        public Capability<IItemHandler> getCapabilityKey() {
            return ForgeCapabilities.ITEM_HANDLER;
        }

        @Override
        public ResourceLocation getResourceLocation() {
            return new ResourceLocation("powerful:item_be");
        }
    }

    @FunctionalInterface
    public static interface IsItemValid {
        public boolean isValid(BlockEntity var1, int var2, ItemStack var3);
    }

    @FunctionalInterface
    public static interface ExtractItem {
        public ItemStack extract(BlockEntity var1, int var2, int var3, boolean var4);
    }

    @FunctionalInterface
    public static interface InsertItem {
        public ItemStack insert(BlockEntity var1, int var2, ItemStack var3, boolean var4);
    }
}

