/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.levelio.lib;

import com.google.common.collect.AbstractIterator;
import java.util.Objects;
import net.creeperhost.levelio.lib.ChunkPos;
import net.creeperhost.levelio.lib.nbt.ICompoundTag;

public class BlockPos {
    public int x;
    public int y;
    public int z;

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static BlockPos fromTileTag(ICompoundTag tag) {
        return new BlockPos(tag.getInt("x"), tag.getInt("y"), tag.getInt("z"));
    }

    public BlockPos set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public BlockPos offset(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    public ChunkPos toChunkPos() {
        return new ChunkPos(this.x >> 4, this.z >> 4);
    }

    public double distToSqr(double x, double y, double z) {
        double xDist = (double)this.x - x;
        double yDist = (double)this.y - y;
        double zDist = (double)this.z - z;
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    public BlockPos copy() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public static Iterable<BlockPos> between(final int xMin, final int yMin, final int zMin, int xMax, int yMax, int zMax) {
        final int xSize = xMax - xMin + 1;
        final int ySize = yMax - yMin + 1;
        int zSize = zMax - zMin + 1;
        final int totalBlocks = xSize * ySize * zSize;
        return () -> new AbstractIterator<BlockPos>(){
            private final BlockPos cursor = new BlockPos(0, 0, 0);
            private int index;

            protected BlockPos computeNext() {
                if (this.index == totalBlocks) {
                    return (BlockPos)this.endOfData();
                }
                int x = this.index % xSize;
                int i = this.index / xSize;
                int y = i % ySize;
                int z = i / ySize;
                ++this.index;
                return this.cursor.set(xMin + x, yMin + y, zMin + z);
            }
        };
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BlockPos blockPos = (BlockPos)o;
        return this.x == blockPos.x && this.y == blockPos.y && this.z == blockPos.z;
    }

    public int hashCode() {
        return Objects.hash(this.x, this.y, this.z);
    }

    public String toString() {
        return "BlockPos{x=" + this.x + ", y=" + this.y + ", z=" + this.z + '}';
    }
}

