/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.emberstextapi.immersivemessages.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.tysontheember.emberstextapi.immersivemessages.ImmersiveMessagesManager;
import net.tysontheember.emberstextapi.immersivemessages.api.ImmersiveMessage;

public class TooltipPacket {
    private static final String PROTOCOL = "2";
    private static final ResourceLocation ID = new ResourceLocation("emberstextapi", "tooltip");
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)ID, () -> "2", "2"::equals, "2"::equals);
    private final ImmersiveMessage message;

    public TooltipPacket(ImmersiveMessage message) {
        this.message = message;
    }

    public static void register() {
        CHANNEL.registerMessage(0, TooltipPacket.class, TooltipPacket::encode, TooltipPacket::decode, TooltipPacket::handle);
    }

    private static void encode(TooltipPacket packet, FriendlyByteBuf buf) {
        packet.message.encode(buf);
    }

    private static TooltipPacket decode(FriendlyByteBuf buf) {
        return new TooltipPacket(ImmersiveMessage.decode(buf));
    }

    private static void handle(TooltipPacket packet, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            context.enqueueWork(() -> {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null) {
                    ImmersiveMessagesManager.showToPlayer(mc.f_91074_, packet.message);
                }
            });
        }
        context.setPacketHandled(true);
    }
}

