/*
 * Decompiled with CFR 0.152.
 */
package net.tysontheember.emberstextapi.immersivemessages.api;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.tysontheember.emberstextapi.immersivemessages.api.ObfuscateMode;
import net.tysontheember.emberstextapi.immersivemessages.api.OnRenderMessage;
import net.tysontheember.emberstextapi.immersivemessages.api.ShakeType;
import net.tysontheember.emberstextapi.immersivemessages.api.TextAnchor;
import net.tysontheember.emberstextapi.immersivemessages.util.CaxtonCompat;
import net.tysontheember.emberstextapi.immersivemessages.util.ImmersiveColor;
import net.tysontheember.emberstextapi.immersivemessages.util.RenderUtil;

public class ImmersiveMessage {
    private final Component text;
    private final float duration;
    private float age;
    private float xOffset;
    private float yOffset = 55.0f;
    private boolean shadow = true;
    private TextAnchor anchor = TextAnchor.TOP_CENTER;
    private TextAnchor align = TextAnchor.TOP_CENTER;
    private float textScale = 1.0f;
    private boolean background = false;
    private ImmersiveColor backgroundColor = new ImmersiveColor(-1442840576);
    private ImmersiveColor borderStart = new ImmersiveColor(-1426063361);
    private ImmersiveColor borderEnd = new ImmersiveColor(-1442840576);
    private boolean useTextureBackground = false;
    private ResourceLocation backgroundTexture;
    private int textureU = 0;
    private int textureV = 0;
    private int textureWidth = 256;
    private int textureHeight = 256;
    private int textureAtlasWidth = 256;
    private int textureAtlasHeight = 256;
    private float texturePaddingX = 0.0f;
    private float texturePaddingY = 0.0f;
    private float textureScaleX = 1.0f;
    private float textureScaleY = 1.0f;
    private float textureOverrideWidth = -1.0f;
    private float textureOverrideHeight = -1.0f;
    private TextureSizingMode textureSizingMode = TextureSizingMode.STRETCH;
    private TextColor[] gradientStops;
    private TextColor[] gradientColors;
    private ImmersiveColor[] backgroundGradientStops;
    private boolean typewriter = false;
    private float typewriterSpeed = 0.5f;
    private boolean typewriterCenter = false;
    private int typewriterIndex = 0;
    private MutableComponent current = Component.m_237113_((String)"");
    private ObfuscateMode obfuscateMode = ObfuscateMode.NONE;
    private float obfuscateSpeed = 5.0E-5f;
    private float obfuscateProgress = 0.0f;
    private String baseText;
    private boolean[] revealMask;
    private List<Integer> revealOrder;
    private int revealIndex = 0;
    private int wrapMaxWidth = -1;
    private float delay = 0.0f;
    private boolean shake = false;
    private float shakeStrength = 0.0f;
    private ShakeType shakeType = ShakeType.RANDOM;
    private boolean charShake = false;
    private float charShakeStrength = 0.0f;
    private ShakeType charShakeType = ShakeType.RANDOM;
    private OnRenderMessage onRender;
    private final Random random = new Random();

    public ImmersiveMessage(Component text, float duration) {
        this.text = text;
        this.duration = duration;
    }

    public static ImmersiveMessage builder(float duration, String text) {
        return new ImmersiveMessage((Component)Component.m_237113_((String)text), duration);
    }

    public ImmersiveMessage shadow(boolean shadow) {
        this.shadow = shadow;
        return this;
    }

    public ImmersiveMessage anchor(TextAnchor anchor) {
        this.anchor = anchor;
        return this;
    }

    public ImmersiveMessage align(TextAnchor align) {
        this.align = align;
        return this;
    }

    public ImmersiveMessage offset(float x, float y) {
        this.xOffset = x;
        this.yOffset = y;
        return this;
    }

    public ImmersiveMessage color(ChatFormatting vanilla) {
        Component component = this.text;
        if (component instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)component;
            if (vanilla != null) {
                mutable.m_130938_(s -> s.m_131140_(vanilla));
            }
        }
        return this;
    }

    public ImmersiveMessage color(String value) {
        Component component;
        if (value == null) {
            return this;
        }
        ChatFormatting fmt = ChatFormatting.m_126657_((String)value);
        if (fmt != null) {
            return this.color(fmt);
        }
        TextColor parsed = TextColor.m_131268_((String)value);
        if (parsed != null && (component = this.text) instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)component;
            mutable.m_130938_(s -> s.m_131148_(parsed));
        }
        return this;
    }

    public ImmersiveMessage color(int rgb) {
        Component component = this.text;
        if (component instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)component;
            mutable.m_130938_(s -> s.m_178520_(rgb));
        }
        return this;
    }

    private ImmersiveColor parseColour(String value) {
        if (value == null) {
            return null;
        }
        String v = value.trim();
        try {
            if (v.startsWith("#")) {
                v = v.substring(1);
            }
            if (v.startsWith("0x")) {
                v = v.substring(2);
            }
            if (v.length() == 8) {
                return new ImmersiveColor((int)Long.parseLong(v, 16));
            }
            if (v.length() == 6) {
                return new ImmersiveColor(0xFF000000 | Integer.parseInt(v, 16));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        ChatFormatting fmt = ChatFormatting.m_126657_((String)value);
        if (fmt != null && fmt.m_126665_() != null) {
            return new ImmersiveColor(0xFF000000 | fmt.m_126665_());
        }
        TextColor parsed = TextColor.m_131268_((String)value);
        if (parsed != null) {
            int c = parsed.m_131265_();
            if ((c & 0xFF000000) == 0) {
                c |= 0xFF000000;
            }
            return new ImmersiveColor(c);
        }
        return null;
    }

    public ImmersiveMessage bgAlpha(float alpha) {
        int a = Mth.m_14045_((int)((int)(alpha * 255.0f)), (int)0, (int)255);
        this.backgroundColor = new ImmersiveColor(this.backgroundColor.getRed(), this.backgroundColor.getGreen(), this.backgroundColor.getBlue(), a);
        this.background = true;
        return this;
    }

    public ImmersiveMessage background(boolean enabled) {
        this.background = enabled;
        if (!enabled) {
            this.useTextureBackground = false;
            this.backgroundTexture = null;
        }
        return this;
    }

    public ImmersiveMessage bgColor(ChatFormatting vanilla) {
        if (vanilla != null && vanilla.m_126665_() != null) {
            this.backgroundColor = new ImmersiveColor(0xFF000000 | vanilla.m_126665_());
            this.background = true;
        }
        return this;
    }

    public ImmersiveMessage bgColor(String value) {
        ImmersiveColor parsed = this.parseColour(value);
        if (parsed != null) {
            this.backgroundColor = parsed;
            this.background = true;
        }
        return this;
    }

    public ImmersiveMessage bgColor(int argb) {
        this.backgroundColor = new ImmersiveColor(argb);
        this.background = true;
        return this;
    }

    public ImmersiveMessage borderGradient(ImmersiveColor start, ImmersiveColor end) {
        this.borderStart = start;
        this.borderEnd = end;
        this.background = true;
        return this;
    }

    public ImmersiveMessage borderGradient(ChatFormatting start, ChatFormatting end) {
        if (start != null && end != null && start.m_126665_() != null && end.m_126665_() != null) {
            return this.borderGradient(new ImmersiveColor(0xFF000000 | start.m_126665_()), new ImmersiveColor(0xFF000000 | end.m_126665_()));
        }
        return this;
    }

    public ImmersiveMessage borderGradient(String start, String end) {
        ImmersiveColor s = this.parseColour(start);
        ImmersiveColor e = this.parseColour(end);
        if (s != null && e != null) {
            return this.borderGradient(s, e);
        }
        return this;
    }

    public ImmersiveMessage backgroundColors(ImmersiveColor bg, ImmersiveColor borderStart, ImmersiveColor borderEnd) {
        if (bg != null) {
            this.backgroundColor = bg;
        }
        if (borderStart != null) {
            this.borderStart = borderStart;
        }
        if (borderEnd != null) {
            this.borderEnd = borderEnd;
        }
        if (bg != null || borderStart != null || borderEnd != null) {
            this.background = true;
        }
        return this;
    }

    public ImmersiveMessage textureBackground(ResourceLocation texture) {
        return this.textureBackground(texture, 0, 0, 256, 256, 256, 256);
    }

    public ImmersiveMessage textureBackground(ResourceLocation texture, int width, int height) {
        return this.textureBackground(texture, 0, 0, width, height, width, height);
    }

    public ImmersiveMessage textureBackground(ResourceLocation texture, int u, int v, int regionWidth, int regionHeight, int atlasWidth, int atlasHeight) {
        if (texture != null) {
            this.backgroundTexture = texture;
            this.textureU = u;
            this.textureV = v;
            this.textureWidth = Math.max(1, regionWidth);
            this.textureHeight = Math.max(1, regionHeight);
            this.textureAtlasWidth = Math.max(1, atlasWidth);
            this.textureAtlasHeight = Math.max(1, atlasHeight);
            this.useTextureBackground = true;
            this.background = true;
        } else {
            this.backgroundTexture = null;
            this.useTextureBackground = false;
        }
        return this;
    }

    public ImmersiveMessage textureBackgroundScale(float scale) {
        return this.textureBackgroundScale(scale, scale);
    }

    public ImmersiveMessage textureBackgroundScale(float scaleX, float scaleY) {
        this.textureScaleX = Float.isFinite(scaleX) ? Math.max(0.0f, scaleX) : this.textureScaleX;
        this.textureScaleY = Float.isFinite(scaleY) ? Math.max(0.0f, scaleY) : this.textureScaleY;
        return this;
    }

    public ImmersiveMessage textureBackgroundPadding(float padding) {
        return this.textureBackgroundPadding(padding, padding);
    }

    public ImmersiveMessage textureBackgroundPadding(float paddingX, float paddingY) {
        if (Float.isFinite(paddingX)) {
            this.texturePaddingX = Math.max(0.0f, paddingX);
        }
        if (Float.isFinite(paddingY)) {
            this.texturePaddingY = Math.max(0.0f, paddingY);
        }
        return this;
    }

    public ImmersiveMessage textureBackgroundSize(float width, float height) {
        this.textureBackgroundWidth(width);
        this.textureBackgroundHeight(height);
        return this;
    }

    public ImmersiveMessage textureBackgroundWidth(float width) {
        this.textureOverrideWidth = Float.isFinite(width) && width > 0.0f ? width : -1.0f;
        return this;
    }

    public ImmersiveMessage textureBackgroundHeight(float height) {
        this.textureOverrideHeight = Float.isFinite(height) && height > 0.0f ? height : -1.0f;
        return this;
    }

    public ImmersiveMessage textureBackgroundMode(TextureSizingMode mode) {
        if (mode != null) {
            this.textureSizingMode = mode;
        }
        return this;
    }

    public ImmersiveMessage gradient(int startRgb, int endRgb) {
        return this.gradient(TextColor.m_131266_((int)startRgb), TextColor.m_131266_((int)endRgb));
    }

    public ImmersiveMessage gradient(String start, String end) {
        TextColor s = ImmersiveMessage.parseColor(start);
        TextColor e = ImmersiveMessage.parseColor(end);
        if (s != null && e != null) {
            return this.gradient(s, e);
        }
        return this;
    }

    public ImmersiveMessage gradient(TextColor start, TextColor end) {
        if (start == null || end == null) {
            return this;
        }
        return this.gradient(new TextColor[]{start, end});
    }

    public ImmersiveMessage gradient(int ... rgbs) {
        TextColor[] arr = new TextColor[rgbs.length];
        for (int i = 0; i < rgbs.length; ++i) {
            arr[i] = TextColor.m_131266_((int)rgbs[i]);
        }
        return this.gradient(arr);
    }

    public ImmersiveMessage gradient(String ... values) {
        TextColor[] arr = new TextColor[values.length];
        for (int i = 0; i < values.length; ++i) {
            arr[i] = ImmersiveMessage.parseColor(values[i]);
        }
        return this.gradient(arr);
    }

    public ImmersiveMessage gradient(List<TextColor> colors) {
        return this.gradient(colors.toArray(new TextColor[0]));
    }

    public ImmersiveMessage gradient(TextColor ... colors) {
        if (colors == null || colors.length < 2) {
            return this;
        }
        this.gradientStops = colors;
        this.buildGradientColors();
        this.rebuildGradientCurrent();
        return this;
    }

    public ImmersiveMessage backgroundGradient(int startArgb, int endArgb) {
        return this.backgroundGradient(new ImmersiveColor(startArgb), new ImmersiveColor(endArgb));
    }

    public ImmersiveMessage backgroundGradient(String start, String end) {
        ImmersiveColor s = ImmersiveMessage.parseImmersiveColor(start);
        ImmersiveColor e = ImmersiveMessage.parseImmersiveColor(end);
        if (s != null && e != null) {
            return this.backgroundGradient(s, e);
        }
        return this;
    }

    public ImmersiveMessage backgroundGradient(int ... argbs) {
        ImmersiveColor[] arr = new ImmersiveColor[argbs.length];
        for (int i = 0; i < argbs.length; ++i) {
            arr[i] = new ImmersiveColor(argbs[i]);
        }
        return this.backgroundGradient(arr);
    }

    public ImmersiveMessage backgroundGradient(String ... values) {
        ImmersiveColor[] arr = new ImmersiveColor[values.length];
        for (int i = 0; i < values.length; ++i) {
            arr[i] = ImmersiveMessage.parseImmersiveColor(values[i]);
        }
        return this.backgroundGradient(arr);
    }

    public ImmersiveMessage backgroundGradient(ImmersiveColor ... colors) {
        if (colors == null || colors.length < 2) {
            return this;
        }
        this.backgroundGradientStops = colors;
        this.background = true;
        return this;
    }

    public ImmersiveMessage backgroundGradient(List<ImmersiveColor> colors) {
        return this.backgroundGradient(colors.toArray(new ImmersiveColor[0]));
    }

    public ImmersiveMessage scale(float size) {
        this.textScale = size;
        return this;
    }

    public ImmersiveMessage typewriter(float speed) {
        return this.typewriter(speed, false);
    }

    public ImmersiveMessage typewriter(float speed, boolean center) {
        this.typewriter = true;
        this.typewriterSpeed = speed;
        this.typewriterCenter = center;
        this.typewriterIndex = 0;
        this.rebuildGradientCurrent();
        return this;
    }

    public ImmersiveMessage wrap(int maxWidth) {
        this.wrapMaxWidth = maxWidth;
        return this;
    }

    public ImmersiveMessage obfuscate(ObfuscateMode mode, float speed) {
        this.obfuscateMode = mode != null ? mode : ObfuscateMode.NONE;
        this.obfuscateSpeed = speed;
        if (this.obfuscateMode != ObfuscateMode.NONE) {
            this.initObfuscation();
        } else {
            this.baseText = null;
            this.revealMask = null;
            this.revealOrder = null;
            this.revealIndex = 0;
            this.rebuildGradientCurrent();
        }
        return this;
    }

    public ImmersiveMessage shake(ShakeType type, float strength) {
        if (type != null && strength > 0.0f) {
            this.shake = true;
            this.shakeType = type;
            this.shakeStrength = strength;
        } else {
            this.shake = false;
            this.shakeStrength = 0.0f;
            if (type != null) {
                this.shakeType = type;
            }
        }
        return this;
    }

    public ImmersiveMessage charShake(ShakeType type, float strength) {
        if (type != null && strength > 0.0f) {
            this.charShake = true;
            this.charShakeType = type;
            this.charShakeStrength = strength;
        } else {
            this.charShake = false;
            this.charShakeStrength = 0.0f;
            if (type != null) {
                this.charShakeType = type;
            }
        }
        return this;
    }

    private static TextColor parseColor(String value) {
        if (value == null) {
            return null;
        }
        ChatFormatting fmt = ChatFormatting.m_126657_((String)value);
        if (fmt != null) {
            return TextColor.m_131270_((ChatFormatting)fmt);
        }
        return TextColor.m_131268_((String)value);
    }

    private static ImmersiveColor parseImmersiveColor(String value) {
        TextColor c = ImmersiveMessage.parseColor(value);
        return c != null ? new ImmersiveColor(0xFF000000 | c.m_131265_()) : null;
    }

    private void buildGradientColors() {
        String str = this.text.getString();
        this.gradientColors = new TextColor[str.length()];
        if (this.gradientStops == null || this.gradientStops.length < 2) {
            return;
        }
        int segments = this.gradientStops.length - 1;
        for (int i = 0; i < str.length(); ++i) {
            float t = str.length() <= 1 ? 0.0f : (float)i / (float)(str.length() - 1);
            float scaled = t * (float)segments;
            int idx = Mth.m_14045_((int)((int)Math.floor(scaled)), (int)0, (int)(segments - 1));
            float local = scaled - (float)idx;
            int start = this.gradientStops[idx].m_131265_();
            int end = this.gradientStops[idx + 1].m_131265_();
            int rgb = ImmersiveMessage.lerpColor(start, end, local);
            this.gradientColors[i] = TextColor.m_131266_((int)rgb);
        }
    }

    private static int lerpColor(int start, int end, float t) {
        int sr = start >> 16 & 0xFF;
        int sg = start >> 8 & 0xFF;
        int sb = start & 0xFF;
        int er = end >> 16 & 0xFF;
        int eg = end >> 8 & 0xFF;
        int eb = end & 0xFF;
        int r = (int)Mth.m_14179_((float)t, (float)sr, (float)er);
        int g = (int)Mth.m_14179_((float)t, (float)sg, (float)eg);
        int b = (int)Mth.m_14179_((float)t, (float)sb, (float)eb);
        return r << 16 | g << 8 | b;
    }

    private void rebuildGradientCurrent() {
        if (this.obfuscateMode != ObfuscateMode.NONE && this.baseText != null) {
            this.rebuildObfuscation();
        } else {
            this.current = this.typewriter ? this.buildGradientComponent(this.typewriterIndex) : this.buildGradientComponent(this.text.getString().length());
        }
    }

    private MutableComponent buildGradientComponent(int limit) {
        MutableComponent result = Component.m_237113_((String)"");
        String str = this.text.getString();
        int end = Math.min(limit, str.length());
        for (int i = 0; i < end; ++i) {
            TextColor col;
            char c = str.charAt(i);
            MutableComponent ch = Component.m_237113_((String)String.valueOf(c)).m_130948_(this.text.m_7383_());
            if (this.gradientColors != null && i < this.gradientColors.length && (col = this.gradientColors[i]) != null) {
                ch = ch.m_130938_(s -> s.m_131148_(col));
            }
            result.m_7220_((Component)ch);
        }
        return result;
    }

    private void initObfuscation() {
        this.baseText = this.text.getString();
        this.revealMask = new boolean[this.baseText.length()];
        this.revealOrder = new ArrayList<Integer>(this.baseText.length());
        for (int i = 0; i < this.baseText.length(); ++i) {
            this.revealOrder.add(i);
        }
        switch (this.obfuscateMode) {
            case RIGHT: {
                Collections.reverse(this.revealOrder);
                break;
            }
            case CENTER: {
                this.revealOrder.clear();
                int left = (this.baseText.length() - 1) / 2;
                int right = this.baseText.length() / 2;
                while (left >= 0 || right < this.baseText.length()) {
                    if (left >= 0) {
                        this.revealOrder.add(left--);
                    }
                    if (right >= this.baseText.length()) continue;
                    this.revealOrder.add(right++);
                }
                break;
            }
            case RANDOM: {
                Collections.shuffle(this.revealOrder, this.random);
                break;
            }
        }
        this.revealIndex = 0;
        this.obfuscateProgress = 0.0f;
        this.rebuildObfuscation();
    }

    private void rebuildObfuscation() {
        MutableComponent result = Component.m_237113_((String)"");
        int limit = this.typewriter ? this.typewriterIndex : (this.baseText == null ? 0 : this.baseText.length());
        for (int i = 0; i < limit; ++i) {
            TextColor col;
            char c = this.baseText.charAt(i);
            MutableComponent ch = Component.m_237113_((String)String.valueOf(c)).m_130948_(this.text.m_7383_());
            if (this.gradientColors != null && i < this.gradientColors.length && (col = this.gradientColors[i]) != null) {
                ch = ch.m_130938_(s -> s.m_131148_(col));
            }
            if (!this.revealMask[i]) {
                ch = ch.m_130938_(s -> s.m_178524_(Boolean.valueOf(true)));
            }
            result.m_7220_((Component)ch);
        }
        this.current = result;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130083_(this.text);
        buf.writeFloat(this.duration);
        buf.writeFloat(this.xOffset);
        buf.writeFloat(this.yOffset);
        buf.writeBoolean(this.shadow);
        buf.m_130068_((Enum)this.anchor);
        buf.m_130068_((Enum)this.align);
        buf.writeBoolean(this.background);
        buf.writeInt(this.backgroundColor.getARGB());
        buf.writeInt(this.borderStart.getARGB());
        buf.writeInt(this.borderEnd.getARGB());
        buf.writeFloat(this.textScale);
        buf.writeBoolean(this.typewriter);
        buf.writeFloat(this.typewriterSpeed);
        buf.writeBoolean(this.typewriterCenter);
        buf.m_130068_((Enum)this.obfuscateMode);
        buf.writeFloat(this.obfuscateSpeed);
        buf.writeBoolean(this.useTextureBackground && this.backgroundTexture != null);
        if (this.useTextureBackground && this.backgroundTexture != null) {
            buf.m_130085_(this.backgroundTexture);
            buf.m_130130_(this.textureU);
            buf.m_130130_(this.textureV);
            buf.m_130130_(this.textureWidth);
            buf.m_130130_(this.textureHeight);
            buf.m_130130_(this.textureAtlasWidth);
            buf.m_130130_(this.textureAtlasHeight);
            buf.writeFloat(this.texturePaddingX);
            buf.writeFloat(this.texturePaddingY);
            buf.writeFloat(this.textureScaleX);
            buf.writeFloat(this.textureScaleY);
            buf.writeBoolean(this.textureOverrideWidth >= 0.0f);
            if (this.textureOverrideWidth >= 0.0f) {
                buf.writeFloat(this.textureOverrideWidth);
            }
            buf.writeBoolean(this.textureOverrideHeight >= 0.0f);
            if (this.textureOverrideHeight >= 0.0f) {
                buf.writeFloat(this.textureOverrideHeight);
            }
            buf.m_130068_((Enum)this.textureSizingMode);
        }
        buf.writeBoolean(this.gradientStops != null);
        if (this.gradientStops != null) {
            buf.m_130130_(this.gradientStops.length);
            for (TextColor textColor : this.gradientStops) {
                buf.writeInt(textColor.m_131265_());
            }
        }
        buf.writeBoolean(this.backgroundGradientStops != null);
        if (this.backgroundGradientStops != null) {
            buf.m_130130_(this.backgroundGradientStops.length);
            for (ImmersiveColor immersiveColor : this.backgroundGradientStops) {
                buf.writeInt(immersiveColor.getARGB());
            }
        }
        buf.writeBoolean(this.shake);
        buf.m_130068_((Enum)this.shakeType);
        buf.writeFloat(this.shakeStrength);
        buf.writeBoolean(this.charShake);
        buf.m_130068_((Enum)this.charShakeType);
        buf.writeFloat(this.charShakeStrength);
        buf.writeInt(this.wrapMaxWidth);
        buf.writeFloat(this.delay);
    }

    public static ImmersiveMessage decode(FriendlyByteBuf buf) {
        int i;
        Object[] cols;
        int count;
        Component text = buf.m_130238_();
        float duration = buf.readFloat();
        ImmersiveMessage msg = new ImmersiveMessage(text, duration);
        msg.xOffset = buf.readFloat();
        msg.yOffset = buf.readFloat();
        msg.shadow = buf.readBoolean();
        msg.anchor = (TextAnchor)buf.m_130066_(TextAnchor.class);
        msg.align = (TextAnchor)buf.m_130066_(TextAnchor.class);
        msg.background = buf.readBoolean();
        msg.backgroundColor = new ImmersiveColor(buf.readInt());
        msg.borderStart = new ImmersiveColor(buf.readInt());
        msg.borderEnd = new ImmersiveColor(buf.readInt());
        msg.textScale = buf.readFloat();
        msg.typewriter = buf.readBoolean();
        msg.typewriterSpeed = buf.readFloat();
        msg.typewriterCenter = buf.readBoolean();
        msg.obfuscateMode = (ObfuscateMode)buf.m_130066_(ObfuscateMode.class);
        msg.obfuscateSpeed = buf.readFloat();
        if (buf.readBoolean()) {
            msg.backgroundTexture = buf.m_130281_();
            msg.textureU = buf.m_130242_();
            msg.textureV = buf.m_130242_();
            msg.textureWidth = Math.max(1, buf.m_130242_());
            msg.textureHeight = Math.max(1, buf.m_130242_());
            msg.textureAtlasWidth = Math.max(1, buf.m_130242_());
            msg.textureAtlasHeight = Math.max(1, buf.m_130242_());
            msg.texturePaddingX = buf.readFloat();
            msg.texturePaddingY = buf.readFloat();
            msg.textureScaleX = buf.readFloat();
            msg.textureScaleY = buf.readFloat();
            msg.textureOverrideWidth = buf.readBoolean() ? buf.readFloat() : -1.0f;
            msg.textureOverrideHeight = buf.readBoolean() ? buf.readFloat() : -1.0f;
            msg.textureSizingMode = (TextureSizingMode)buf.m_130066_(TextureSizingMode.class);
            msg.useTextureBackground = true;
            msg.background = true;
        }
        if (buf.readBoolean()) {
            count = buf.m_130242_();
            cols = new TextColor[count];
            for (i = 0; i < count; ++i) {
                cols[i] = TextColor.m_131266_((int)buf.readInt());
            }
            msg.gradient((TextColor[])cols);
        }
        if (buf.readBoolean()) {
            count = buf.m_130242_();
            cols = new ImmersiveColor[count];
            for (i = 0; i < count; ++i) {
                cols[i] = new ImmersiveColor(buf.readInt());
            }
            msg.backgroundGradient((ImmersiveColor[])cols);
        }
        msg.shake = buf.readBoolean();
        msg.shakeType = (ShakeType)buf.m_130066_(ShakeType.class);
        msg.shakeStrength = buf.readFloat();
        msg.charShake = buf.readBoolean();
        msg.charShakeType = (ShakeType)buf.m_130066_(ShakeType.class);
        msg.charShakeStrength = buf.readFloat();
        msg.wrapMaxWidth = buf.readInt();
        msg.delay = buf.readFloat();
        if (msg.obfuscateMode != ObfuscateMode.NONE) {
            msg.initObfuscation();
        }
        return msg;
    }

    public void tick(float delta) {
        int next;
        this.age += delta;
        if (this.typewriter && (next = (int)(this.age * this.typewriterSpeed)) > this.typewriterIndex) {
            this.typewriterIndex = Math.min(next, this.text.getString().length());
            if (this.obfuscateMode != ObfuscateMode.NONE) {
                this.rebuildObfuscation();
            } else {
                this.current = this.gradientColors != null ? this.buildGradientComponent(this.typewriterIndex) : Component.m_237113_((String)this.text.getString().substring(0, this.typewriterIndex)).m_130948_(this.text.m_7383_());
            }
        }
        if (this.obfuscateMode != ObfuscateMode.NONE) {
            this.tickObfuscation(delta);
        }
    }

    private void tickObfuscation(float delta) {
        if (this.baseText == null || this.revealIndex >= this.revealOrder.size()) {
            return;
        }
        this.obfuscateProgress += this.obfuscateSpeed * delta;
        int revealCount = Math.min((int)this.obfuscateProgress, this.revealOrder.size() - this.revealIndex);
        if (revealCount <= 0) {
            return;
        }
        int revealed = 0;
        for (int i = 0; i < revealCount; ++i) {
            int idx = this.revealOrder.get(this.revealIndex);
            if (this.typewriter && idx >= this.typewriterIndex) break;
            this.revealMask[idx] = true;
            ++this.revealIndex;
            ++revealed;
        }
        if (revealed <= 0) {
            return;
        }
        this.obfuscateProgress -= (float)revealed;
        this.rebuildObfuscation();
    }

    public boolean isFinished() {
        return this.age >= this.duration;
    }

    public float getDelay() {
        return this.delay;
    }

    public void render(GuiGraphics graphics) {
        int baseHeight;
        int baseWidth;
        MutableComponent draw = this.typewriter ? this.current : (this.current.getString().isEmpty() ? this.text : this.current);
        Font font = Minecraft.m_91087_().f_91062_;
        CaxtonCompat.WidthProvider caxtonHandler = CaxtonCompat.getHandler();
        List lines = null;
        if (this.wrapMaxWidth > 0) {
            lines = font.m_92923_((FormattedText)draw, this.wrapMaxWidth);
            float maxWidth = 0.0f;
            for (FormattedCharSequence line : lines) {
                float caxtonWidth;
                float width = font.m_92865_().m_92336_(line);
                if (caxtonHandler != null && !Float.isNaN(caxtonWidth = caxtonHandler.getWidth(line))) {
                    width = caxtonWidth;
                }
                maxWidth = Math.max(maxWidth, width);
            }
            baseWidth = Mth.m_14167_((float)maxWidth);
            int n = lines.size();
            Objects.requireNonNull(font);
            baseHeight = n * 9;
        } else {
            float caxtonWidth;
            float width = font.m_92865_().m_92336_(draw.m_7532_());
            if (caxtonHandler != null && !Float.isNaN(caxtonWidth = caxtonHandler.getWidth(draw.m_7532_()))) {
                width = caxtonWidth;
            }
            baseWidth = Mth.m_14167_((float)width);
            Objects.requireNonNull(font);
            baseHeight = 9;
        }
        float charPadding = this.charShake ? this.charShakeStrength : 0.0f;
        float textAreaWidth = (float)baseWidth + charPadding * 2.0f;
        float textAreaHeight = (float)baseHeight + charPadding * 2.0f;
        float scaledWidth = this.textureOverrideWidth >= 0.0f ? this.textureOverrideWidth : textAreaWidth * Math.max(this.textureScaleX, 0.0f);
        float scaledHeight = this.textureOverrideHeight >= 0.0f ? this.textureOverrideHeight : textAreaHeight * Math.max(this.textureScaleY, 0.0f);
        scaledWidth = Math.max(scaledWidth, textAreaWidth);
        scaledHeight = Math.max(scaledHeight, textAreaHeight);
        float backgroundWidth = scaledWidth + this.texturePaddingX * 2.0f;
        float backgroundHeight = scaledHeight + this.texturePaddingY * 2.0f;
        float extraX = (backgroundWidth - textAreaWidth) / 2.0f;
        float extraY = (backgroundHeight - textAreaHeight) / 2.0f;
        float textStartX = extraX + charPadding;
        float textStartY = extraY + charPadding;
        int backgroundWidthInt = Mth.m_14167_((float)backgroundWidth);
        int backgroundHeightInt = Mth.m_14167_((float)backgroundHeight);
        int screenW = Minecraft.m_91087_().m_91268_().m_85445_();
        int screenH = Minecraft.m_91087_().m_91268_().m_85446_();
        float x = (float)screenW * this.anchor.xFactor - (float)baseWidth * this.textScale * this.align.xFactor + this.xOffset;
        float y = (float)screenH * this.anchor.yFactor - (float)baseHeight * this.textScale * this.align.yFactor + this.yOffset;
        if (this.shake) {
            float sx = 0.0f;
            float sy = 0.0f;
            switch (this.shakeType) {
                case WAVE: {
                    sy = (float)Math.sin(this.age * 10.0f) * this.shakeStrength;
                    break;
                }
                case CIRCLE: {
                    sx = (float)Math.cos(this.age * 10.0f) * this.shakeStrength;
                    sy = (float)Math.sin(this.age * 10.0f) * this.shakeStrength;
                    break;
                }
                case RANDOM: {
                    sx = (this.random.nextFloat() - 0.5f) * 2.0f * this.shakeStrength;
                    sy = (this.random.nextFloat() - 0.5f) * 2.0f * this.shakeStrength;
                }
            }
            x += sx;
            y += sy;
        }
        float fadeTime = Math.min(10.0f, this.duration * 0.25f);
        float alpha = 1.0f;
        if (this.age < fadeTime) {
            alpha = this.age / fadeTime;
        } else if (this.age > this.duration - fadeTime) {
            alpha = (this.duration - this.age) / fadeTime;
        }
        alpha = Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f);
        int colour = (int)(alpha * 255.0f) << 24 | (this.text.m_7383_().m_131135_() != null ? this.text.m_7383_().m_131135_().m_131265_() : 0xFFFFFF);
        if (this.typewriter && this.typewriterCenter && this.wrapMaxWidth <= 0) {
            float caxtonWidth;
            float caxtonWidth2;
            float fullWidth = font.m_92852_((FormattedText)this.text);
            if (caxtonHandler != null && !Float.isNaN(caxtonWidth2 = caxtonHandler.getWidth(this.text.m_7532_()))) {
                fullWidth = caxtonWidth2;
            }
            float currentWidth = font.m_92852_((FormattedText)draw);
            if (caxtonHandler != null && !Float.isNaN(caxtonWidth = caxtonHandler.getWidth(draw.m_7532_()))) {
                currentWidth = caxtonWidth;
            }
            x += (fullWidth - currentWidth) / 2.0f * this.textScale;
        }
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_252880_(x - textStartX * this.textScale, y - textStartY * this.textScale, 0.0f);
        graphics.m_280168_().m_85841_(this.textScale, this.textScale, 1.0f);
        if (this.background) {
            int widthForBg;
            int start = Math.min(255, (int)((float)this.borderStart.getAlpha() * alpha)) << 24 | this.borderStart.getRGB();
            int end = Math.min(255, (int)((float)this.borderEnd.getAlpha() * alpha)) << 24 | this.borderEnd.getRGB();
            int n = widthForBg = this.shake ? backgroundWidthInt + 200 : backgroundWidthInt;
            if (this.useTextureBackground && this.backgroundTexture != null) {
                RenderSystem.enableBlend();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                if (this.textureSizingMode == TextureSizingMode.STRETCH) {
                    graphics.m_280411_(this.backgroundTexture, 0, 0, widthForBg, backgroundHeightInt, (float)this.textureU, (float)this.textureV, this.textureWidth, this.textureHeight, this.textureAtlasWidth, this.textureAtlasHeight);
                } else {
                    int drawWidth = Math.min(widthForBg, this.textureWidth);
                    int drawHeight = Math.min(backgroundHeightInt, this.textureHeight);
                    int destX = Math.max(0, (widthForBg - drawWidth) / 2);
                    int destY = Math.max(0, (backgroundHeightInt - drawHeight) / 2);
                    int uOffset = this.textureU;
                    int vOffset = this.textureV;
                    if (drawWidth < this.textureWidth) {
                        uOffset += (this.textureWidth - drawWidth) / 2;
                    }
                    if (drawHeight < this.textureHeight) {
                        vOffset += (this.textureHeight - drawHeight) / 2;
                    }
                    graphics.m_280411_(this.backgroundTexture, destX, destY, drawWidth, drawHeight, (float)uOffset, (float)vOffset, drawWidth, drawHeight, this.textureAtlasWidth, this.textureAtlasHeight);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableBlend();
            } else if (this.backgroundGradientStops != null) {
                int[] cols = new int[this.backgroundGradientStops.length];
                for (int i = 0; i < this.backgroundGradientStops.length; ++i) {
                    ImmersiveColor c = this.backgroundGradientStops[i];
                    int a = Math.min(255, (int)((float)c.getAlpha() * alpha));
                    cols[i] = a << 24 | c.getRGB();
                }
                RenderUtil.drawBackgroundGradient(graphics, 0, 0, widthForBg, backgroundHeightInt, cols, start, end);
            } else {
                int bg = Math.min(255, (int)((float)this.backgroundColor.getAlpha() * alpha)) << 24 | this.backgroundColor.getRGB();
                RenderUtil.drawBackground(graphics, 0, 0, widthForBg, backgroundHeightInt, bg, start, end);
            }
        }
        if (this.onRender != null) {
            this.onRender.render(graphics, this, 0, 0, alpha);
        } else if (this.charShake) {
            this.renderCharShake(graphics, lines, (Component)draw, colour, textStartX, textStartY);
        } else if (lines != null) {
            int drawStartX = Mth.m_14143_((float)textStartX);
            for (int i = 0; i < lines.size(); ++i) {
                Objects.requireNonNull(font);
                int drawStartY = Mth.m_14143_((float)(textStartY + (float)(i * 9)));
                graphics.m_280649_(font, (FormattedCharSequence)lines.get(i), drawStartX, drawStartY, colour, this.shadow);
            }
        } else {
            int drawStartX = Mth.m_14143_((float)textStartX);
            int drawStartY = Mth.m_14143_((float)textStartY);
            graphics.m_280614_(font, (Component)draw, drawStartX, drawStartY, colour, this.shadow);
        }
        graphics.m_280168_().m_85849_();
    }

    private void renderCharShake(GuiGraphics graphics, List<FormattedCharSequence> lines, Component draw, int colour, float baseX, float baseY) {
        Font font = Minecraft.m_91087_().f_91062_;
        CaxtonCompat.WidthProvider handler = CaxtonCompat.getHandler();
        int[] index = new int[]{0};
        if (lines != null) {
            for (int i = 0; i < lines.size(); ++i) {
                Objects.requireNonNull(font);
                float lineBaseY = baseY + (float)(i * 9);
                float[] xAdvance = new float[]{baseX};
                FormattedCharSequence lineSeq = lines.get(i);
                lineSeq.m_13731_((pos, style, codePoint) -> {
                    float caxtonWidth;
                    String ch = new String(Character.toChars(codePoint));
                    float sx = 0.0f;
                    float sy = 0.0f;
                    switch (this.charShakeType) {
                        case WAVE: {
                            sy = (float)Math.sin(this.age * 10.0f + (float)index[0]) * this.charShakeStrength;
                            break;
                        }
                        case CIRCLE: {
                            sx = (float)Math.cos(this.age * 10.0f + (float)index[0]) * this.charShakeStrength;
                            sy = (float)Math.sin(this.age * 10.0f + (float)index[0]) * this.charShakeStrength;
                            break;
                        }
                        case RANDOM: {
                            sx = (this.random.nextFloat() - 0.5f) * 2.0f * this.charShakeStrength;
                            sy = (this.random.nextFloat() - 0.5f) * 2.0f * this.charShakeStrength;
                        }
                    }
                    MutableComponent comp = Component.m_237113_((String)ch).m_130948_(style);
                    FormattedCharSequence charSeq = comp.m_7532_();
                    float cw = font.m_92724_(charSeq);
                    if (handler != null && !Float.isNaN(caxtonWidth = handler.getWidth(charSeq))) {
                        cw = caxtonWidth;
                    }
                    graphics.m_280168_().m_85836_();
                    graphics.m_280168_().m_252880_(xAdvance[0] + sx, lineBaseY + sy, 0.0f);
                    graphics.m_280649_(font, charSeq, 0, 0, colour, this.shadow);
                    graphics.m_280168_().m_85849_();
                    xAdvance[0] = xAdvance[0] + cw;
                    index[0] = index[0] + 1;
                    return true;
                });
            }
        } else {
            float[] xAdvance = new float[]{baseX};
            draw.m_7532_().m_13731_((pos, style, codePoint) -> {
                String ch = new String(Character.toChars(codePoint));
                float sx = 0.0f;
                float sy = 0.0f;
                switch (this.charShakeType) {
                    case WAVE: {
                        sy = (float)Math.sin(this.age * 10.0f + (float)index[0]) * this.charShakeStrength;
                        break;
                    }
                    case CIRCLE: {
                        sx = (float)Math.cos(this.age * 10.0f + (float)index[0]) * this.charShakeStrength;
                        sy = (float)Math.sin(this.age * 10.0f + (float)index[0]) * this.charShakeStrength;
                        break;
                    }
                    case RANDOM: {
                        sx = (this.random.nextFloat() - 0.5f) * 2.0f * this.charShakeStrength;
                        sy = (this.random.nextFloat() - 0.5f) * 2.0f * this.charShakeStrength;
                    }
                }
                MutableComponent comp = Component.m_237113_((String)ch).m_130948_(style);
                FormattedCharSequence charSeq = comp.m_7532_();
                float cw = handler != null ? handler.getWidth(charSeq) : (float)font.m_92724_(charSeq);
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_252880_(xAdvance[0] + sx, baseY + sy, 0.0f);
                graphics.m_280649_(font, charSeq, 0, 0, colour, this.shadow);
                graphics.m_280168_().m_85849_();
                xAdvance[0] = xAdvance[0] + cw;
                index[0] = index[0] + 1;
                return true;
            });
        }
    }

    public static enum TextureSizingMode {
        STRETCH,
        CROP;


        public static TextureSizingMode fromString(String value) {
            if (value == null) {
                return STRETCH;
            }
            return switch (value.toLowerCase(Locale.ROOT)) {
                case "crop", "cut", "cover" -> CROP;
                default -> STRETCH;
            };
        }
    }
}

