/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.network;

import com.yungnickyoung.minecraft.ribbits.network.ServerPacketHandlerForge;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ToggleSupporterHatC2SPacket {
    private final UUID playerUuid;
    private final boolean enabled;

    public ToggleSupporterHatC2SPacket(UUID playerUuid, boolean enabled) {
        this.playerUuid = playerUuid;
        this.enabled = enabled;
    }

    public ToggleSupporterHatC2SPacket(FriendlyByteBuf buf) {
        this.playerUuid = buf.m_130259_();
        this.enabled = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130077_(this.playerUuid);
        buf.writeBoolean(this.enabled);
    }

    public boolean handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> ServerPacketHandlerForge.handleToggleSupporterHat(this, ctx));
        ctx.get().setPacketHandled(true);
        return true;
    }

    public UUID getPlayerUuid() {
        return this.playerUuid;
    }

    public boolean getEnabled() {
        return this.enabled;
    }
}

