/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.module;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import com.yungnickyoung.minecraft.ribbits.entity.trade.AmethystForItems;
import com.yungnickyoung.minecraft.ribbits.entity.trade.EnchantedItemForAmethyst;
import com.yungnickyoung.minecraft.ribbits.entity.trade.ItemListing;
import com.yungnickyoung.minecraft.ribbits.entity.trade.ItemsForAmethysts;
import com.yungnickyoung.minecraft.ribbits.module.BlockModule;
import com.yungnickyoung.minecraft.ribbits.module.ItemModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitProfessionModule;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;

public class RibbitTradeModule {
    public static final Map<RibbitProfession, ItemListing[]> TRADES_BY_PROFESSION = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
        map.put(RibbitProfessionModule.MERCHANT, new ItemListing[]{new ItemsForAmethysts(((Block)BlockModule.BROWN_TOADSTOOL.get()).m_5456_(), 1, 1, 8, 16, 32), new ItemsForAmethysts(((Block)BlockModule.RED_TOADSTOOL.get()).m_5456_(), 1, 1, 8, 16, 32), new ItemsForAmethysts(((Block)BlockModule.TOADSTOOL_STEM.get()).m_5456_(), 1, 1, 8, 16, 32), new ItemsForAmethysts(((Block)BlockModule.MOSSY_OAK_PLANKS.get()).m_5456_(), 1, 2, 16, 32, 32), new ItemsForAmethysts(((Block)BlockModule.SWAMP_LANTERN.get()).m_5456_(), 2, 3, 4, 8, 32), new ItemsForAmethysts((Item)ItemModule.MARACA.get(), 6, 8, 1, 1, 4)});
        map.put(RibbitProfessionModule.FISHERMAN, new ItemListing[]{new ItemsForAmethysts(Items.f_151057_, 4, 8, 1, 1, 16), new ItemsForAmethysts(Items.f_42459_, 4, 8, 1, 1, 16), new ItemsForAmethysts(Items.f_42530_, 4, 8, 8, 24, 16), new ItemsForAmethysts(Items.f_42531_, 4, 8, 8, 24, 16), new EnchantedItemForAmethyst(Items.f_42523_, 12, 16, 4), new AmethystForItems((ItemLike)Items.f_42526_, 16, 32, 4, 8, 16), new AmethystForItems((ItemLike)Items.f_42527_, 16, 32, 4, 8, 16)});
    });

    public static void updateTrades(RibbitEntity ribbit) {
        ItemListing[] itemListings = TRADES_BY_PROFESSION.get(ribbit.getRibbitData().getProfession());
        if (itemListings == null || itemListings.length == 0) {
            return;
        }
        int numOffers = ribbit.getRibbitData().getProfession() == RibbitProfessionModule.MERCHANT ? 10 : 4;
        HashSet chosenIndices = Sets.newHashSet();
        if (itemListings.length > numOffers) {
            while (chosenIndices.size() < numOffers) {
                chosenIndices.add(ribbit.m_217043_().m_188503_(itemListings.length));
            }
        } else {
            for (int i = 0; i < itemListings.length; ++i) {
                chosenIndices.add(i);
            }
        }
        for (Integer index : chosenIndices) {
            ItemListing itemListing = itemListings[index];
            MerchantOffer merchantOffer = itemListing.getOffer((Entity)ribbit, ribbit.m_217043_());
            if (merchantOffer == null) continue;
            ribbit.m_6616_().add((Object)merchantOffer);
        }
    }
}

