/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.client.supporters;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.services.Services;
import com.yungnickyoung.minecraft.yungsapi.io.JSON;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class RibbitOptionsJSON {
    private static RibbitOptionsJSON instance;
    private boolean enableSupporterHat;

    public static RibbitOptionsJSON get() {
        if (instance == null) {
            instance = new RibbitOptionsJSON(false);
        }
        return instance;
    }

    private RibbitOptionsJSON(boolean enableSupporterHat) {
        this.enableSupporterHat = enableSupporterHat;
    }

    public boolean isSupporterHatEnabled() {
        return this.enableSupporterHat;
    }

    public void setSupporterHatEnabled(boolean enabled) {
        this.enableSupporterHat = enabled;
        Services.SUPPORTER_HELPER.notifyServerOfSupporterHatState(enabled);
        this.saveToFile();
    }

    private void saveToFile() {
        try (FileWriter writer = new FileWriter(RibbitOptionsJSON.getOptionsFilePath().toFile());){
            JSON.gson.toJson((Object)instance, (Appendable)writer);
        }
        catch (IOException e) {
            RibbitsCommon.LOGGER.error("Error saving ribbits-options.json file: {}", (Object)e.toString());
        }
    }

    public static void loadFromFile() {
        Path path = RibbitOptionsJSON.getOptionsFilePath();
        File file = new File(path.toString());
        if (!file.exists()) {
            try {
                JSON.createJsonFileFromObject((Path)path, (Object)RibbitOptionsJSON.get());
            }
            catch (IOException e) {
                RibbitsCommon.LOGGER.error("Unable to create ribbits-options.json file: {}", (Object)e.toString());
            }
        } else {
            if (!file.canRead()) {
                RibbitsCommon.LOGGER.error("ribbits-options.json file not readable! Using default configuration...");
                return;
            }
            try {
                instance = (RibbitOptionsJSON)JSON.loadObjectFromJsonFile((Path)path, RibbitOptionsJSON.class);
            }
            catch (IOException e) {
                RibbitsCommon.LOGGER.error("Error loading ribbits-options.json file: {}", (Object)e.toString());
                RibbitsCommon.LOGGER.error("Using default configuration...");
            }
        }
    }

    private static Path getOptionsFilePath() {
        return Paths.get(Services.PLATFORM.getConfigPath().toString(), "ribbits-options.json");
    }
}

