/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import vazkii.botania.api.block.Bound;
import vazkii.botania.common.block.BotaniaBlocks;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntity;
import vazkii.botania.common.block.flower.generating.DandelifeonBlockEntity;

public class CellularBlockEntity
extends BotaniaBlockEntity {
    private static final String TAG_GENERATION = "generation";
    private static final String TAG_TICKED = "ticked";
    private static final String TAG_FLOWER_X = "flowerX";
    private static final String TAG_FLOWER_Y = "flowerY";
    private static final String TAG_FLOWER_Z = "flowerZ";
    private static final String TAG_VALID_X = "validX";
    private static final String TAG_VALID_Y = "validY";
    private static final String TAG_VALID_Z = "validZ";
    private int generation;
    private int nextGeneration;
    private boolean ticked;
    private BlockPos flowerCoords = Bound.UNBOUND_POS;
    private BlockPos validCoords = Bound.UNBOUND_POS;

    public CellularBlockEntity(BlockPos pos, BlockState state) {
        super(BotaniaBlockEntities.CELL_BLOCK, pos, state);
    }

    public void setGeneration(int gen) {
        this.generation = gen;
    }

    public void setNextGeneration(DandelifeonBlockEntity flower, int gen) {
        this.nextGeneration = gen;
        this.m_58904_().m_186460_(this.m_58899_(), BotaniaBlocks.cellBlock, 1);
        if (!this.ticked) {
            this.claim(flower);
            this.ticked = true;
        } else if (!this.validCoords.equals((Object)this.m_58899_()) || !this.flowerCoords.equals((Object)flower.getEffectivePos())) {
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
    }

    public void claim(DandelifeonBlockEntity flower) {
        if (!this.ticked) {
            this.flowerCoords = flower.getEffectivePos();
            this.validCoords = this.m_58899_();
        }
    }

    public void update(Level level) {
        if (this.nextGeneration == -1) {
            level.m_7471_(this.m_58899_(), false);
        }
        this.generation = this.nextGeneration;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasActiveParent(DandelifeonBlockEntity dandie) {
        if (this.flowerCoords == null) return false;
        BlockEntity blockEntity = dandie.m_58904_().m_7702_(this.flowerCoords);
        if (!(blockEntity instanceof DandelifeonBlockEntity)) return false;
        DandelifeonBlockEntity parent = (DandelifeonBlockEntity)blockEntity;
        if (!dandie.m_58904_().m_276867_(this.flowerCoords)) return false;
        if (!dandie.overgrowthBoost) return true;
        if (!parent.isOnSpecialSoil()) return false;
        return true;
    }

    public int getGeneration() {
        return this.generation;
    }

    @Override
    public void writePacketNBT(CompoundTag cmp) {
        cmp.m_128405_(TAG_GENERATION, this.generation);
        cmp.m_128379_(TAG_TICKED, this.ticked);
        if (this.ticked) {
            cmp.m_128405_(TAG_FLOWER_X, this.flowerCoords.m_123341_());
            cmp.m_128405_(TAG_FLOWER_Y, this.flowerCoords.m_123342_());
            cmp.m_128405_(TAG_FLOWER_Z, this.flowerCoords.m_123343_());
            cmp.m_128405_(TAG_VALID_X, this.validCoords.m_123341_());
            cmp.m_128405_(TAG_VALID_Y, this.validCoords.m_123342_());
            cmp.m_128405_(TAG_VALID_Z, this.validCoords.m_123343_());
        }
    }

    @Override
    public void readPacketNBT(CompoundTag cmp) {
        this.generation = cmp.m_128451_(TAG_GENERATION);
        this.ticked = cmp.m_128471_(TAG_TICKED);
        if (this.ticked) {
            this.flowerCoords = new BlockPos(cmp.m_128451_(TAG_FLOWER_X), cmp.m_128451_(TAG_FLOWER_Y), cmp.m_128451_(TAG_FLOWER_Z));
            this.validCoords = new BlockPos(cmp.m_128451_(TAG_VALID_X), cmp.m_128451_(TAG_VALID_Y), cmp.m_128451_(TAG_VALID_Z));
        }
    }

    public boolean m_6326_() {
        return true;
    }
}

