/*
 * Decompiled with CFR 0.152.
 */
package com.bonker.stardewfishing.client;

import com.bonker.stardewfishing.SFConfig;
import com.bonker.stardewfishing.StardewFishing;
import com.bonker.stardewfishing.client.FishDisplayBER;
import com.bonker.stardewfishing.client.RodTooltipHandler;
import com.bonker.stardewfishing.client.SparkleParticle;
import com.bonker.stardewfishing.common.init.SFBlockEntities;
import com.bonker.stardewfishing.common.init.SFParticles;
import com.bonker.stardewfishing.common.init.SFSoundEvents;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.sound.PlaySoundSourceEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

public class ClientEvents {

    @Mod.EventBusSubscriber(modid="stardew_fishing", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class ModBus {
        @SubscribeEvent
        public static void onRegisterRenderers(EntityRenderersEvent.RegisterRenderers event) {
            event.registerBlockEntityRenderer((BlockEntityType)SFBlockEntities.FISH_DISPLAY.get(), FishDisplayBER::new);
        }

        @SubscribeEvent
        public static void onParticleRegistration(RegisterParticleProvidersEvent event) {
            event.registerSpriteSet((ParticleType)SFParticles.SPARKLE.get(), SparkleParticle.Provider::new);
        }
    }

    @Mod.EventBusSubscriber(modid="stardew_fishing", value={Dist.CLIENT})
    public static class ForgeBus {
        @SubscribeEvent
        public static void onRenderTooltip(RenderTooltipEvent.Pre event) {
            event.getGraphics().m_280168_().m_252880_(0.0f, 0.0f, 500.0f);
        }

        @SubscribeEvent
        public static void onClientTick(TickEvent.ClientTickEvent event) {
            if (event.phase != TickEvent.Phase.START) {
                return;
            }
            Screen screen = Minecraft.m_91087_().f_91080_;
            if (screen instanceof AbstractContainerScreen) {
                AbstractContainerScreen containerScreen = (AbstractContainerScreen)screen;
                RodTooltipHandler.tick(containerScreen.f_97734_, containerScreen.m_6262_().m_142621_());
            } else {
                RodTooltipHandler.clear();
            }
        }

        @SubscribeEvent
        public static void onScreenRendered(ContainerScreenEvent.Render.Foreground event) {
            if (SFConfig.isInventoryEquippingEnabled()) {
                RodTooltipHandler.render(event.getGuiGraphics(), Minecraft.m_91087_().getPartialTick(), event.getMouseX() - event.getContainerScreen().getGuiLeft(), event.getMouseY() - event.getContainerScreen().getGuiTop());
            }
        }

        @SubscribeEvent
        public static void onSoundPlayed(PlaySoundSourceEvent event) {
            try {
                SoundInstance soundInstance = event.getSound();
                if (soundInstance instanceof SimpleSoundInstance) {
                    SimpleSoundInstance instance = (SimpleSoundInstance)soundInstance;
                    if (event.getSound().m_7904_().m_135827_().equals("minecraft")) {
                        SoundEvent newEvent;
                        switch (event.getSound().m_7904_().m_135815_()) {
                            case "entity.fishing_bobber.throw": {
                                SoundEvent soundEvent = (SoundEvent)SFSoundEvents.CAST.get();
                                break;
                            }
                            case "entity.fishing_bobber.retrieve": {
                                SoundEvent soundEvent;
                                if (Minecraft.m_91087_().f_91073_ == null) {
                                    soundEvent = null;
                                    break;
                                }
                                Player player = Minecraft.m_91087_().f_91073_.m_45924_(event.getSound().m_7772_(), event.getSound().m_7780_(), event.getSound().m_7778_(), 1.0, false);
                                if (player == null || player.f_36083_ == null) {
                                    soundEvent = (SoundEvent)SFSoundEvents.PULL_ITEM.get();
                                    break;
                                }
                                soundEvent = (SoundEvent)SFSoundEvents.FISH_HIT.get();
                                break;
                            }
                            case "entity.fishing_bobber.splash": {
                                SoundEvent soundEvent = (SoundEvent)SFSoundEvents.FISH_BITE.get();
                                break;
                            }
                            default: {
                                SoundEvent soundEvent = newEvent = null;
                            }
                        }
                        if (newEvent != null) {
                            event.getEngine().m_120274_((SoundInstance)instance);
                            event.getEngine().m_120312_((SoundInstance)new SimpleSoundInstance(newEvent, instance.m_8070_(), 1.0f, 1.0f, SoundInstance.m_235150_(), instance.m_7772_(), instance.m_7780_(), instance.m_7778_()));
                        }
                    }
                }
            }
            catch (Exception e) {
                StardewFishing.LOGGER.error("An exception occurred while trying to replace a sound event. I think this happens when you try to use a fishing rod in extremely laggy conditions.", (Throwable)e);
            }
        }
    }
}

