/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin.inventory;

import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public abstract class SortingItemStackHandler
implements IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    protected List<ItemStack> stacks;
    protected int max_slots;

    public SortingItemStackHandler(int slots) {
        this.max_slots = slots;
        this.stacks = NonNullList.m_122780_((int)this.max_slots, (Object)ItemStack.f_41583_);
    }

    public void deserializeNBT(CompoundTag nbt) {
        ListTag tagList = nbt.m_128437_("Items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("Slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, ItemStack.m_41712_((CompoundTag)itemTags));
        }
    }

    public void setStackInSlot(int slot, @NotNull ItemStack stack) {
        this.stacks.set(slot, stack);
        this.onContentsChanged(slot);
    }

    public int getSlots() {
        return Math.min(this.stacks.size(), this.max_slots);
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return slot < this.stacks.size() ? this.stacks.get(slot) : ItemStack.f_41583_;
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        ItemStack existing = this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (existing.m_41619_()) {
                this.stacks.set(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.onContentsChanged(slot);
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    protected void onContentsChanged(int slot) {
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        ItemStack existing = this.stacks.get(slot);
        if (existing.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, existing.m_41741_());
        if (existing.m_41613_() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, ItemStack.f_41583_);
                this.shiftLeft(slot);
                this.onContentsChanged(slot);
                return existing;
            }
            return existing.m_41777_();
        }
        if (!simulate) {
            this.stacks.set(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.m_41613_() - toExtract)));
            this.onContentsChanged(slot);
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    protected void shiftLeft(int slot) {
        ItemStack existing = this.getStackInSlot(slot);
        if (existing.m_41619_()) {
            for (int i = slot; i < this.getSlots() - 1; ++i) {
                ItemStack right = this.getStackInSlot(i + 1);
                this.setStackInSlot(i, right.m_41777_());
                this.setStackInSlot(i + 1, ItemStack.f_41583_);
            }
        }
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    protected int getStackLimit(int slot, @NotNull ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return true;
    }
}

