/*
 * Decompiled with CFR 0.152.
 */
package tfar.shippingbin;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class Utils {
    public static final MutableComponent TRADING = Component.m_237115_((String)"category.shippingbin.trading");
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    public static ItemStack getItemStack(JsonObject json, boolean readNBT) {
        String itemName = GsonHelper.m_13906_((JsonObject)json, (String)"item");
        Item item = Utils.getItem(itemName);
        if (readNBT && json.has("nbt")) {
            CompoundTag nbt = Utils.getNBT(json.get("nbt"));
            CompoundTag tmp = new CompoundTag();
            if (nbt.m_128441_("ForgeCaps")) {
                tmp.m_128365_("ForgeCaps", nbt.m_128423_("ForgeCaps"));
                nbt.m_128473_("ForgeCaps");
            }
            tmp.m_128365_("tag", (Tag)nbt);
            tmp.m_128359_("id", itemName);
            tmp.m_128405_("Count", GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
            return ItemStack.m_41712_((CompoundTag)tmp);
        }
        return new ItemStack((ItemLike)item, GsonHelper.m_13824_((JsonObject)json, (String)"count", (int)1));
    }

    public static Item getItem(String itemName) {
        ResourceLocation itemKey = new ResourceLocation(itemName);
        if (!BuiltInRegistries.f_257033_.m_7804_(itemKey)) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        Item item = (Item)BuiltInRegistries.f_257033_.m_7745_(itemKey);
        if (item == Items.f_41852_) {
            throw new JsonSyntaxException("Invalid item: " + itemName);
        }
        return Objects.requireNonNull(item);
    }

    public static Attribute getAttribute(String attributeName) {
        ResourceLocation itemKey = new ResourceLocation(attributeName);
        if (!BuiltInRegistries.f_256951_.m_7804_(itemKey)) {
            throw new JsonSyntaxException("Unknown attribute '" + attributeName + "'");
        }
        Attribute attribute = (Attribute)BuiltInRegistries.f_256951_.m_7745_(itemKey);
        return Objects.requireNonNull(attribute);
    }

    public static CompoundTag getNBT(JsonElement element) {
        try {
            if (element.isJsonObject()) {
                return TagParser.m_129359_((String)GSON.toJson(element));
            }
            return TagParser.m_129359_((String)GsonHelper.m_13805_((JsonElement)element, (String)"nbt"));
        }
        catch (CommandSyntaxException e) {
            throw new JsonSyntaxException("Invalid NBT Entry: " + e);
        }
    }
}

