/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.clayworks.core.data.server;

import com.google.common.collect.ImmutableList;
import com.teamabnormals.clayworks.common.block.KilnBlock;
import com.teamabnormals.clayworks.core.registry.ClayworksBlocks;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DecoratedPotBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.DynamicLoot;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.CopyNbtFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.registries.ForgeRegistries;

public class ClayworksLootTableProvider
extends LootTableProvider {
    public ClayworksLootTableProvider(PackOutput output) {
        super(output, BuiltInLootTables.m_78766_(), (List)ImmutableList.of((Object)new LootTableProvider.SubProviderEntry(ClayworksBlockLoot::new, LootContextParamSets.f_81421_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext context) {
    }

    public static class ClayworksBlockLoot
    extends BlockLootSubProvider {
        private static final Set<Item> EXPLOSION_RESISTANT = Stream.of(Blocks.f_50016_).map(ItemLike::m_5456_).collect(Collectors.toSet());
        public static final LootItemCondition.Builder HAS_SILK_TOUCH = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_45071_(new EnchantmentPredicate(Enchantments.f_44985_, MinMaxBounds.Ints.m_55386_((int)1))));
        public static final LootItemCondition.Builder HAS_NO_SILK_TOUCH = HAS_SILK_TOUCH.m_81807_();
        public static final ResourceLocation TRIM_DYNAMIC_DROP_ID = new ResourceLocation("clayworks", "trim");

        protected ClayworksBlockLoot() {
            super(EXPLOSION_RESISTANT, FeatureFlags.f_244280_.m_247355_());
        }

        public void m_245660_() {
            ClayworksBlocks.HELPER.getDeferredRegister().getEntries().forEach(registryObject -> {
                Block block = (Block)registryObject.get();
                if (block instanceof KilnBlock) {
                    this.m_246481_(block, x$0 -> this.m_246180_((Block)x$0));
                } else if (block instanceof DecoratedPotBlock) {
                    this.m_246481_(block, this::createDecoratedPotTable);
                } else if (block instanceof SlabBlock) {
                    this.m_246481_(block, x$0 -> this.m_247233_((Block)x$0));
                } else {
                    this.m_245724_(block);
                }
            });
        }

        private LootTable.Builder createDecoratedPotTable(Block block) {
            return LootTable.m_79147_().m_79161_(ClayworksBlockLoot.createDynamicTrimDropPool()).m_79161_(ClayworksBlockLoot.createDecoratedPotPool(block));
        }

        public static LootPool.Builder createDynamicTrimDropPool() {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(((LootPoolSingletonContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)TRIM_DYNAMIC_DROP_ID).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_271470_)))).m_79080_(HAS_NO_SILK_TOUCH));
        }

        public static LootPool.Builder createDecoratedPotPool(Block block) {
            return LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)((LootPoolSingletonContainer.Builder)DynamicLoot.m_79483_((ResourceLocation)DecoratedPotBlock.f_283767_).m_79080_(MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_204145_(ItemTags.f_271470_)))).m_79080_(HAS_NO_SILK_TOUCH)).m_7170_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block).m_79078_((LootItemFunction.Builder)CopyNbtFunction.m_165180_((NbtProvider)ContextNbtProvider.f_165562_).m_80279_("sherds", "BlockEntityTag.sherds").m_80279_("trim", "BlockEntityTag.trim"))));
        }

        public Iterable<Block> getKnownBlocks() {
            return ForgeRegistries.BLOCKS.getValues().stream().filter(block -> ForgeRegistries.BLOCKS.getKey(block).m_135827_().equals("clayworks")).collect(Collectors.toSet());
        }
    }
}

