/*
 * Decompiled with CFR 0.152.
 */
package com.teamabnormals.gallery.common.inventory;

import com.google.common.collect.Lists;
import com.teamabnormals.gallery.common.network.C2SPaintingVariantMessage;
import com.teamabnormals.gallery.core.Gallery;
import com.teamabnormals.gallery.core.registry.GalleryMenuTypes;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.PaintingVariantTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class PaintingSelectorMenu
extends AbstractContainerMenu {
    private final Level level;
    public Holder<PaintingVariant> selectedPainting = null;
    public List<Holder<PaintingVariant>> paintings = Lists.newArrayList();
    public List<Holder<PaintingVariant>> allPaintings = Lists.newArrayList();

    public PaintingSelectorMenu(int p_40297_, Inventory p_40298_) {
        super((MenuType)GalleryMenuTypes.PAINTING_SELECTOR.get(), p_40297_);
        this.level = p_40298_.f_35978_.m_9236_();
        this.setSelectedPainting((Holder<PaintingVariant>)((Holder)Painting.m_269030_((CompoundTag)p_40298_.f_35978_.m_21120_(p_40298_.f_35978_.m_7655_()).m_41698_("EntityTag")).orElse(null)));
        this.resetPaintingList();
        this.setupPaintingLists();
    }

    public Holder<PaintingVariant> getSelectedPainting() {
        return this.selectedPainting;
    }

    public void setSelectedPainting(Holder<PaintingVariant> painting) {
        this.selectedPainting = painting;
    }

    public void setSelectedPainting(ResourceLocation painting) {
        this.setSelectedPainting((Holder<PaintingVariant>)((Holder)((HolderLookup.RegistryLookup)this.level.m_9598_().m_254861_(Registries.f_256836_).get()).m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256836_, (ResourceLocation)painting)).get()));
    }

    public List<Holder<PaintingVariant>> getPaintings() {
        return this.paintings;
    }

    public List<Holder<PaintingVariant>> getAllPaintings() {
        return this.allPaintings;
    }

    public int getNumPaintings() {
        return this.paintings.size();
    }

    public boolean m_6875_(Player p_40307_) {
        return true;
    }

    public boolean m_6366_(Player player, int index) {
        if (index >= 0 && index < this.getNumPaintings() && this.level.f_46443_) {
            Holder<PaintingVariant> variant = this.getPaintings().get(index);
            this.setSelectedPainting(variant);
            Gallery.PLAY.sendToServer((Object)new C2SPaintingVariantMessage(((ResourceKey)variant.m_203543_().get()).m_135782_()));
        }
        return true;
    }

    public ItemStack m_7648_(Player p_38941_, int p_38942_) {
        return null;
    }

    public void resetPaintingList() {
        this.paintings = Lists.newArrayList();
    }

    public void setupPaintingLists() {
        this.allPaintings = ((HolderSet.Named)((HolderLookup.RegistryLookup)this.level.m_9598_().m_254861_(Registries.f_256836_).get()).m_254901_(PaintingVariantTags.f_215870_).get()).m_203614_().sorted(CreativeModeTabs.f_268478_).toList();
        this.paintings = List.copyOf(this.allPaintings);
    }

    public MenuType<?> m_6772_() {
        return (MenuType)GalleryMenuTypes.PAINTING_SELECTOR.get();
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        if (this.getSelectedPainting() != null) {
            InteractionHand hand = player.m_7655_();
            ItemStack stack = player.m_21120_(hand).m_41777_();
            CompoundTag tag = stack.m_41698_("EntityTag");
            Painting.m_269220_((CompoundTag)tag, this.getSelectedPainting());
            player.m_21008_(hand, stack);
        }
    }
}

