/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.hitching;

import io.github.mortuusars.horseman.horse.HitchableHorse;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Mob.class})
public abstract class MobMixin
extends LivingEntity {
    protected MobMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyVariable(method={"dropLeash"}, at=@At(value="HEAD"), ordinal=1, argsOnly=true)
    private boolean shouldDropLeash(boolean dropLeash) {
        HitchableHorse horse;
        MobMixin mobMixin;
        return dropLeash && (mobMixin = this) instanceof HitchableHorse ? !HitchableHorse.isHitched(horse = (HitchableHorse)((Object)mobMixin)) : dropLeash;
    }

    @Inject(method={"dropLeash"}, at={@At(value="RETURN")})
    private void onDropLeash(boolean broadcastPacket, boolean dropLeash, CallbackInfo ci) {
        MobMixin mobMixin = this;
        if (mobMixin instanceof HitchableHorse) {
            HitchableHorse horse = (HitchableHorse)((Object)mobMixin);
            HitchableHorse.setHitched(horse, false);
            if (!horse.horseman$asHorse().m_9236_().m_5776_()) {
                HitchableHorse.syncHorseDataToTrackingClients(horse);
            }
        }
    }

    @Inject(method={"checkAndHandleImportantInteractions"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCheckAndHandleImportantInteractions(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> cir) {
        HitchableHorse horse;
        MobMixin mobMixin = this;
        if (!(mobMixin instanceof HitchableHorse) || !(horse = (HitchableHorse)((Object)mobMixin)).horseman$asHorse().m_30614_() || horse.horseman$asHorse().m_6162_() || !HitchableHorse.isEnabled()) {
            return;
        }
        ItemStack itemInHand = player.m_21120_(hand);
        if (itemInHand.m_41720_() instanceof ShearsItem && !player.m_36341_() && HitchableHorse.hasLead(horse)) {
            if (HitchableHorse.isHitched(horse)) {
                horse.horseman$asHorse().m_21455_(true, false);
            }
            if (!this.m_9236_().f_46443_) {
                ItemStack leadStack = HitchableHorse.getLead(horse);
                this.m_19983_(leadStack);
            }
            this.m_9236_().m_6269_(player, (Entity)player, SoundEvents.f_12344_, SoundSource.PLAYERS, 0.8f, 1.0f);
            HitchableHorse.setLead(horse, ItemStack.f_41583_);
            if (!this.m_9236_().f_46443_) {
                HitchableHorse.syncHorseDataToTrackingClients(horse);
            }
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_));
            return;
        }
        if (itemInHand.m_41720_() instanceof LeadItem && player.m_36341_() && HitchableHorse.isHitchable(horse) && !HitchableHorse.hasLead(horse)) {
            ItemStack leadStack = itemInHand.m_41620_(1);
            HitchableHorse.setLead(horse, leadStack);
            player.m_6674_(hand);
            cir.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_));
            this.m_9236_().m_6269_(player, (Entity)player, SoundEvents.f_12087_, SoundSource.PLAYERS, 0.8f, 1.0f);
            return;
        }
    }
}

