/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.horseman.mixin.free_camera_when_mounted;

import io.github.mortuusars.horseman.Config;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={AbstractHorse.class})
public abstract class AbstractHorseMixin
extends Animal {
    protected AbstractHorseMixin(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"getRiddenRotation"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetRiddenRotation(LivingEntity entity, CallbackInfoReturnable<Vec2> cir) {
        Player player;
        AbstractHorse horse;
        block6: {
            block5: {
                horse = (AbstractHorse)this;
                if (!((Boolean)Config.Common.HORSE_FREE_CAMERA.get()).booleanValue() || !(entity instanceof Player)) break block5;
                player = (Player)entity;
                if (player.f_20900_ == 0.0f && player.f_20902_ == 0.0f) break block6;
            }
            return;
        }
        float threshold = ((Double)Config.Common.HORSE_FREE_CAMERA_ANGLE_THRESHOLD.get()).floatValue();
        float rotationDifference = (player.m_146908_() - horse.m_146908_() + 540.0f) % 360.0f - 180.0f;
        if (Math.abs(rotationDifference) > threshold) {
            cir.setReturnValue((Object)new Vec2(player.m_146909_() * 0.5f, player.m_146908_() - Math.signum(rotationDifference) * threshold));
        } else {
            cir.setReturnValue((Object)new Vec2(player.m_146909_() * 0.5f, horse.m_146908_()));
        }
    }
}

