/*
 * Decompiled with CFR 0.152.
 */
package it.hurts.sskirillss.relics.client.screen.description.data;

import com.mojang.blaze3d.systems.RenderSystem;
import it.hurts.sskirillss.relics.client.screen.description.data.base.ParticleData;
import it.hurts.sskirillss.relics.utils.RenderUtils;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;

public class ExperienceParticleData
extends ParticleData {
    private static final ResourceLocation TEXTURE = new ResourceLocation("relics", "textures/gui/description/general/pixel_particle.png");

    public ExperienceParticleData(Color color, float xStart, float yStart, float scale, int lifeTime) {
        super(TEXTURE, color, xStart, yStart, scale, lifeTime);
    }

    @Override
    public void tick(Screen screen) {
        LocalPlayer player = screen.getMinecraft().f_91074_;
        if (player == null) {
            return;
        }
        RandomSource random = player.m_217043_();
        float partialTicks = Minecraft.m_91087_().m_91296_();
        this.setX((float)((double)this.getX() + Math.sin(((float)this.getLifeTime() + partialTicks) * 0.15f) * (double)(0.1f + random.m_188501_() * 0.5f)));
        this.setY(this.getY() - (0.2f + partialTicks));
    }

    @Override
    public void render(Screen screen, GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float lifePercentage = 1.0f - (float)(this.getMaxLifeTime() - this.getLifeTime()) / 100.0f;
        float blinkOffset = 0.15f + (float)(Math.sin(((float)this.getLifeTime() + partialTick) * 0.5f) * (double)0.3f);
        RenderSystem.setShaderColor((float)((float)this.getColor().getRed() / 255.0f + blinkOffset), (float)((float)this.getColor().getGreen() / 255.0f + blinkOffset), (float)((float)this.getColor().getBlue() / 255.0f + blinkOffset), (float)lifePercentage);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.getTexture());
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)1);
        Minecraft.m_91087_().m_91097_().m_118506_(this.getTexture()).setBlurMipmap(true, false);
        RenderUtils.renderTextureFromCenter(guiGraphics.m_280168_(), this.getX(), this.getY(), 1.0f, 1.0f, this.getScale() * lifePercentage);
        Minecraft.m_91087_().m_91097_().m_118506_(this.getTexture()).restoreLastBlurMipmap();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableBlend();
    }
}

