/*
 * Decompiled with CFR 0.152.
 */
package sfiomn.legendarycreatures.entities;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import sfiomn.legendarycreatures.entities.AnimatedCreatureEntity;
import sfiomn.legendarycreatures.entities.goals.BaseMeleeAttackGoal;
import sfiomn.legendarycreatures.entities.goals.RangedMeleeAttackGoal;
import sfiomn.legendarycreatures.registry.SoundRegistry;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.animation.RawAnimation;
import software.bernie.geckolib.core.object.PlayState;

public class BullfrogEntity
extends AnimatedCreatureEntity
implements Enemy {
    private final int baseAttackDuration = 10;
    private final int baseAttackActionPoint = 5;
    private final int baseDistanceAttackDuration = 10;
    private final int baseDistanceAttackActionPoint = 5;
    public final int SHORT_RANGED_ATTACK = 7;
    public final int shortRangedAttackDistance = 6;
    public final int MIDDLE_RANGED_ATTACK = 8;
    public final int middleRangedAttackDistance = 8;
    public final int LONG_RANGED_ATTACK = 9;
    public final int longRangedAttackDistance = 10;
    public final RawAnimation ATTACK_ANIM = RawAnimation.begin().thenPlay("attack");
    public final RawAnimation TONGUE_ANIM = RawAnimation.begin().thenPlay("tongue");
    public final RawAnimation TONGUE2_ANIM = RawAnimation.begin().thenPlay("tongue2");
    public final RawAnimation TONGUE3_ANIM = RawAnimation.begin().thenPlay("tongue3");
    public final RawAnimation RUN_ANIM = RawAnimation.begin().thenPlay("run");

    public BullfrogEntity(EntityType<? extends PathfinderMob> type, Level level) {
        super(type, level);
        this.f_21364_ = 12;
        if (this.isLevel3()) {
            this.f_21364_ = 20;
        } else if (this.isLevel2()) {
            this.f_21364_ = 10;
        }
    }

    public static AttributeSupplier.Builder setCustomAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22284_, 0.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        if (!this.m_9236_().f_46443_) {
            int randomVariant = this.m_217043_().m_188503_(100);
            if (randomVariant >= 96) {
                this.setVariant(9);
            } else if (randomVariant >= 76) {
                this.setVariant(7);
            }
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor level, @NotNull DifficultyInstance difficulty, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag nbt) {
        AttributeInstance healthAttribute = this.m_21051_(Attributes.f_22276_);
        AttributeInstance attackAttribute = this.m_21051_(Attributes.f_22281_);
        if (this.isLevel2()) {
            if (attackAttribute != null) {
                attackAttribute.m_22125_(new AttributeModifier(ATTACK_DAMAGE_UUID, "legendarycreatures:bullfrog_level2", 5.0, AttributeModifier.Operation.ADDITION));
            }
            if (healthAttribute != null) {
                healthAttribute.m_22125_(new AttributeModifier(MAX_HEALTH_UUID, "legendarycreatures:bullfrog_level2", 15.0, AttributeModifier.Operation.ADDITION));
                this.m_21153_(1000.0f);
            }
        } else if (this.isLevel3()) {
            if (attackAttribute != null) {
                attackAttribute.m_22125_(new AttributeModifier(ATTACK_DAMAGE_UUID, "legendarycreatures:bullfrog_level3", 10.0, AttributeModifier.Operation.ADDITION));
            }
            if (healthAttribute != null) {
                healthAttribute.m_22125_(new AttributeModifier(MAX_HEALTH_UUID, "legendarycreatures:bullfrog_level3", 35.0, AttributeModifier.Operation.ADDITION));
                this.m_21153_(1000.0f);
            }
        }
        return super.m_6518_(level, difficulty, spawnType, spawnGroupData, nbt);
    }

    protected BodyRotationControl m_7560_() {
        return new BodyHelperController((Mob)this);
    }

    public Component m_7755_() {
        String descriptionId = "entity.legendarycreatures.bullfrog";
        if (this.isLevel2()) {
            descriptionId = "entity.legendarycreatures.bullfrog2";
        } else if (this.isLevel3()) {
            descriptionId = "entity.legendarycreatures.bullfrog3";
        }
        return Component.m_237115_((String)descriptionId);
    }

    protected void m_8099_() {
        super.m_8099_();
        final RangedMeleeAttackGoal rangedMeleeAttackGoal = new RangedMeleeAttackGoal(this, 10, 5, 100, 6.0, 11.0, 1.0, true){

            @Override
            protected void startAttack(LivingEntity target) {
                double distToTargetSqr = this.mob.m_20280_((Entity)target);
                if (distToTargetSqr < (double)(49.0f + target.m_20205_())) {
                    this.mob.setAttackAnimation(7);
                } else if (distToTargetSqr < (double)(81.0f + target.m_20205_())) {
                    this.mob.setAttackAnimation(8);
                } else {
                    this.mob.setAttackAnimation(9);
                }
                this.attackAnimationTick = this.attackDuration;
                this.mob.m_5496_((SoundEvent)SoundRegistry.BULLFROG_TONGUE_ATTACK.get(), 1.0f, 1.0f);
            }

            @Override
            protected boolean executeAttack(LivingEntity target) {
                boolean hit = super.executeAttack(target);
                if (hit) {
                    if (BullfrogEntity.this.isLevel3()) {
                        target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 200, 2, false, true));
                    }
                    Vec3 targetToMobVector = this.mob.m_20182_().m_82546_(target.m_20182_());
                    Vec3 vector3d = target.m_20096_() ? targetToMobVector.m_82490_(0.18) : targetToMobVector.m_82490_(0.13);
                    target.m_20334_(vector3d.f_82479_, 0.5, vector3d.f_82481_);
                    target.f_19812_ = true;
                    if (target instanceof ServerPlayer) {
                        ServerPlayer player = (ServerPlayer)target;
                        player.f_8906_.m_9829_((Packet)new ClientboundSetEntityMotionPacket((Entity)target));
                    }
                }
                return hit;
            }

            @Override
            public boolean isAttacking() {
                return this.mob.getAttackAnimation() == 7 || this.mob.getAttackAnimation() == 8 || this.mob.getAttackAnimation() == 9;
            }
        };
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21346_.m_25352_(4, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21345_.m_25352_(7, (Goal)rangedMeleeAttackGoal);
        this.f_21345_.m_25352_(8, (Goal)new BaseMeleeAttackGoal(this, 10, 5, 5, 1.0, true){

            @Override
            protected double getAttackReachSqr(LivingEntity entity) {
                return BullfrogEntity.this.getMobLength() * 2.0f * BullfrogEntity.this.getMobLength() * 2.0f + entity.m_20205_();
            }

            @Override
            protected boolean executeAttack(LivingEntity target) {
                this.mob.m_5496_((SoundEvent)SoundRegistry.BULLFROG_ATTACK.get(), 1.0f, 1.0f);
                boolean hit = super.executeAttack(target);
                if (hit && (BullfrogEntity.this.isLevel2() || BullfrogEntity.this.isLevel3())) {
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19614_, 150, 1, false, true));
                }
                return hit;
            }

            @Override
            public boolean m_8045_() {
                boolean canContinueToUse = super.m_8045_();
                if (canContinueToUse) {
                    return !rangedMeleeAttackGoal.m_8036_();
                }
                return false;
            }
        });
        this.f_21346_.m_25352_(9, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21345_.m_25352_(7, (Goal)new RandomStrollGoal((PathfinderMob)this, 0.9, 40));
    }

    private float getMobLength() {
        return 1.4f;
    }

    @Override
    public <E extends GeoAnimatable> PlayState attackingPredicate(AnimationState<E> state) {
        if (this.hasSpawnEffect() && this.f_19797_ < this.getSpawnAnimationTicks()) {
            return PlayState.CONTINUE;
        }
        if (this.getAttackAnimation() == 1) {
            return state.setAndContinue(this.ATTACK_ANIM);
        }
        if (this.getAttackAnimation() == 7) {
            return state.setAndContinue(this.TONGUE_ANIM);
        }
        if (this.getAttackAnimation() == 8) {
            return state.setAndContinue(this.TONGUE2_ANIM);
        }
        if (this.getAttackAnimation() == 9) {
            return state.setAndContinue(this.TONGUE3_ANIM);
        }
        state.getController().forceAnimationReset();
        return PlayState.STOP;
    }

    public boolean isLevel3() {
        return this.getVariant() >= 9;
    }

    public boolean isLevel2() {
        return this.getVariant() >= 7 && this.getVariant() < 9;
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundRegistry.BULLFROG_DEATH.get();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundRegistry.BULLFROG_IDLE.get();
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)SoundRegistry.BULLFROG_STEP.get(), 1.0f, 1.0f);
    }

    @Override
    public RawAnimation getSprintAnimation() {
        return this.RUN_ANIM;
    }

    class BodyHelperController
    extends BodyRotationControl {
        public BodyHelperController(Mob p_i49925_2_) {
            super(p_i49925_2_);
        }

        public void m_8121_() {
            BullfrogEntity.this.f_20885_ = BullfrogEntity.this.f_20883_;
            BullfrogEntity.this.f_20883_ = BullfrogEntity.this.m_146908_();
        }
    }
}

