/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.amendments.common.block;

import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.amendments.common.block.CommonCauldronCode;
import net.mehvahdjukaar.amendments.common.block.ModCauldronBlock;
import net.mehvahdjukaar.amendments.common.tile.LiquidCauldronBlockTile;
import net.mehvahdjukaar.amendments.configs.CommonConfigs;
import net.mehvahdjukaar.amendments.integration.AlexCavesCompat;
import net.mehvahdjukaar.amendments.integration.CompatHandler;
import net.mehvahdjukaar.amendments.reg.ModBlockProperties;
import net.mehvahdjukaar.amendments.reg.ModTags;
import net.mehvahdjukaar.moonlight.api.fluids.BuiltInSoftFluids;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidStack;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LiquidCauldronBlock
extends ModCauldronBlock {
    public static final IntegerProperty LEVEL = PlatHelper.getPlatform().isFabric() ? BlockStateProperties.f_61418_ : ModBlockProperties.LEVEL_1_4;
    public static final IntegerProperty LIGHT_LEVEL = ModBlockProperties.LIGHT_LEVEL;

    public LiquidCauldronBlock(BlockBehaviour.Properties properties) {
        super(properties.m_60953_(value -> (Integer)value.m_61143_((Property)LIGHT_LEVEL)));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(1))).m_61124_((Property)LIGHT_LEVEL, (Comparable)Integer.valueOf(0))).m_61124_((Property)BOILING, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public IntegerProperty getLevelProperty() {
        return LEVEL;
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LEVEL, LIGHT_LEVEL});
    }

    protected boolean m_142087_(Fluid fluid) {
        return true;
    }

    public void m_142310_(BlockState state, Level level, BlockPos pos, Fluid fluid) {
        BlockEntity blockEntity;
        if (!this.m_142596_(state) && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
            SoftFluidStack sf;
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            int amount = SoftFluid.BOTTLE_COUNT;
            if (!CommonConfigs.LAVA_LAYERS.get().booleanValue() && fluid == Fluids.f_76195_) {
                amount = SoftFluid.BUCKET_COUNT;
            }
            if (!(sf = SoftFluidStack.fromFluid((Fluid)fluid, (int)amount, null)).isEmpty() && te.getSoftFluidTank().addFluid(sf, false) != 0) {
                te.m_6596_();
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
                if (fluid == Fluids.f_76195_) {
                    level.m_46796_(1046, pos, 0);
                } else {
                    level.m_46796_(1047, pos, 0);
                }
            }
        }
    }

    @Override
    public void m_141997_(BlockState state, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        BlockEntity blockEntity;
        super.m_141997_(state, level, pos, precipitation);
        if (!this.m_142596_(state) && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidTank softFluidTank = te.getSoftFluidTank();
            SoftFluidStack sf = softFluidTank.getFluid();
            if (precipitation == Biome.Precipitation.RAIN && sf.is((Holder)BuiltInSoftFluids.WATER) && softFluidTank.addFluid(SoftFluidStack.fromFluid((Fluid)Fluids.f_76193_, (int)1, null), false) > 0) {
                level.m_220407_(GameEvent.f_157792_, pos, GameEvent.Context.m_223722_((BlockState)state));
                te.m_6596_();
            }
        }
    }

    @Override
    protected void handleEntityInsideFluidSpecial(BlockState state, Level level, BlockPos pos, Entity entity) {
        BlockEntity blockEntity;
        if (entity.m_142265_(level, pos) && (blockEntity = level.m_7702_(pos)) instanceof LiquidCauldronBlockTile) {
            ItemEntity ie;
            LiquidCauldronBlockTile tile = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidStack fluid = tile.getSoftFluidTank().getFluid();
            PotionNBTHelper.Type potType = this.getPotType(fluid);
            if (entity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)entity;
                if (potType != null && potType != PotionNBTHelper.Type.REGULAR && this.applyPotionFluidEffects(level, pos, living, fluid)) {
                    tile.consumeOneLayer();
                    level.m_142346_(entity, GameEvent.f_157792_, pos);
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidDamage(fluid, level, pos, state, entity);
                }
            }
            if (!tile.isGlowing() && fluid.is(ModTags.CAN_GLOW) && entity instanceof ItemEntity && (ie = (ItemEntity)entity).m_32055_().m_150930_(Items.f_151056_) && this.m_151979_(state, pos, entity)) {
                CommonCauldronCode.playSplashEffects(entity, this.m_142446_(state));
                tile.setGlowing(true);
                level.m_142346_(entity, GameEvent.f_157792_, pos);
                ie.m_32055_().m_41774_(1);
                if (ie.m_32055_().m_41619_()) {
                    ie.m_146870_();
                }
            }
        }
    }

    private boolean applyPotionFluidEffects(Level level, BlockPos pos, LivingEntity living, SoftFluidStack stack) {
        List effects = PotionUtils.m_43566_((CompoundTag)stack.getTag());
        boolean success = false;
        for (MobEffectInstance effect : effects) {
            MobEffect ef = effect.m_19544_();
            if (living.m_21023_(ef)) continue;
            if (ef.m_8093_()) {
                ef.m_19461_(null, null, living, effect.m_19564_(), 1.0);
            } else {
                living.m_7292_(new MobEffectInstance(effect));
            }
            success = true;
        }
        if (success) {
            level.m_5594_(null, pos, SoundEvents.f_11917_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        return success;
    }

    @Override
    public void m_214162_(BlockState state, Level level, BlockPos pos, RandomSource rand) {
        super.m_214162_(state, level, pos, rand);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof LiquidCauldronBlockTile) {
            LiquidCauldronBlockTile te = (LiquidCauldronBlockTile)blockEntity;
            SoftFluidTank tank = te.getSoftFluidTank();
            if (level.f_46441_.m_188503_(4) == 0) {
                SoftFluidStack fluid = tank.getFluid();
                PotionNBTHelper.Type type = this.getPotType(fluid);
                double height = this.m_142446_(state);
                if (type != null) {
                    if (PotionUtils.m_43566_((CompoundTag)fluid.getTag()).size() >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
                        CommonCauldronCode.addSurfaceParticles((ParticleOptions)ParticleTypes.f_123762_, level, pos, 2, height, rand, 0.0f, 0.0f, 0.0f);
                    }
                    if (type != PotionNBTHelper.Type.REGULAR) {
                        SimpleParticleType particle = type == PotionNBTHelper.Type.SPLASH ? ParticleTypes.f_123770_ : ParticleTypes.f_123811_;
                        int color = tank.getCachedParticleColor((BlockAndTintGetter)level, pos);
                        this.addPotionParticles((ParticleOptions)particle, level, pos, 1, height, rand, color);
                    }
                }
                if (CompatHandler.ALEX_CAVES) {
                    AlexCavesCompat.acidParticles(fluid, level, pos, rand, height);
                }
                BlockPos blockPos = pos.m_7494_();
                if (fluid.is((Holder)BuiltInSoftFluids.LAVA) && level.m_8055_(blockPos).m_60795_() && !level.m_8055_(blockPos).m_60804_((BlockGetter)level, blockPos)) {
                    Vec3 c = pos.m_252807_();
                    if (rand.m_188503_(20) == 0) {
                        CommonCauldronCode.addSurfaceParticles((ParticleOptions)ParticleTypes.f_123756_, level, pos, 1, height, rand, 0.0f, 0.0f, 0.0f);
                        level.m_7785_(c.f_82479_, height, c.f_82481_, SoundEvents.f_12032_, SoundSource.BLOCKS, 0.2f + rand.m_188501_() * 0.2f, 0.9f + rand.m_188501_() * 0.15f, false);
                    }
                    if (rand.m_188503_(40) == 0) {
                        level.m_7785_(c.f_82479_, height, c.f_82481_, SoundEvents.f_12030_, SoundSource.BLOCKS, 0.2f + rand.m_188501_() * 0.2f, 0.9f + rand.m_188501_() * 0.15f, false);
                    }
                }
            }
        }
    }

    @Nullable
    private PotionNBTHelper.Type getPotType(SoftFluidStack stack) {
        if (stack.is((Holder)BuiltInSoftFluids.POTION) && stack.hasTag()) {
            return PotionNBTHelper.getPotionType((CompoundTag)stack.getTag());
        }
        return null;
    }

    private void addPotionParticles(ParticleOptions type, Level level, BlockPos pos, int count, double surface, RandomSource rand, int color) {
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        CommonCauldronCode.addSurfaceParticles(type, level, pos, count, surface, rand, r, g, b);
    }

    @Override
    public BlockState updateStateOnFluidChange(BlockState state, Level level, BlockPos pos, SoftFluidStack fluid) {
        BlockState exploded = this.maybeExplode(state, level, pos, fluid);
        if (exploded != null) {
            return exploded;
        }
        int light = fluid.fluid().getLuminosity();
        if (light != (Integer)state.m_61143_((Property)ModBlockProperties.LIGHT_LEVEL)) {
            state = (BlockState)state.m_61124_((Property)ModBlockProperties.LIGHT_LEVEL, (Comparable)Integer.valueOf(light));
        }
        return super.updateStateOnFluidChange(state, level, pos, fluid);
    }

    @Nullable
    private BlockState maybeExplode(BlockState state, Level level, BlockPos pos, SoftFluidStack fluid) {
        List potionEffects = PotionUtils.m_43566_((CompoundTag)fluid.getTag());
        int potionEffectAmount = potionEffects.size();
        if (potionEffectAmount >= CommonConfigs.POTION_MIXING_LIMIT.get()) {
            if (potionEffectAmount > CommonConfigs.POTION_MIXING_LIMIT.get()) {
                level.m_46961_(pos, true);
                Vec3 vec3 = pos.m_252807_();
                level.m_254877_(null, level.m_269111_().m_269488_(vec3), null, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_, 1.4f, false, Level.ExplosionInteraction.NONE);
                return state;
            }
            if (level.f_46443_) {
                CommonCauldronCode.addSurfaceParticles((ParticleOptions)ParticleTypes.f_123762_, level, pos, 12, this.m_142446_(state), level.f_46441_, 0.0f, 0.0f, 0.0f);
            }
            level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return null;
        }
        Map<MobEffect, MobEffect> inverse = CommonConfigs.INVERSE_POTIONS.get();
        List<MobEffect> effects = potionEffects.stream().map(MobEffectInstance::m_19544_).toList();
        for (MobEffect effect : effects) {
            MobEffect inv = inverse.get(effect);
            if (inv == null || !effects.contains(inv)) continue;
            if (level.f_46443_) {
                CommonCauldronCode.addSurfaceParticles((ParticleOptions)ParticleTypes.f_123759_, level, pos, 8, this.m_142446_(state), level.f_46441_, 0.0f, 0.01f + level.f_46441_.m_188501_() * 0.1f, 0.0f);
            }
            level.m_5594_(null, pos, SoundEvents.f_11914_, SoundSource.BLOCKS, 1.0f, 1.0f);
            return Blocks.f_50256_.m_49966_();
        }
        return null;
    }
}

