/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.jeed.plugin.emi.ingredient;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.serializer.EmiIngredientSerializer;
import dev.emi.emi.runtime.EmiLog;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.mehvahdjukaar.jeed.plugin.emi.ingredient.EffectInstanceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;

public class EffectIngredientSerializer
implements EmiIngredientSerializer<EffectInstanceStack> {
    public static final MapCodec<MobEffectInstance> MAP_CODEC = new RecursiveMapCodec<MobEffectInstance>("MobEffectInstance.Details", codec -> RecordCodecBuilder.mapCodec(instance -> instance.group((App)BuiltInRegistries.f_256974_.m_194605_().fieldOf("id").forGetter(MobEffectInstance::m_19544_), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(MobEffectInstance::m_19557_), (App)Codec.INT.optionalFieldOf("amplifier", (Object)0).forGetter(MobEffectInstance::m_19564_), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(MobEffectInstance::m_19571_), (App)Codec.BOOL.optionalFieldOf("visible", (Object)true).forGetter(MobEffectInstance::m_19572_), (App)Codec.BOOL.optionalFieldOf("show_icon", (Object)true).forGetter(MobEffectInstance::m_19575_), (App)codec.optionalFieldOf("hidden_effect").forGetter(e -> Optional.ofNullable(e.f_19510_)), (App)MobEffectInstance.FactorData.f_216907_.optionalFieldOf("factor_data").forGetter(MobEffectInstance::m_216895_)).apply((Applicative)instance, EffectIngredientSerializer::create)));
    public static final Codec<MobEffectInstance> CODEC = MAP_CODEC.codec();

    public String getType() {
        return "mob_effect";
    }

    public EmiIngredient deserialize(JsonElement element) {
        try {
            return (EmiIngredient)CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)element).result().map(a -> new EffectInstanceStack((MobEffectInstance)a.getFirst())).orElseThrow(DecoderException::new);
        }
        catch (DecoderException e) {
            EmiLog.error((String)"Error parsing mob effect");
            EmiLog.error((Throwable)e);
            return EmiStack.EMPTY;
        }
    }

    public JsonElement serialize(EffectInstanceStack stack) {
        try {
            return (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stack.getEffect()).result().orElseThrow(EncoderException::new);
        }
        catch (EncoderException e) {
            EmiLog.error((String)"Error encoding mob effect");
            EmiLog.error((Throwable)e);
            return new JsonObject();
        }
    }

    private static MobEffectInstance create(MobEffect mobEffect, Integer integer, Integer integer1, Boolean aBoolean, Boolean aBoolean1, Boolean aBoolean2, Optional<MobEffectInstance> mobEffectInstance, Optional<MobEffectInstance.FactorData> factorData) {
        return new MobEffectInstance(mobEffect, integer.intValue(), integer1.intValue(), aBoolean.booleanValue(), aBoolean1.booleanValue(), aBoolean2.booleanValue(), (MobEffectInstance)mobEffectInstance.orElse(null), factorData);
    }

    private static class RecursiveMapCodec<A>
    extends MapCodec<A> {
        private final String name;
        private final Supplier<MapCodec<A>> wrapped;

        private RecursiveMapCodec(String name, Function<Codec<A>, MapCodec<A>> wrapped) {
            this.name = name;
            this.wrapped = Suppliers.memoize(() -> (MapCodec)wrapped.apply(this.codec()));
        }

        public <T> RecordBuilder<T> encode(A input, DynamicOps<T> ops, RecordBuilder<T> prefix) {
            return this.wrapped.get().encode(input, ops, prefix);
        }

        public <T> DataResult<A> decode(DynamicOps<T> ops, MapLike<T> input) {
            return this.wrapped.get().decode(ops, input);
        }

        public <T> Stream<T> keys(DynamicOps<T> ops) {
            return this.wrapped.get().keys(ops);
        }

        public String toString() {
            return "RecursiveMapCodec[" + this.name + "]";
        }
    }
}

