/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.farm_and_charm.block.crops;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.satisfy.farm_and_charm.block.crops.TomatoCropBlock;
import org.jetbrains.annotations.NotNull;

public class TomatoCropHeadBlock
extends TomatoCropBlock
implements BonemealableBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);

    public TomatoCropHeadBlock(BlockBehaviour.Properties properties) {
        super(properties, SHAPE);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
    }

    public static boolean canGrowInto(ServerLevel serverLevel, BlockPos blockPos) {
        return serverLevel.m_8055_(blockPos).m_60795_() && (TomatoCropHeadBlock.isRopeAbove((LevelAccessor)serverLevel, blockPos) || TomatoCropHeadBlock.getHeight(blockPos.m_7495_(), (LevelAccessor)serverLevel) < 2);
    }

    @Override
    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        super.m_213897_(blockState, serverLevel, blockPos, randomSource);
        if (TomatoCropHeadBlock.getHeight(blockPos, (LevelAccessor)serverLevel) > 2 && !TomatoCropHeadBlock.isRopeAbove((LevelAccessor)serverLevel, blockPos)) {
            serverLevel.m_46961_(blockPos, true);
        }
    }

    @Override
    public boolean m_6724_(BlockState blockState) {
        return true;
    }

    @Override
    public void m_213898_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        super.m_213898_(blockState, serverLevel, blockPos, randomSource);
        if (serverLevel.m_45524_(blockPos, 0) >= 9 && randomSource.m_188501_() < 0.2f && TomatoCropHeadBlock.canGrowInto(serverLevel, blockPos.m_7494_())) {
            serverLevel.m_46597_(blockPos.m_7494_(), this.m_49966_());
        }
    }

    public boolean m_7370_(LevelReader levelReader, BlockPos blockPos, BlockState blockState, boolean bl) {
        return true;
    }

    public boolean m_214167_(Level level, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    @NotNull
    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (direction == Direction.DOWN && !blockState.m_60710_((LevelReader)levelAccessor, blockPos) || TomatoCropHeadBlock.getHeight(blockPos, levelAccessor) > 2 && !TomatoCropHeadBlock.isRopeAbove(levelAccessor, blockPos)) {
            levelAccessor.m_186460_(blockPos, (Block)this, 1);
        }
        if (direction != Direction.UP || !blockState2.m_60713_((Block)this) && !blockState2.m_60713_((Block)TomatoCropHeadBlock.getBodyBlock())) {
            return blockState;
        }
        return TomatoCropHeadBlock.getBodyBlock().getStateForAge((Integer)blockState.m_61143_((Property)AGE));
    }

    public void m_214148_(ServerLevel serverLevel, RandomSource randomSource, BlockPos blockPos, BlockState blockState) {
        if (randomSource.m_188499_() && TomatoCropHeadBlock.canGrowInto(serverLevel, blockPos.m_7494_())) {
            serverLevel.m_46597_(blockPos.m_7494_(), this.m_49966_());
            return;
        }
        if (this.canGrow(blockState)) {
            serverLevel.m_46597_(blockPos, this.getStateForAge((Integer)blockState.m_61143_((Property)AGE) + 1));
        } else {
            this.dropTomatoes((Level)serverLevel, blockPos, blockState);
        }
    }
}

