/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.forge;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.commands.StructurifyCommand;
import com.faboslav.structurify.common.events.common.LoadConfigEvent;
import com.faboslav.structurify.common.events.common.UpdateRegistriesEvent;
import com.faboslav.structurify.common.registry.StructurifyRegistryManagerProvider;
import com.faboslav.structurify.forge.StructurifyForgeClient;
import com.mojang.brigadier.CommandDispatcher;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TagsUpdatedEvent;
import net.minecraftforge.event.server.ServerAboutToStartEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;

@Mod(value="structurify")
public final class StructurifyForge {
    public StructurifyForge() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus eventBus = MinecraftForge.EVENT_BUS;
        Structurify.init();
        if (FMLEnvironment.dist == Dist.CLIENT) {
            StructurifyForgeClient.init(modEventBus, eventBus);
        }
        eventBus.addListener(StructurifyForge::registerCommand);
        eventBus.addListener(StructurifyForge::onResourceManagerReload);
        eventBus.addListener(StructurifyForge::onServerAboutToStart);
    }

    private static void registerCommand(RegisterCommandsEvent event) {
        StructurifyCommand.createCommand((CommandDispatcher<CommandSourceStack>)event.getDispatcher(), event.getBuildContext());
    }

    private static void onResourceManagerReload(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.CLIENT_PACKET_RECEIVED) {
            return;
        }
        StructurifyRegistryManagerProvider.setRegistryManager((HolderLookup.Provider)event.getRegistryAccess());
        LoadConfigEvent.EVENT.invoke(new LoadConfigEvent());
    }

    private static void onServerAboutToStart(ServerAboutToStartEvent event) {
        StructurifyRegistryManagerProvider.setRegistryManager((HolderLookup.Provider)event.getServer().m_206579_());
        UpdateRegistriesEvent.EVENT.invoke(new UpdateRegistriesEvent((HolderLookup.Provider)event.getServer().m_206579_()));
    }
}

