/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.structurify.common.registry;

import com.faboslav.structurify.common.Structurify;
import com.faboslav.structurify.common.modcompat.ModChecker;
import com.faboslav.structurify.common.modcompat.ModCompat;
import com.faboslav.structurify.common.platform.PlatformHooks;
import java.util.ArrayList;
import net.minecraft.server.packs.repository.RepositorySource;
import net.minecraft.server.packs.repository.ServerPacksSource;

public final class StructurifyResourcePackProvider {
    public static ArrayList<RepositorySource> getResourcePackProviders() {
        ArrayList<RepositorySource> resourcePackProviders = new ArrayList<RepositorySource>();
        resourcePackProviders.addAll(StructurifyResourcePackProvider.getVanillaResourcePackProviders());
        resourcePackProviders.addAll(PlatformHooks.PLATFORM_RESOURCE_PACK_PROVIDER.getPlatformResourcePackProviders());
        resourcePackProviders.addAll(StructurifyResourcePackProvider.getModsResourcePackProviders());
        return resourcePackProviders;
    }

    public static ArrayList<RepositorySource> getVanillaResourcePackProviders() {
        ArrayList<RepositorySource> vanillaResourcePackProviders = new ArrayList<RepositorySource>();
        vanillaResourcePackProviders.add((RepositorySource)new ServerPacksSource());
        return vanillaResourcePackProviders;
    }

    public static ArrayList<RepositorySource> getModsResourcePackProviders() {
        ArrayList<RepositorySource> modResourcePackProviders = new ArrayList<RepositorySource>();
        for (ModCompat compat : ModChecker.CUSTOM_RESOURCE_PACK_PROVIDER_COMPATS) {
            try {
                ArrayList<RepositorySource> resourcePackProviders = compat.getResourcePackProviders();
                modResourcePackProviders.addAll(resourcePackProviders);
            }
            catch (Throwable e) {
                Structurify.getLogger().error("Failed to get resource pack providers from mod compat");
                e.printStackTrace();
            }
        }
        return modResourcePackProviders;
    }
}

