/*
 * Decompiled with CFR 0.152.
 */
package net.satisfy.herbalbrews.core.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.satisfy.herbalbrews.core.blocks.entity.TeaKettleBlockEntity;
import net.satisfy.herbalbrews.core.registry.RecipeTypeRegistry;
import net.satisfy.herbalbrews.core.util.HerbalBrewsUtil;
import org.jetbrains.annotations.NotNull;

public class TeaKettleRecipe
implements Recipe<Container> {
    final ResourceLocation id;
    private final NonNullList<Ingredient> inputs;
    private final ItemStack output;
    private final MobEffect effect;
    private final int effectDuration;
    private final int requiredWater;
    private final int requiredHeat;
    private final int requiredDuration;

    public TeaKettleRecipe(ResourceLocation id, NonNullList<Ingredient> inputs, ItemStack output, MobEffect effect, int effectDuration, int requiredWater, int requiredHeat, int requiredDuration) {
        this.id = id;
        this.inputs = inputs;
        this.output = output;
        this.effect = effect;
        this.effectDuration = effectDuration;
        this.requiredWater = requiredWater;
        this.requiredHeat = requiredHeat;
        this.requiredDuration = requiredDuration;
    }

    public boolean m_5818_(Container inventory, Level world) {
        return HerbalBrewsUtil.matchesRecipe(inventory, this.inputs, 0, 5) && this.waterLevelSufficient(inventory) && this.heatLevelSufficient(inventory);
    }

    private boolean waterLevelSufficient(Container inventory) {
        if (inventory instanceof TeaKettleBlockEntity) {
            TeaKettleBlockEntity teaKettle = (TeaKettleBlockEntity)inventory;
            return teaKettle.getWaterLevel() >= this.requiredWater;
        }
        return false;
    }

    private boolean heatLevelSufficient(Container inventory) {
        if (inventory instanceof TeaKettleBlockEntity) {
            TeaKettleBlockEntity teaKettle = (TeaKettleBlockEntity)inventory;
            return teaKettle.getHeatLevel() >= this.requiredHeat;
        }
        return false;
    }

    public ItemStack assemble() {
        return this.m_5874_(null, null);
    }

    @NotNull
    public ItemStack m_5874_(Container inventory, RegistryAccess registryManager) {
        return this.output.m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack getResultItem() {
        return this.m_8043_(null);
    }

    @NotNull
    public ItemStack m_8043_(RegistryAccess registryManager) {
        return this.output;
    }

    public MobEffect getEffect() {
        return this.effect;
    }

    public int getEffectDuration() {
        return this.effectDuration;
    }

    public int getRequiredWater() {
        return this.requiredWater;
    }

    public int getRequiredHeat() {
        return this.requiredHeat;
    }

    public int getRequiredDuration() {
        return this.requiredDuration;
    }

    @NotNull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @NotNull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)RecipeTypeRegistry.TEA_KETTLE_RECIPE_SERIALIZER.get();
    }

    @NotNull
    public RecipeType<?> m_6671_() {
        return (RecipeType)RecipeTypeRegistry.TEA_KETTLE_RECIPE_TYPE.get();
    }

    @NotNull
    public NonNullList<Ingredient> m_7527_() {
        return this.inputs;
    }

    public boolean m_5598_() {
        return true;
    }

    public static class Type
    implements RecipeType<TeaKettleRecipe> {
        private Type() {
        }
    }

    public static class Serializer
    implements RecipeSerializer<TeaKettleRecipe> {
        @NotNull
        public TeaKettleRecipe fromJson(ResourceLocation id, JsonObject json) {
            JsonArray heatArray;
            JsonArray fluidArray;
            ResourceLocation effectId;
            NonNullList<Ingredient> ingredients = HerbalBrewsUtil.deserializeIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (ingredients.isEmpty()) {
                throw new JsonParseException("No ingredients for Tea Kettle Recipe");
            }
            if (ingredients.size() > 6) {
                throw new JsonParseException("Too many ingredients for Tea Kettle Recipe");
            }
            JsonObject result = GsonHelper.m_13930_((JsonObject)json, (String)"result");
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)result);
            MobEffect effect = null;
            int effectDuration = 0;
            if (result.has("effect") && (effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)result, (String)"effect")))) == null) {
                throw new JsonParseException("Invalid effect ID: " + effectId);
            }
            if (result.has("effectduration")) {
                effectDuration = GsonHelper.m_13927_((JsonObject)result, (String)"effectduration");
            }
            int requiredWater = 0;
            if (json.has("fluid") && !(fluidArray = GsonHelper.m_13933_((JsonObject)json, (String)"fluid")).isEmpty()) {
                requiredWater = GsonHelper.m_13927_((JsonObject)fluidArray.get(0).getAsJsonObject(), (String)"amount");
            }
            int requiredHeat = 0;
            if (json.has("heat_needed") && !(heatArray = GsonHelper.m_13933_((JsonObject)json, (String)"heat_needed")).isEmpty()) {
                requiredHeat = GsonHelper.m_13927_((JsonObject)heatArray.get(0).getAsJsonObject(), (String)"amount");
            }
            int requiredDuration = 0;
            if (json.has("crafting_duration")) {
                requiredDuration = GsonHelper.m_13927_((JsonObject)json, (String)"crafting_duration") * 20;
            }
            return new TeaKettleRecipe(id, ingredients, output, effect, effectDuration, requiredWater, requiredHeat, requiredDuration);
        }

        @NotNull
        public TeaKettleRecipe fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            NonNullList ingredients = NonNullList.m_122780_((int)buf.m_130242_(), (Object)Ingredient.f_43901_);
            ingredients.replaceAll(ignored -> Ingredient.m_43940_((FriendlyByteBuf)buf));
            ItemStack output = buf.m_130267_();
            MobEffect effect = null;
            int effectDuration = 0;
            boolean hasEffect = buf.readBoolean();
            if (hasEffect) {
                ResourceLocation effectId = buf.m_130281_();
                effect = (MobEffect)BuiltInRegistries.f_256974_.m_7745_(effectId);
                effectDuration = buf.readInt();
            }
            int requiredWater = buf.readInt();
            int requiredHeat = buf.readInt();
            int requiredDuration = buf.readInt();
            return new TeaKettleRecipe(id, (NonNullList<Ingredient>)ingredients, output, effect, effectDuration, requiredWater, requiredHeat, requiredDuration);
        }

        public void toNetwork(FriendlyByteBuf buf, TeaKettleRecipe recipe) {
            buf.m_130130_(recipe.inputs.size());
            recipe.inputs.forEach(entry -> entry.m_43923_(buf));
            buf.m_130055_(recipe.output);
            if (recipe.effect != null) {
                buf.writeBoolean(true);
                buf.m_130085_(recipe.effect.m_19481_().contains(":") ? new ResourceLocation(recipe.effect.m_19481_().split(":")[1]) : new ResourceLocation("minecraft", "unknown"));
                buf.writeInt(recipe.effectDuration);
            } else {
                buf.writeBoolean(false);
            }
            buf.writeInt(recipe.requiredWater);
            buf.writeInt(recipe.requiredHeat);
            buf.writeInt(recipe.requiredDuration);
        }
    }
}

