/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import tictim.paraglider.ParagliderUtils;
import tictim.paraglider.api.item.Paraglider;
import tictim.paraglider.client.ParagliderClientSettings;
import tictim.paraglider.network.ParagliderNetwork;
import tictim.paraglider.wind.Wind;
import tictim.paraglider.wind.WindChunk;
import tictim.paraglider.wind.WindNode;

public final class WindUtils {
    @OnlyIn(value=Dist.CLIENT)
    private static List<WindNode> nodes;
    @OnlyIn(value=Dist.CLIENT)
    private static double windParticleState;

    private WindUtils() {
    }

    public static void updateWind(@NotNull Level level) {
        Wind wind = Wind.of((LevelAccessor)level);
        if (wind == null) {
            return;
        }
        long gameTime = level.m_46467_();
        if (gameTime % 4L == 0L) {
            List players = level.m_6907_();
            for (Player player : players) {
                if (!(player.m_21205_().m_41720_() instanceof Paraglider)) continue;
                wind.placeAround(player);
            }
        }
        wind.checkPlacedWind(level);
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            LongIterator it = wind.dirtyWindChunks().iterator();
            while (it.hasNext()) {
                long chunkPos = it.nextLong();
                WindChunk windChunk = wind.getChunk(chunkPos);
                if (windChunk == null) continue;
                LevelChunk chunk = level.m_6325_(ChunkPos.m_45592_((long)chunkPos), ChunkPos.m_45602_((long)chunkPos));
                ParagliderNetwork.get().syncWind(serverLevel.m_7654_(), chunk, windChunk);
            }
        }
        wind.dirtyWindChunks().clear();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void placeWindParticles(@NotNull Level level, @NotNull Wind wind) {
        if (Minecraft.m_91087_().m_91104_()) {
            return;
        }
        double s2 = (windParticleState += ParagliderClientSettings.get().windParticleFrequency()) - 1.0;
        if (!(s2 >= 0.0)) {
            return;
        }
        windParticleState = s2;
        if (nodes == null) {
            nodes = new ArrayList<WindNode>();
        }
        for (WindChunk windChunk : wind.windChunks()) {
            for (WindNode node : windChunk.getAllRootNodes()) {
                do {
                    nodes.add(node);
                } while ((node = node.next) != null);
            }
        }
        int bound = 5 + nodes.size();
        for (WindNode node : nodes) {
            if (ParagliderUtils.PARTICLE_RNG.nextInt(bound) != 0) continue;
            level.m_7107_((ParticleOptions)ParticleTypes.f_123815_, (double)node.x + ParagliderUtils.PARTICLE_RNG.nextDouble(), (double)node.y + 0.5, (double)node.z + ParagliderUtils.PARTICLE_RNG.nextDouble(), 0.0, 1.0, 0.0);
        }
        nodes.clear();
    }
}

