/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.wind;

import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import tictim.paraglider.wind.WindNode;

public final class WindChunk {
    public final ChunkPos chunkPos;
    private final Byte2ObjectMap<WindNode> nodes = new Byte2ObjectOpenHashMap();
    private boolean removed;

    public WindChunk(@NotNull ChunkPos chunkPos) {
        this.chunkPos = Objects.requireNonNull(chunkPos);
    }

    public WindChunk(@NotNull FriendlyByteBuf buf) {
        this.chunkPos = new ChunkPos(buf.readLong());
        for (int i = buf.m_130242_(); i > 0; --i) {
            this.putNode(new WindNode(buf));
        }
    }

    @Nullable
    public WindNode getNode(int x, int z) {
        return (WindNode)this.nodes.get(this.encode(x, z));
    }

    public void putNode(@NotNull WindNode node) {
        this.nodes.put(this.encode(node.x, node.z), (Object)node);
    }

    public void removeAllNodesInXZ(int x, int z) {
        this.nodes.remove(this.encode(x, z));
    }

    @NotNull
    public @NotNull @Unmodifiable Collection<@NotNull WindNode> getAllRootNodes() {
        return Collections.unmodifiableCollection(this.nodes.values());
    }

    public boolean isEmpty() {
        return this.nodes.isEmpty();
    }

    public boolean isRemoved() {
        return this.removed;
    }

    void setRemoved() {
        this.removed = true;
    }

    private byte encode(int x, int z) {
        return (byte)(x << 4 & 0xF0 | z & 0xF);
    }

    public boolean isInsideWind(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        int xMin = this.chunkPos.m_45604_();
        int xMax = this.chunkPos.m_45608_();
        int zMin = this.chunkPos.m_45605_();
        int zMax = this.chunkPos.m_45609_();
        if (xMin > maxX || xMax < minX || zMin > maxZ || zMax < minZ) {
            return false;
        }
        int xs = Math.max(xMin, minX);
        int xe = Math.min(xMax, maxX);
        int zs = Math.max(zMin, minZ);
        int ze = Math.min(zMax, maxZ);
        for (int x = xs; x <= xe; ++x) {
            for (int z = zs; z <= ze; ++z) {
                WindNode node = this.getNode(x, z);
                while (node != null) {
                    if (node.y < maxY && node.y + node.height > minY) {
                        return true;
                    }
                    node = node.next;
                }
            }
        }
        return false;
    }

    public boolean add(int x, int y, int z, int height, long gameTime) {
        WindNode node = this.getNode(x, z);
        if (node != null) {
            return node.overwrite(y, height, gameTime);
        }
        this.putNode(new WindNode(x, y, z, height, gameTime));
        return true;
    }

    public void write(@NotNull FriendlyByteBuf buf) {
        buf.writeLong(this.chunkPos.m_45588_());
        buf.m_130130_(this.nodes.size());
        for (Byte2ObjectMap.Entry e : this.nodes.byte2ObjectEntrySet()) {
            ((WindNode)e.getValue()).write(buf);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WindChunk windChunk = (WindChunk)o;
        return this.chunkPos.equals((Object)windChunk.chunkPos);
    }

    public int hashCode() {
        return this.chunkPos.hashCode();
    }
}

