/*
 * Decompiled with CFR 0.152.
 */
package tictim.paraglider.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tictim.paraglider.ParagliderMod;
import tictim.paraglider.api.vessel.VesselContainer;
import tictim.paraglider.bargain.BargainContext;
import tictim.paraglider.bargain.BargainHandler;
import tictim.paraglider.config.PlayerStateMapConfig;
import tictim.paraglider.contents.BargainTypeRegistry;
import tictim.paraglider.impl.movement.PlayerStateMap;

public final class ParagliderCommands {
    private ParagliderCommands() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"paraglider").then(ParagliderCommands.queryVessel())).then(ParagliderCommands.setVessel(SetType.set))).then(ParagliderCommands.setVessel(SetType.give))).then(ParagliderCommands.setVessel(SetType.take))).then(ParagliderCommands.bargain())).then(ParagliderCommands.reloadPlayerStates());
    }

    private static LiteralArgumentBuilder<CommandSourceStack> queryVessel() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"query").requires(s -> s.m_6761_(1))).then(Commands.m_82127_((String)ResourceType.HEART.name).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> ResourceType.HEART.tell((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(Commands.m_82127_((String)ResourceType.STAMINA.name).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> ResourceType.STAMINA.tell((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))))).then(Commands.m_82127_((String)ResourceType.ESSENCE.name).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> ResourceType.ESSENCE.tell((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> setVessel(@NotNull SetType type) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)type.name()).requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)ResourceType.HEART.name).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ResourceType.HEART.run((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), type)))))).then(Commands.m_82127_((String)ResourceType.STAMINA.name).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ResourceType.STAMINA.run((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), type)))))).then(Commands.m_82127_((String)ResourceType.ESSENCE.name).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> ResourceType.ESSENCE.run((CommandSourceStack)ctx.getSource(), (Player)EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount"), type)))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> bargain() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"bargain").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"start").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"bargainType", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ctx -> ParagliderCommands.startBargain((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"bargainType"), null, null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).executes(ctx -> ParagliderCommands.startBargain((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"bargainType"), BlockPosArgument.m_264582_((CommandContext)ctx, (String)"pos"), null, null))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"advancement", (ArgumentType)ResourceLocationArgument.m_106984_()).executes(ctx -> ParagliderCommands.startBargain((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"bargainType"), BlockPosArgument.m_264582_((CommandContext)ctx, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"advancement"), null))).then(Commands.m_82129_((String)"lookAt", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> ParagliderCommands.startBargain((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"bargainType"), BlockPosArgument.m_264582_((CommandContext)ctx, (String)"pos"), ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"advancement"), Vec3Argument.m_120844_((CommandContext)ctx, (String)"lookAt")))))))))).then(Commands.m_82127_((String)"end").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> ParagliderCommands.endBargain((CommandSourceStack)ctx.getSource(), EntityArgument.m_91474_((CommandContext)ctx, (String)"player")))));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> reloadPlayerStates() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"reloadPlayerStates").requires(s -> s.m_6761_(3))).executes(context -> ParagliderCommands.reloadPlayerStates((CommandSourceStack)context.getSource()));
    }

    private static int startBargain(@NotNull CommandSourceStack source, @NotNull ServerPlayer player, @NotNull ResourceLocation bargainType, @Nullable BlockPos pos, @Nullable ResourceLocation advancement, @Nullable Vec3 lookAt) {
        if (BargainTypeRegistry.get().getFromID(player.m_284548_(), bargainType) == null) {
            source.m_81352_((Component)Component.m_237110_((String)"commands.paraglider.bargain.start.invalid_bargain_type", (Object[])new Object[]{bargainType}));
            return -1;
        }
        if (BargainHandler.initiate((Player)player, bargainType, pos, advancement, lookAt)) {
            source.m_288197_(() -> Component.m_237110_((String)"commands.paraglider.bargain.start.success", (Object[])new Object[]{player.m_5446_(), bargainType}), true);
            return 1;
        }
        source.m_81352_((Component)Component.m_237110_((String)"commands.paraglider.bargain.start.no_bargain", (Object[])new Object[]{player.m_5446_(), bargainType, pos}));
        return 0;
    }

    private static int endBargain(@NotNull CommandSourceStack source, @NotNull ServerPlayer player) {
        BargainContext bargain = BargainHandler.getBargain(player);
        if (bargain != null) {
            if (bargain.isFinished()) {
                source.m_81352_((Component)Component.m_237110_((String)"command.paraglider.bargain.end.already_finished", (Object[])new Object[]{player.m_5446_()}));
                return 0;
            }
            source.m_288197_(() -> Component.m_237110_((String)"command.paraglider.bargain.end.success", (Object[])new Object[]{player.m_5446_()}), true);
            bargain.markFinished();
            return 1;
        }
        source.m_81352_((Component)Component.m_237110_((String)"command.paraglider.bargain.end.no_bargain", (Object[])new Object[]{player.m_5446_()}));
        return -1;
    }

    private static int reloadPlayerStates(final @NotNull CommandSourceStack source) {
        MinecraftServer server = source.m_81377_();
        ParagliderMod.instance().getPlayerStateMapConfig().scheduleReload(server, new PlayerStateMapConfig.Callback(){

            @Override
            public void onSuccess(@NotNull PlayerStateMap stateMap, boolean updated) {
                source.m_288197_(() -> Component.m_237115_((String)"commands.paraglider.reload_player_states.success"), true);
            }

            @Override
            public void onFail(@NotNull PlayerStateMap stateMap, @NotNull RuntimeException exception, boolean update) {
                source.m_81352_((Component)Component.m_237115_((String)"commands.paraglider.reload_player_states.fail"));
            }
        });
        return 1;
    }

    private static enum SetType {
        set,
        give,
        take;

    }

    private static enum ResourceType {
        HEART("heart_container"),
        STAMINA("stamina_vessel"),
        ESSENCE("essence");

        private final String name;
        private final String getResult;
        private final String setSuccess;
        private final String setNoChange;
        private final String giveSuccess;
        private final String takeSuccess;
        private final String setTooHigh;
        private final String setTooLow;
        private final String setFail;
        private final String giveFail;
        private final String takeFail;

        private ResourceType(String name) {
            this.name = name;
            this.getResult = "commands.paraglider.get." + name + ".result";
            this.setSuccess = "commands.paraglider.set." + name + ".success";
            this.setNoChange = "commands.paraglider.set." + name + ".no_change";
            this.giveSuccess = "commands.paraglider.give." + name + ".success";
            this.takeSuccess = "commands.paraglider.take." + name + ".success";
            this.setTooHigh = "commands.paraglider.set." + name + ".too_high";
            this.setTooLow = "commands.paraglider.set." + name + ".too_low";
            this.setFail = "commands.paraglider.set." + name + ".fail";
            this.giveFail = "commands.paraglider.give." + name + ".fail";
            this.takeFail = "commands.paraglider.take." + name + ".fail";
        }

        private int tell(@NotNull CommandSourceStack source, @NotNull Player player) {
            VesselContainer vessels = VesselContainer.get(player);
            int value = switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEART -> vessels.heartContainer();
                case STAMINA -> vessels.staminaVessel();
                case ESSENCE -> vessels.essence();
            };
            source.m_288197_(() -> Component.m_237110_((String)this.getResult, (Object[])new Object[]{player.m_5446_(), value}), false);
            return value;
        }

        private int run(@NotNull CommandSourceStack source, @NotNull Player player, int amount, @NotNull SetType type) {
            VesselContainer vessels = VesselContainer.get(player);
            switch (type) {
                case set: {
                    switch (this.set(vessels, amount, false, true)) {
                        case OK: {
                            source.m_288197_(() -> Component.m_237110_((String)this.setSuccess, (Object[])new Object[]{player.m_5446_(), amount}), true);
                            return 1;
                        }
                        case NO_CHANGE: {
                            source.m_288197_(() -> Component.m_237110_((String)this.setNoChange, (Object[])new Object[]{player.m_5446_(), amount}), true);
                            return 0;
                        }
                        case TOO_HIGH: {
                            source.m_81352_((Component)Component.m_237110_((String)this.setTooHigh, (Object[])new Object[]{amount}));
                            return -1;
                        }
                        case TOO_LOW: {
                            source.m_81352_((Component)Component.m_237110_((String)this.setTooLow, (Object[])new Object[]{amount}));
                            return -1;
                        }
                        case FAIL: {
                            source.m_81352_((Component)Component.m_237115_((String)this.setFail));
                            return -1;
                        }
                    }
                    break;
                }
                case give: {
                    if (this.give(vessels, amount, true, false) != amount) {
                        source.m_81352_((Component)Component.m_237110_((String)this.giveFail, (Object[])new Object[]{player.m_5446_(), amount}));
                        return 0;
                    }
                    source.m_288197_(() -> Component.m_237110_((String)this.giveSuccess, (Object[])new Object[]{player.m_5446_(), amount}), true);
                    return this.give(vessels, amount, false, true);
                }
                case take: {
                    if (this.take(vessels, amount, true, false) != amount) {
                        source.m_81352_((Component)Component.m_237110_((String)this.takeFail, (Object[])new Object[]{player.m_5446_(), amount}));
                        return 0;
                    }
                    source.m_288197_(() -> Component.m_237110_((String)this.takeSuccess, (Object[])new Object[]{player.m_5446_(), amount}), true);
                    return this.take(vessels, amount, false, true);
                }
            }
            throw new IllegalStateException("Unreachable");
        }

        @NotNull
        private VesselContainer.SetResult set(@NotNull VesselContainer vessels, int amount, boolean simulate, boolean playEffect) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEART -> vessels.setHeartContainer(amount, simulate, playEffect);
                case STAMINA -> vessels.setStaminaVessel(amount, simulate, playEffect);
                case ESSENCE -> vessels.setEssence(amount, simulate, playEffect);
            };
        }

        private int give(@NotNull VesselContainer vessels, int amount, boolean simulate, boolean playEffect) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEART -> vessels.giveHeartContainers(amount, simulate, playEffect);
                case STAMINA -> vessels.giveStaminaVessels(amount, simulate, playEffect);
                case ESSENCE -> vessels.giveEssences(amount, simulate, playEffect);
            };
        }

        private int take(@NotNull VesselContainer vessels, int amount, boolean simulate, boolean playEffect) {
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEART -> vessels.takeHeartContainers(amount, simulate, playEffect);
                case STAMINA -> vessels.takeStaminaVessels(amount, simulate, playEffect);
                case ESSENCE -> vessels.takeEssences(amount, simulate, playEffect);
            };
        }
    }
}

