/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteLoader;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LeafTypeLoader
implements PreparableReloadListener {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final ResourceLocation LEAVES_ATLAS = new ResourceLocation("fallingleaves", "leaves");
    private static final FileToIdConverter PARTICLE_LISTER = FileToIdConverter.m_246568_((String)"fallingleaves/leaftypes");
    private final TextureAtlas textureAtlas;
    private final Map<ResourceLocation, ParticleEngine.MutableSpriteSet> spriteSets = Maps.newHashMap();

    @Nullable
    public SpriteSet getSpriteSet(ResourceLocation leafType) {
        return (SpriteSet)this.spriteSets.get(leafType);
    }

    public LeafTypeLoader(TextureManager manager) {
        this.textureAtlas = new TextureAtlas(LEAVES_ATLAS);
        manager.m_118495_(this.textureAtlas.m_118330_(), (AbstractTexture)this.textureAtlas);
    }

    @NotNull
    public CompletableFuture<Void> m_5540_(@NotNull PreparableReloadListener.PreparationBarrier stage, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller p_10640_, @NotNull ProfilerFiller p_10641_, @NotNull Executor pBackgroundExecutor, @NotNull Executor p_10643_) {
        CompletionStage textures = CompletableFuture.supplyAsync(() -> PARTICLE_LISTER.m_247457_(resourceManager).entrySet(), pBackgroundExecutor).thenApplyAsync(list -> list.stream().map(entry -> {
            record LeafType(ResourceLocation type, Collection<ResourceLocation> textures) {
                public LeafType(ResourceLocation type) {
                    this(type, Collections.emptyList());
                }
            }
            LeafType leafType;
            block8: {
                ResourceLocation key = PARTICLE_LISTER.m_245273_((ResourceLocation)entry.getKey());
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonObject object = GsonHelper.m_13859_((Reader)reader);
                    leafType = new LeafType(key, StreamSupport.stream(object.get("textures").getAsJsonArray().spliterator(), false).map(JsonElement::getAsString).map(ResourceLocation::new).toList());
                    if (reader == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return new LeafType(key);
                    }
                }
                ((Reader)reader).close();
            }
            return leafType;
        }).collect(Collectors.toList()));
        CompletionStage preparations = SpriteLoader.m_245483_((TextureAtlas)this.textureAtlas).m_260881_(resourceManager, LEAVES_ATLAS, 0, pBackgroundExecutor).thenCompose(SpriteLoader.Preparations::m_246429_);
        return ((CompletableFuture)CompletableFuture.allOf(new CompletableFuture[]{textures, preparations}).thenCompose(arg_0 -> ((PreparableReloadListener.PreparationBarrier)stage).m_6769_(arg_0))).thenAcceptAsync(arg_0 -> this.lambda$reload$4((CompletableFuture)preparations, (CompletableFuture)textures, arg_0), p_10643_);
    }

    public void close() {
        this.textureAtlas.m_118329_();
    }

    @NotNull
    public String m_7812_() {
        return "Leaf Type";
    }

    private /* synthetic */ void lambda$reload$4(CompletableFuture preparations, CompletableFuture textures, Void param) {
        SpriteLoader.Preparations spriteloader$preparations = (SpriteLoader.Preparations)preparations.join();
        this.textureAtlas.m_247065_(spriteloader$preparations);
        HashSet set = new HashSet();
        HashSet<ResourceLocation> existingSprites = new HashSet<ResourceLocation>(this.spriteSets.keySet());
        TextureAtlasSprite textureatlassprite = spriteloader$preparations.f_243912_();
        ((Collection)textures.join()).forEach(leafType -> {
            if (!leafType.textures.isEmpty()) {
                ArrayList<TextureAtlasSprite> list = new ArrayList<TextureAtlasSprite>();
                for (ResourceLocation resourceLocation : leafType.textures) {
                    TextureAtlasSprite sprite = (TextureAtlasSprite)spriteloader$preparations.f_243807_().get(resourceLocation);
                    if (sprite == null) {
                        set.add(resourceLocation);
                        list.add(textureatlassprite);
                        continue;
                    }
                    list.add(sprite);
                }
                ParticleEngine.MutableSpriteSet mutableSpriteSet = this.spriteSets.get(leafType.type);
                existingSprites.remove(leafType.type);
                if (mutableSpriteSet == null) {
                    mutableSpriteSet = new ParticleEngine.MutableSpriteSet();
                    this.spriteSets.put(leafType.type, mutableSpriteSet);
                }
                mutableSpriteSet.m_107415_(list);
            }
        });
        existingSprites.forEach(this.spriteSets::remove);
        if (!set.isEmpty()) {
            LOGGER.warn("Missing particle sprites: {}", (Object)set.stream().sorted().map(ResourceLocation::toString).collect(Collectors.joining(",")));
        }
    }
}

