/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.pipez.utils;

import de.maxhenkel.pipez.capabilities.ModCapabilities;
import de.maxhenkel.pipez.corelib.tag.SingleElementTag;
import de.maxhenkel.pipez.corelib.tag.Tag;
import de.maxhenkel.pipez.utils.GasTag;
import java.util.AbstractMap;
import java.util.Map;
import javax.annotation.Nullable;
import mekanism.api.MekanismAPI;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTags;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.Pigment;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.providers.IGasProvider;
import mekanism.api.providers.IInfuseTypeProvider;
import mekanism.api.providers.IPigmentProvider;
import mekanism.api.providers.ISlurryProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class GasUtils {
    public static final Tag<Chemical> EMPTY_GAS_TAG = new SingleElementTag<Chemical>(((Gas)GasStack.EMPTY.getType()).getRegistryName(), GasStack.EMPTY.getType());
    public static final Tag<Chemical> EMPTY_INFUSION_TAG = new SingleElementTag<Chemical>(((InfuseType)InfusionStack.EMPTY.getType()).getRegistryName(), InfusionStack.EMPTY.getType());
    public static final Tag<Chemical> EMPTY_PIGMENT_TAG = new SingleElementTag<Chemical>(((Pigment)PigmentStack.EMPTY.getType()).getRegistryName(), PigmentStack.EMPTY.getType());
    public static final Tag<Chemical> EMPTY_SLURRY_TAG = new SingleElementTag<Chemical>(((Slurry)SlurryStack.EMPTY.getType()).getRegistryName(), SlurryStack.EMPTY.getType());

    @Nullable
    public static Map.Entry<ChemicalType, Tag<? extends Chemical>> getGas(String name, boolean nullIfNotExists) {
        for (ChemicalType type : ChemicalType.values()) {
            Tag<? extends Chemical> tag = GasUtils.getGas(name, true, type);
            if (tag == null) continue;
            return new AbstractMap.SimpleEntry<ChemicalType, Tag<? extends Chemical>>(type, tag);
        }
        return new AbstractMap.SimpleEntry<ChemicalType, Tag<? extends Chemical>>(ChemicalType.GAS, nullIfNotExists ? null : EMPTY_GAS_TAG);
    }

    @Nullable
    public static Tag<? extends Chemical> getGas(String name, boolean nullIfNotExists, ChemicalType type) {
        ResourceLocation id;
        if (name.startsWith("#")) {
            return GasUtils.getGasTag(name.substring(1), nullIfNotExists, type);
        }
        IForgeRegistry<? extends Chemical> registry = GasUtils.getRegistry(type);
        if (!registry.containsKey(id = new ResourceLocation(name))) {
            return nullIfNotExists ? null : GasUtils.getEmptyStack(type);
        }
        Chemical gas = (Chemical)registry.getValue(new ResourceLocation(name));
        if (gas == null) {
            return nullIfNotExists ? null : GasUtils.getEmptyStack(type);
        }
        return new SingleElementTag<Chemical>(id, gas);
    }

    @Nullable
    public static Tag<Chemical> getGasTag(String name, boolean nullIfNotExists, ChemicalType type) {
        ResourceLocation id = new ResourceLocation(name);
        TagKey tagKey = null;
        ITagManager tags = null;
        switch (type) {
            case INFUSION: {
                tagKey = ChemicalTags.INFUSE_TYPE.tag(id);
                tags = MekanismAPI.infuseTypeRegistry().tags();
                break;
            }
            case PIGMENT: {
                tagKey = ChemicalTags.PIGMENT.tag(id);
                tags = MekanismAPI.pigmentRegistry().tags();
                break;
            }
            case SLURRY: {
                tagKey = ChemicalTags.SLURRY.tag(id);
                tags = MekanismAPI.slurryRegistry().tags();
                break;
            }
            default: {
                tagKey = ChemicalTags.GAS.tag(id);
                tags = MekanismAPI.gasRegistry().tags();
            }
        }
        if (tags == null) {
            return nullIfNotExists ? null : GasUtils.getEmptyStack(type);
        }
        ITag tag = tags.getTag(tagKey);
        if (tag.isEmpty()) {
            return nullIfNotExists ? null : GasUtils.getEmptyStack(type);
        }
        return new GasTag((ITag<Chemical>)tag, id, type);
    }

    @Nullable
    public static ChemicalStack getGasContained(ItemStack stack) {
        for (Capability<? extends IChemicalHandler> capability : GasUtils.getChemicalCapabilities()) {
            ChemicalStack gas = GasUtils.getGasContained(stack, capability);
            if (gas == null || gas.isEmpty()) continue;
            return gas;
        }
        return null;
    }

    @Nullable
    public static ChemicalStack getGasContained(ItemStack stack, Capability<? extends IChemicalHandler> capability) {
        LazyOptional c = stack.getCapability(capability);
        IChemicalHandler handler = (IChemicalHandler)c.orElse(null);
        if (handler == null) {
            return null;
        }
        if (handler.getTanks() <= 0) {
            return null;
        }
        return handler.getChemicalInTank(0).copy();
    }

    public static Tag<Chemical> getEmptyStack(ChemicalType type) {
        switch (type) {
            case INFUSION: {
                return EMPTY_INFUSION_TAG;
            }
            case SLURRY: {
                return EMPTY_SLURRY_TAG;
            }
            case PIGMENT: {
                return EMPTY_PIGMENT_TAG;
            }
        }
        return EMPTY_GAS_TAG;
    }

    public static IForgeRegistry<? extends Chemical> getRegistry(ChemicalType type) {
        switch (type) {
            case INFUSION: {
                return MekanismAPI.infuseTypeRegistry();
            }
            case PIGMENT: {
                return MekanismAPI.pigmentRegistry();
            }
            case SLURRY: {
                return MekanismAPI.slurryRegistry();
            }
        }
        return MekanismAPI.gasRegistry();
    }

    public static ResourceLocation getResourceLocation(Chemical chemical) {
        switch (ChemicalType.getTypeFor((Chemical)chemical)) {
            case INFUSION: {
                return MekanismAPI.infuseTypeRegistry().getKey((Object)((InfuseType)chemical));
            }
            case PIGMENT: {
                return MekanismAPI.pigmentRegistry().getKey((Object)((Pigment)chemical));
            }
            case SLURRY: {
                return MekanismAPI.slurryRegistry().getKey((Object)((Slurry)chemical));
            }
        }
        return MekanismAPI.gasRegistry().getKey((Object)((Gas)chemical));
    }

    public static ChemicalStack createChemicalStack(Chemical chemical, long amount) {
        switch (ChemicalType.getTypeFor((Chemical)chemical)) {
            case GAS: {
                return new GasStack((IGasProvider)((Gas)chemical), amount);
            }
            case INFUSION: {
                return new InfusionStack((IInfuseTypeProvider)((InfuseType)chemical), amount);
            }
            case PIGMENT: {
                return new PigmentStack((IPigmentProvider)((Pigment)chemical), amount);
            }
            case SLURRY: {
                return new SlurryStack((ISlurryProvider)((Slurry)chemical), amount);
            }
        }
        return GasStack.EMPTY;
    }

    public static Capability<? extends IChemicalHandler>[] getChemicalCapabilities() {
        return new Capability[]{ModCapabilities.GAS_HANDLER_CAPABILITY, ModCapabilities.INFUSION_HANDLER_CAPABILITY, ModCapabilities.PIGMENT_HANDLER_CAPABILITY, ModCapabilities.SLURRY_HANDLER_CAPABILITY};
    }

    public static boolean hasChemicalCapability(ICapabilityProvider provider, Direction facing) {
        for (Capability<? extends IChemicalHandler> capability : GasUtils.getChemicalCapabilities()) {
            if (!provider.getCapability(capability, facing).isPresent()) continue;
            return true;
        }
        return false;
    }
}

