/*
 * Decompiled with CFR 0.152.
 */
package cool.bot.dewdropfarmland.block;

import cool.bot.botslib.util.RNG;
import cool.bot.botslib.util.Util;
import cool.bot.dewdropfarmland.Config;
import cool.bot.dewdropfarmland.tag.SturdyFarmlandBlockTags;
import cool.bot.dewdropfarmland.utils.CropHandlerUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.extensions.IForgeBlock;
import org.jetbrains.annotations.Nullable;

public class CustomFarmland
extends FarmBlock
implements IForgeBlock {
    public CustomFarmland(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!Config.noRandomTick) {
            super.m_213898_(state, level, pos, random);
        }
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ToolAction toolAction, boolean simulate) {
        ItemStack itemStack = context.m_43722_();
        if (!itemStack.canPerformAction(toolAction)) {
            return null;
        }
        if (ToolActions.SHOVEL_FLATTEN == toolAction && Config.shovelReverting) {
            return Blocks.f_50493_.m_49966_();
        }
        return super.getToolModifiedState(state, context, toolAction, simulate);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter world, BlockPos pos, Direction facing, IPlantable plantable) {
        PlantType plantType = plantable.getPlantType(world, pos.m_121945_(facing));
        return plantType == PlantType.CROP || plantType == PlantType.PLAINS;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_186460_(pos, (Block)this, 10);
        if (level.m_46758_(pos.m_7494_()) && Config.rainWatering) {
            Util.setMoist((ServerLevel)level, (BlockPos)pos);
        }
        if (level.m_6425_(pos.m_7494_()).m_76152_() == Fluids.f_76193_) {
            Util.setMoist((ServerLevel)level, (BlockPos)pos);
        }
        if (!Config.dailyReset || !((GameRules.BooleanValue)level.m_46469_().m_46170_(GameRules.f_46140_)).m_46223_()) {
            return;
        }
        long dayTime = level.m_46468_() % 24000L;
        if (dayTime >= (long)Config.dailyTimeMin && dayTime < (long)(Config.dailyTimeMin + 10)) {
            boolean hydrated;
            BlockState farmland = level.m_8055_(pos);
            boolean bl = hydrated = Config.checkSprinklers && CropHandlerUtils.isNearSprinkler((LevelReader)level, pos);
            if (!hydrated && !Util.isMoistWaterable((ServerLevel)level, (BlockPos)pos)) {
                if (RNG.mc_ihundo((RandomSource)random, (int)Config.dailyDecayChance)) {
                    level.m_7731_(pos, Blocks.f_50493_.m_49966_(), 3);
                }
            } else {
                BlockPos abovePos = pos.m_7494_();
                BlockState crop = level.m_8055_(abovePos);
                if (!(crop.m_60734_() instanceof AirBlock)) {
                    CropHandlerUtils.growCrop(crop, level, abovePos, farmland, random, false);
                }
                if (RNG.mc_ihundo((RandomSource)random, (int)Config.dailyDryChance)) {
                    CropBlock cropBlock;
                    Block block;
                    if (hydrated && Util.isDryWaterable((ServerLevel)level, (BlockPos)pos)) {
                        Util.setMoist((ServerLevel)level, (BlockPos)pos);
                    }
                    if (!hydrated && farmland.m_204336_(SturdyFarmlandBlockTags.HYDRATING_FARMLAND) && (block = crop.m_60734_()) instanceof CropBlock && (double)(cropBlock = (CropBlock)block).m_52305_(crop) < Math.floor((float)cropBlock.m_7419_() / 2.0f)) {
                        hydrated = true;
                    }
                    if (farmland.m_204336_(SturdyFarmlandBlockTags.DELUXE_HYDRATING_FARMLAND)) {
                        hydrated = true;
                    }
                    if (!hydrated) {
                        Util.setDry((ServerLevel)level, (BlockPos)pos);
                    }
                }
            }
        }
        if (!Config.sturdyFarmland) {
            super.m_213897_(state, level, pos, random);
        }
    }

    public boolean m_7898_(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return true;
    }

    public void onBlockStateChange(LevelReader level, BlockPos pos, BlockState oldState, BlockState newState) {
        if (!level.m_5776_() && (Config.rainWatering || Config.dailyReset)) {
            ((ServerLevel)level).m_186460_(pos, (Block)this, 10);
        }
        super.onBlockStateChange(level, pos, oldState, newState);
    }
}

