/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.guiclock_common_forge.events;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.guiclock_common_forge.config.ConfigHandler;
import java.awt.Color;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class GUIEvent {
    private static final Minecraft mc = Minecraft.m_91087_();
    private static String daystring = "";

    public static void renderOverlay(GuiGraphics guiGraphics, float tickDelta) {
        Collection activeeffects;
        if (GUIEvent.mc.f_91066_.f_92063_) {
            return;
        }
        boolean gametimeb = ConfigHandler.mustHaveClockInInventoryForGameTime;
        boolean realtimeb = ConfigHandler.mustHaveClockInInventoryForRealTime;
        boolean found = true;
        if ((gametimeb || realtimeb) && !(found = GUIEvent.mc.f_91074_.m_21206_().m_41720_().equals(Items.f_42524_))) {
            Inventory inv = GUIEvent.mc.f_91074_.m_150109_();
            for (int n = 0; n <= 35; ++n) {
                if (!inv.m_8020_(n).m_41720_().equals(Items.f_42524_)) continue;
                found = true;
                break;
            }
        }
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        Font fontRenderer = GUIEvent.mc.f_91062_;
        Window scaled = mc.m_91268_();
        int width = scaled.m_85445_();
        int heightoffset = ConfigHandler.clockHeightOffset;
        if (heightoffset < 5) {
            heightoffset = 5;
        }
        if (ConfigHandler.lowerClockWhenPlayerHasEffects && (activeeffects = GUIEvent.mc.f_91074_.m_21220_()).size() > 0) {
            boolean haspositive = false;
            boolean hasnegative = false;
            for (MobEffectInstance effect : activeeffects) {
                if (!effect.m_19572_()) continue;
                if (effect.m_19544_().m_19483_().equals((Object)MobEffectCategory.BENEFICIAL)) {
                    haspositive = true;
                } else {
                    hasnegative = true;
                }
                if (!haspositive || !hasnegative) continue;
                break;
            }
            if (hasnegative && haspositive) {
                heightoffset += 50;
            } else if (haspositive && !hasnegative) {
                heightoffset += 25;
            }
        }
        if (ConfigHandler.showOnlyMinecraftClockIcon) {
            if (gametimeb && !found) {
                return;
            }
            int xcoord = ConfigHandler.clockPositionIsLeft ? 20 : (ConfigHandler.clockPositionIsCenter ? width / 2 - 8 : width - 20);
            guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42524_), xcoord += ConfigHandler.clockWidthOffset, heightoffset);
        } else {
            int daycoord;
            Object time;
            String realtime = StringFunctions.getPCLocalTime((boolean)ConfigHandler._24hourformat, (boolean)ConfigHandler.showRealTimeSeconds);
            if (ConfigHandler.showBothTimes) {
                if (gametimeb && realtimeb) {
                    if (!found) {
                        return;
                    }
                    time = GUIEvent.getGameTime() + " | " + realtime;
                } else {
                    time = !found && gametimeb ? realtime : (!found && realtimeb ? GUIEvent.getGameTime() : GUIEvent.getGameTime() + " | " + realtime);
                }
            } else if (ConfigHandler.showRealTime) {
                if (realtimeb && !found) {
                    return;
                }
                time = realtime;
            } else {
                if (gametimeb && !found) {
                    return;
                }
                time = GUIEvent.getGameTime();
            }
            if (((String)time).equals("")) {
                return;
            }
            int stringWidth = fontRenderer.m_92895_((String)time);
            int daystringWidth = fontRenderer.m_92895_(daystring);
            Color colour = new Color(ConfigHandler.RGB_R, ConfigHandler.RGB_G, ConfigHandler.RGB_B, 255);
            if (ConfigHandler.clockPositionIsLeft) {
                xcoord = 5;
                daycoord = 5;
            } else if (ConfigHandler.clockPositionIsCenter) {
                xcoord = width / 2 - stringWidth / 2;
                daycoord = width / 2 - daystringWidth / 2;
            } else {
                xcoord = width - stringWidth - 5;
                daycoord = width - daystringWidth - 5;
            }
            daycoord += ConfigHandler.clockWidthOffset;
            int rgb = colour.getRGB();
            GUIEvent.drawText(fontRenderer, guiGraphics, (String)time, xcoord += ConfigHandler.clockWidthOffset, heightoffset, rgb, ConfigHandler.drawTextShadow);
            if (!daystring.equals("")) {
                GUIEvent.drawText(fontRenderer, guiGraphics, daystring, daycoord, heightoffset + 10, rgb, ConfigHandler.drawTextShadow);
            }
        }
        poseStack.m_85849_();
    }

    private static void drawText(Font font, GuiGraphics guiGraphics, String content, int x, int y, int rgb, boolean drawShadow) {
        guiGraphics.m_280614_(font, (Component)Component.m_237113_((String)content), x, y, rgb, drawShadow);
    }

    private static String getGameTime() {
        int gametime = (int)GUIEvent.mc.f_91073_.m_46468_();
        int daysplayed = 0;
        while (gametime >= 24000) {
            gametime -= 24000;
            ++daysplayed;
        }
        if (ConfigHandler.showDaysPlayedWorld) {
            daystring = "Day " + daysplayed;
        }
        int time = gametime >= 18000 ? gametime - 18000 : 6000 + gametime;
        String suffix = "";
        if (!ConfigHandler._24hourformat) {
            if (time >= 13000) {
                time -= 12000;
                suffix = " PM";
            } else if (time >= 12000) {
                suffix = " PM";
            } else {
                suffix = " AM";
                if (time <= 999) {
                    time += 12000;
                }
            }
        }
        StringBuilder stringtime = new StringBuilder("" + time / 10);
        for (int n = stringtime.length(); n < 4; ++n) {
            stringtime.insert(0, "0");
        }
        String[] strsplit = stringtime.toString().split("");
        int minutes = (int)Math.floor(Double.parseDouble(strsplit[2] + strsplit[3]) / 100.0 * 60.0);
        String sm = "" + minutes;
        if (minutes < 10) {
            sm = "0" + minutes;
        }
        stringtime = !ConfigHandler._24hourformat && strsplit[0].equals("0") ? new StringBuilder(strsplit[1] + ":" + sm.charAt(0) + sm.charAt(1)) : new StringBuilder(strsplit[0] + strsplit[1] + ":" + sm.charAt(0) + sm.charAt(1));
        return stringtime + suffix;
    }
}

