/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile;

import dev.djefrey.colorwheel.accessors.ShaderPackAccessor;
import dev.djefrey.colorwheel.compile.ClrwlCompilation;
import dev.djefrey.colorwheel.compile.ClrwlPipeline;
import dev.djefrey.colorwheel.compile.ClrwlPipelineStage;
import dev.djefrey.colorwheel.compile.ClrwlProgram;
import dev.djefrey.colorwheel.compile.ClrwlProgramSource;
import dev.djefrey.colorwheel.compile.ClrwlProgramSources;
import dev.djefrey.colorwheel.compile.ClrwlShaderKey;
import dev.djefrey.colorwheel.shaderpack.ClrwlProgramId;
import dev.djefrey.colorwheel.shaderpack.ClrwlShaderProperties;
import dev.engine_room.flywheel.backend.compile.FlwPrograms;
import dev.engine_room.flywheel.backend.compile.core.Compilation;
import dev.engine_room.flywheel.backend.gl.GlCompat;
import dev.engine_room.flywheel.backend.glsl.ShaderSources;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import dev.engine_room.flywheel.lib.util.ResourceUtil;
import java.io.File;
import java.io.FileWriter;
import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.helpers.StringPair;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.WorldRenderingPipeline;
import net.irisshaders.iris.shaderpack.ShaderPack;
import net.irisshaders.iris.shaderpack.materialmap.NamespacedId;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;

public class ClrwlPipelineCompiler {
    private final ShaderSources sources;
    private final ClrwlPipeline pipeline;
    private final ShaderPack pack;
    private final NamespacedId dimension;
    private final ClrwlProgramSources patchedSources;

    public ClrwlPipelineCompiler(ShaderSources sources, ClrwlPipeline pipeline, ShaderPack pack, NamespacedId dimension) {
        this.sources = sources;
        this.pipeline = pipeline;
        this.pack = pack;
        this.dimension = dimension;
        this.patchedSources = new ClrwlProgramSources();
    }

    public ClrwlProgram get(ClrwlShaderKey key) {
        return this.compile(key);
    }

    private ClrwlProgram compile(ClrwlShaderKey key) {
        WorldRenderingPipeline worldPipeline = Iris.getPipelineManager().getPipelineNullable();
        if (worldPipeline instanceof IrisRenderingPipeline) {
            IrisRenderingPipeline irisPipeline = (IrisRenderingPipeline)worldPipeline;
            ProgramSet programSet = this.pack.getProgramSet(this.dimension);
            ClrwlShaderProperties properties = ((ShaderPackAccessor)this.pack).colorwheel$getProperties();
            boolean isShadow = key.isShadow();
            String instanceName = ResourceUtil.toDebugFileNameNoExtension((ResourceLocation)key.instanceType().vertexShader());
            String materialName = ResourceUtil.toDebugFileNameNoExtension((ResourceLocation)key.material().vertexSource());
            String contextName = key.context().nameLowerCase();
            String oitName = key.oit().name;
            ClrwlProgramId baseProgramId = ClrwlProgramId.fromTransparency(key.transparency(), isShadow);
            String name = String.format("%s/%s/%s_%s%s", baseProgramId.programName(), instanceName, materialName, contextName, oitName);
            ClrwlProgramSources.PatchedSources irisSources = this.patchedSources.getSources(baseProgramId, key.oit(), programSet, irisPipeline);
            String vertex = this.compileStage(this.pipeline.vertex(), key, irisPipeline, irisSources);
            Optional<String> geometry = this.compileOptionalStage(this.pipeline.geometry(), key, irisPipeline, irisSources);
            String fragment = this.compileStage(this.pipeline.fragment(), key, irisPipeline, irisSources);
            String basePath = "/pipeline/" + Iris.getCurrentPackName() + "/" + baseProgramId.programName() + "/" + key.getPath();
            ClrwlPipelineCompiler.dumpSources(basePath + ".vsh", vertex);
            geometry.ifPresent(sh -> ClrwlPipelineCompiler.dumpSources(basePath + ".gsh", sh));
            ClrwlPipelineCompiler.dumpSources(basePath + ".fsh", fragment);
            ClrwlProgramSource customSource = new ClrwlProgramSource(name, vertex, geometry, fragment);
            return ClrwlProgram.createProgram(name, baseProgramId, customSource, properties, irisPipeline.getCustomUniforms(), irisPipeline);
        }
        return null;
    }

    private Optional<String> compileOptionalStage(ClrwlPipelineStage<ClrwlShaderKey> stage, ClrwlShaderKey key, IrisRenderingPipeline irisPipeline, ClrwlProgramSources.PatchedSources irisSources) {
        if (irisSources.geometry().isPresent()) {
            return Optional.of(this.compileStage(stage, key, irisPipeline, irisSources));
        }
        return Optional.empty();
    }

    private String compileStage(ClrwlPipelineStage<ClrwlShaderKey> stage, ClrwlShaderKey key, IrisRenderingPipeline irisPipeline, ClrwlProgramSources.PatchedSources irisSources) {
        ProgramSet programSet = this.pack.getProgramSet(this.dimension);
        ClrwlShaderProperties properties = ((ShaderPackAccessor)this.pack).colorwheel$getProperties();
        ClrwlCompilation compile = new ClrwlCompilation(irisPipeline, programSet, properties, irisSources, this.sources);
        compile.version(GlCompat.MAX_GLSL_VERSION);
        for (String string : this.pipeline.extensions()) {
            compile.requireExtension(string);
        }
        for (String string : stage.extensions()) {
            compile.enableExtension(string);
        }
        for (StringPair stringPair : stage.defines()) {
            compile.define(stringPair);
        }
        stage.compile().accept(key, compile);
        for (BiFunction biFunction : stage.fetchers()) {
            ClrwlPipelineCompiler.expand((SourceComponent)biFunction.apply(key, compile), compile::appendComponent);
        }
        return compile.getShaderCode();
    }

    private static void expand(SourceComponent rootSource, Consumer<SourceComponent> out) {
        if (rootSource == null) {
            return;
        }
        LinkedHashSet<SourceComponent> included = new LinkedHashSet<SourceComponent>();
        ClrwlPipelineCompiler.recursiveDepthFirstInclude(included, rootSource);
        included.add(rootSource);
        included.forEach(out);
    }

    private static void recursiveDepthFirstInclude(Set<SourceComponent> included, SourceComponent component) {
        for (SourceComponent include : component.included()) {
            ClrwlPipelineCompiler.recursiveDepthFirstInclude(included, include);
        }
        included.addAll(component.included());
    }

    private static void dumpSources(String fileName, String source) {
        boolean shouldDump;
        boolean bl = shouldDump = Compilation.DUMP_SHADER_SOURCE || Iris.getIrisConfig().areDebugOptionsEnabled();
        if (!shouldDump) {
            return;
        }
        File file = new File(new File(Minecraft.m_91087_().f_91069_, "colorwheel_sources"), fileName);
        file.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(file);){
            writer.write(source);
        }
        catch (Exception e) {
            FlwPrograms.LOGGER.error("Could not dump source.", (Throwable)e);
        }
    }

    public static enum OitMode {
        OFF("", ""),
        DEPTH_RANGE("CLRWL_DEPTH_RANGE", "_depth_range"),
        GENERATE_COEFFICIENTS("CLRWL_COLLECT_COEFFS", "_generate_coefficients"),
        EVALUATE("CLRWL_EVALUATE", "_resolve");

        public final String define;
        public final String name;

        private OitMode(String define, String name) {
            this.define = define;
            this.name = name;
        }
    }
}

