/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile;

import dev.djefrey.colorwheel.compile.ClrwlProgramSources;
import dev.djefrey.colorwheel.shaderpack.ClrwlShaderProperties;
import dev.engine_room.flywheel.backend.glsl.GlslVersion;
import dev.engine_room.flywheel.backend.glsl.ShaderSources;
import dev.engine_room.flywheel.backend.glsl.SourceComponent;
import java.util.ArrayList;
import java.util.List;
import net.irisshaders.iris.helpers.StringPair;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.shaderpack.programs.ProgramSet;
import org.jetbrains.annotations.Nullable;

public class ClrwlCompilation {
    public final StringBuilder sources = new StringBuilder();
    public final List<StringPair> defines = new ArrayList<StringPair>();
    public final List<String> extensions = new ArrayList<String>();
    private final IrisRenderingPipeline pipeline;
    private final ProgramSet programSet;
    private final ClrwlShaderProperties properties;
    private final ClrwlProgramSources.PatchedSources irisSources;
    private final ShaderSources sourceLoader;

    public ClrwlCompilation(IrisRenderingPipeline pipeline, ProgramSet programSet, ClrwlShaderProperties properties, ClrwlProgramSources.PatchedSources irisSources, ShaderSources sourceLoader) {
        this.pipeline = pipeline;
        this.programSet = programSet;
        this.properties = properties;
        this.irisSources = irisSources;
        this.sourceLoader = sourceLoader;
    }

    public void version(GlslVersion version) {
        this.sources.append("#version ").append(version.version).append('\n');
    }

    public void enableExtension(String ext) {
        this.sources.append("#extension ").append(ext).append(" : enable\n");
    }

    public void requireExtension(String ext) {
        this.sources.append("#extension ").append(ext).append(" : require\n");
    }

    public void define(StringPair pair) {
        this.defines.add(pair);
        this.sources.append("#define ").append(pair.key()).append(' ').append(pair.value()).append('\n');
    }

    public void define(String key, String value) {
        this.define(new StringPair(key, value));
    }

    public void define(String key) {
        this.define(new StringPair(key, ""));
    }

    public void appendComponent(SourceComponent component) {
        if (component == null) {
            return;
        }
        this.sources.append("\n// ----- ").append(component.name()).append(" -----\n");
        this.sources.append(component.source());
    }

    public String getShaderCode() {
        return this.sources.toString();
    }

    @Nullable
    public IrisRenderingPipeline getIrisPipeline() {
        return this.pipeline;
    }

    @Nullable
    public ProgramSet getProgramSet() {
        return this.programSet;
    }

    @Nullable
    public ClrwlShaderProperties getProperties() {
        return this.properties;
    }

    @Nullable
    public ClrwlProgramSources.PatchedSources getIrisSources() {
        return this.irisSources;
    }

    public ShaderSources getLoader() {
        return this.sourceLoader;
    }
}

